/* This is y4vm.h
   A part of the Y4vm library
   Copyright (C) 1998 Daniel Spangberg

   */

/*
  $Log$
  Revision 1.1  2001/10/30 13:52:34  daniels
  Initial revision

  Revision 1.20  1998/11/11 20:54:18  daniels
  Added new external interface.

  Revision 1.19  1998/10/29 01:31:14  daniels
  Added more flexible function management.

  Revision 1.18  1998/08/10 20:03:06  daniels
  Added dynamic memory handling.

  Revision 1.17  1998/06/23 10:49:32  daniels
  *** empty log message ***

  Revision 1.16  1998/06/22 15:43:06  daniels
  *** empty log message ***

  Revision 1.15  1998/04/20 23:59:17  daniels
  Added call

  Revision 1.14  1998/04/13 21:18:08  daniels
  Added itos and strcat

  Revision 1.13  1998/04/06 23:33:34  daniels
  Added interrupts

  Revision 1.12  1998/03/22 18:39:52  daniels
  Added vm_get_variable_value

  Revision 1.11  1998/03/03 18:05:25  daniels
  Added strcpy

  Revision 1.10  1998/02/06 20:01:10  daniel
  Added vm_invalidate

  Revision 1.9  1998/02/03 14:39:29  daniel
  Added some debugging functions, and modified how string works

  Revision 1.8  1998/02/02 20:35:35  daniel
  Added some functions

  Revision 1.7  1998/02/01 18:39:24  daniel
  *** empty log message ***

  Revision 1.6  1998/01/31 22:49:30  daniel
  Added variables

  Revision 1.5  1998/01/31 20:05:02  daniel
  Added vm_get_string_from_code

  Revision 1.4  1998/01/31 18:09:47  daniel
  Added better error messages through test_pop/push_stack

  Revision 1.3  1998/01/31 13:59:21  daniel
  Added get version string

  Revision 1.2  1998/01/30 18:36:35  daniel
  Created the virtual machine as an extensible virtual machine

  Revision 1.1  1998/01/30 09:42:21  daniel
  Initial revision

  */

#ifndef __y4vm__
#define __y4vm__

#define DEFAULT_INSTR_SIZE 16384
#define DEFAULT_STACK_SIZE 2048
#define DEFAULT_RSTACK_SIZE 2048
#define DEFAULT_DATA_SIZE 32768

#define WORD_INTERNAL 1
#define WORD_EXTERNAL 2
#define WORD_DOLLAR 3
#define WORD_VARDEC 4
#define WORD_COLON 5
#define WORD_SEMICOLON 6
#define WORD_IF 7
#define WORD_ELSE 8
#define WORD_THEN 9
#define WORD_VARIABLE 10
#define WORD_FUNCTION 11
#define WORD_NEW_EXTERNAL 12
#define WORD_TYPE 13
#define WORD_DERIVED_TYPE 14

#define INSTR_INTERNAL 0
#define INSTR_FUNCTION_CALL 1
#define INSTR_FLOAT 2
#define INSTR_STRING 3
#define INSTR_JUMP 4
#define INSTR_IF 5
#define INSTR_ELSE 6
#define INSTR_THEN 7
#define INSTR_EXTERNAL 8
#define INSTR_DATA 9
#define INSTR_POINTER_TO_STRING 10
#define INSTR_VARIABLE 11
#define INSTR_VARALLOT 12
#define INSTR_POINTER_TO_FUNCTION 13
#define INSTR_JUMP_ONCE 14
#define INSTR_ENTER 15
#define INSTR_NEW_EXTERNAL 16

/* This should do :-) */
#define MAX_NESTED_STATEMENTS 1024
#define N_IF 0
#define N_ELSE 1
#define N_FN 2
#define N_TYPE 3

#define I_DUP 0
#define I_DROP 1
#define I_PLUS 2
#define I_MINUS 3
#define I_EMIT 4
#define I_STOP 5
#define I_NOP 6
#define I_STAT 7
#define I_LIST 8
#define I_RET 9
#define I_MUL 10
#define I_DIV 11
#define I_POINT 12
#define I_DO 13
#define I_LOOP 14
#define I_R 15
#define I_G_R 16
#define I_R_G 17
#define I_GT 18
#define I_LT 19
#define I_EQ 20
#define I_GTE1 21
#define I_GTE2 22
#define I_LTE1 23
#define I_LTE2 24
#define I_NE 25
#define I_PRINTF 26
#define I_BEGIN 27
#define I_UNTIL 28
#define I_SWAP 29
#define I_LOAD 30
#define I_STORE 31
#define I_LEAVE 32
#define I_MSTAT 33
#define I_CODEDUMP 34
#define I_CAST 35
#define I_STRING 36
#define I_STRCPY 37
#define I_INT 38
#define I_IRET 39
#define I_INSTALL 40
#define I_DEINSTALL 41
#define I__STOP 42
#define I_ITOS 43
#define I_STRCAT 44
#define I_CALL 45
#define I_MALLOC 46
#define I_FREE 47
#define I_NULL 48
#define MAX_INTERNALS 49 /* *Must* be larger than any internal instruction */

typedef unsigned char vm_instr_type;

typedef struct
{
  unsigned int address;
  unsigned int size;
  unsigned int offset;
  unsigned int local; /* This field will be 0 for global variable and a positive integer for local variable */
} varp;

typedef union
{
  double mydouble;
  unsigned int myint;
  varp myvarp;
  void *myptr;
} instr_data;

typedef struct
{
  vm_instr_type type;
  instr_data data;
} vm_instr;

#define VM_BASE_OF_MEMORY 1
#define VM_NULL_PTR 0

#define DATA_FLOAT 0
#define DATA_POINTER_TO_CODE 1
#define DATA_POINTER_TO_STRING 2
#define DATA_POINTER_TO_DATA 3
#define DATA_POINTER_TO_FLOAT 3 /* Yes should be the same! */
#define DATA_LOCAL_STORAGE 4
#define DATA_VM_DATA_LEN 5
#define DATA_POINTER_TO_FUNCTION 6
#define DATA_CAST 7
#define DATA_POINTER_TO_INTEGER 8
#define DATA_POINTER_TO_CODE_STRING 9
#define DATA_FLAG 10
#define DATA_FUNCTION_LEVEL 11

#define CAST_STRING 0
#define CAST_INTEGER 1

typedef unsigned char vm_data_type;

typedef union
{
  double mydouble;
  unsigned int myint;
  varp myvarp;
} data_data;

typedef struct
{
  vm_data_type type;
  data_data data;
} vm_data;

void vm_init();
void vm_clear();
void vm_deinit();

/* This is the new interface to external words */
void add_y4_word(char *name, void (*function)(void));

/* These functions are the old interface to external words. They are obsolete.
   They exist only for backwards compatibility.
   Do not use them for new projects. */
/* Handlers are *required* to ignore handles that they weren't given by vm */
void add_external_interface(void (*ehandler)(unsigned int handle));
unsigned int add_external_word(char *name);


void add_vm_send_data_handler(void (*esend)(char *str));
void vm_parse_and_compile(char *str);
void save_vm_state();
void restore_vm_state();
void vm_run();
void vm_stop();
int test_pop_stack(char *fn);
int test_push_stack(char *fn);
vm_data pop_stack();
void push_stack(vm_data data);
int vm_tick();
char *vm_get_version_string();
void vmputs(char *str);
char *vm_get_string_from_vm(vm_data_type type,unsigned int ptr);
void fiddle_with_pc(unsigned int i);
void vm_invalidate();
double vm_get_variable_value(char *name,int offset);
void vm_hw_interrupt(int nr);

#endif
