/* This is ymolrc.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <y4vm.h>

#define YMOLRCNAME ".ymolrc"
#define HOMEINSTALL ".ymol/"

static void save_default_ymolrc(char *name,char *homeinstall)
{
  FILE *ymolrc=fopen(name,"w");
  if (ymolrc==NULL)
    {
      printf("Can't open file %s for writing\n",name);
      exit(1);
    }
  fprintf(ymolrc,"( set up search paths )\n");
  fprintf(ymolrc,"'./' search-dir\n'%s' search-dir\n'/usr/local/lib/ymol/' search-dir\n'/opt/ymol/lib/' search-dir\n",homeinstall);
  if (getenv("YMOLDIR"))
    fprintf(ymolrc,"'%s/' search-dir\n",getenv("YMOLDIR"));
  fprintf(ymolrc,
	  "( some standard commands )\n"
	  "'stdlib' load\n"
	  "'rotations' load\n"
	  "'wait' load\n"
	  "'animate' load\n"
	  "'mdinterface' load\n"
	  "'listatoms' load\n"
	  "var paperwidth\n"
	  "var paperheight\n"
	  "var papermargin\n"
	  "var paperportraitflag\n"
	  "210 paperwidth !\n"
	  "297 paperheight !\n"
	  "20 papermargin !\n"
	  "0 paperportraitflag !\n"
	  "'arial' set-labelfont\n"
	  );
  fclose(ymolrc);
}

void load_ymolrc()
{
  char *home=getenv("HOME");
  char *ymolrcname;
  FILE *ymolrc;
  if (home==NULL)
    {
      printf("Strange. You don't seem to have a home directory.\n"
	     "Please set the environment variable HOME to your\n"
	     "home directory before running ymol\n");
      exit(1);
    }
  ymolrcname=malloc((strlen(home)+strlen(YMOLRCNAME)+1+1));
  strcpy(ymolrcname,home);
  strcat(ymolrcname,"/");
  strcat(ymolrcname,YMOLRCNAME);
  ymolrc=fopen(ymolrcname,"r");
  if (ymolrc==NULL)
    {
      char *homeinstall=malloc(strlen(home)+strlen(HOMEINSTALL)+1+1);
      strcpy(homeinstall,home);
      strcat(homeinstall,"/");
      strcat(homeinstall,HOMEINSTALL);
      printf("I will write a default %s to %s.\n You can edit this "
	     "to suit your needs for your default configuration.\n",
	     YMOLRCNAME,ymolrcname);
      save_default_ymolrc(ymolrcname,homeinstall);
      free(homeinstall);
      ymolrc=fopen(ymolrcname,"r");
      if (ymolrc==NULL)
	{
	  printf("I can't read the file %s I just created (or tried to create).\n",ymolrcname);
	  exit(1);
	}
    }
  {
    /* Read and parse the file */
    int fsize;
    int myfsz;
    char *mybuf;
    struct stat mystat;
    if (stat(ymolrcname,&mystat))
      {
	printf("Can't stat %s\n",ymolrcname);
	exit(1);
      }
    fsize=mystat.st_size;
    mybuf=malloc((fsize+1));
    if ((myfsz=fread(mybuf,1,(int)fsize,ymolrc))==((int)fsize))
      {
	char *search;
	char *thisbuf=mybuf;
	mybuf[fsize]='\0';
	/* Does this buffer contain any load statements? */
	while (thisbuf!=NULL)
	  {
	    int found=0;
	    restore_vm_state(); /* Drop old data */
	    vm_run();
	    search=strchr(thisbuf,'l');
	    while ((!found) && (search!=NULL))
	      {
		if (search[1]=='o')
		  if (search[2]=='a')
		    if (search[3]=='d')
		      if ((search>thisbuf) 
			  && (strchr(" \n\t\000",search[4])!=NULL)
			  && (strchr(" \n\t",*(search-1))!=NULL))
			found=1;
		if (!found)
		  search=strchr(search+1,'l');
	      }
	    if (found)
	      {
		int l=((unsigned)(search-thisbuf)+5);
		char *tbuf=malloc(l);
		memcpy(tbuf,thisbuf,l-1);
		tbuf[l-1]='\000';
		vm_parse_and_compile(tbuf);
		free(tbuf);
		thisbuf+=l;
	      }
	    else
	      {
		vm_parse_and_compile(thisbuf);
		thisbuf=NULL;
	      }
	    vm_parse_and_compile("stop");
	    save_vm_state();
	    /*    fiddle_with_pc(-1); */
	    /* Run virtual machine */
	    while(vm_tick());
	  }
	free(mybuf);
      }
    else
      {
	char tmp[200];
	sprintf(tmp,"Cannot read file. Only read %d bytes\n",myfsz);
	vmputs(tmp);
      }
    fclose(ymolrc);
    free(ymolrcname);
  }
}
