/* This is xinterface.h
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#ifndef __xinterface__
#define __xinterface__
#include "Xco.h"

int init_animation_window(int *argc, char ***argv);

uint32 *get_buffer_ptr();
uint32 *get_conv_buffer_ptr();
void get_buffer_size(int *x, int *y);
void test_draw_window_size(int *x,int *y);

void flush_image();
int32 *get_zbuffer_ptr();
void clear_buffers(int icolor);

void set_draw_style(int i);
int get_draw_style();

Pixmap get_current_draw_pixmap();
void set_stereo_mode(int i);
void set_stereo_buffer(int i);
void copy_stereo_buffer();
void clear_stereo_buffers(int ir, int ig, int ib);

void set_active_pixmap(int i);
Pixmap get_active_pixmap();
Pixmap get_inactive_pixmap();
void swap_pixmaps();
XcoObject get_drawbox();
void set_bkgr_pixmap();

void set_oversampling(int oversample);

void get_displayed_image();

#ifdef DOUBLEBUFFER
int query_doublebuffer();
int Iquery_dbe_support();
void switch_doublebuffer_usage();
void set_doublebuffer_usage(int use);
#endif

#ifdef MULTIBUFFER
int query_multibuffer();
int Iquery_mbuf_support();
void switch_multibuffer_usage();
void set_multibuffer_usage(int use);
#endif

#ifdef USEOPENGL
#include <GL/gl.h>
#include <GL/glx.h>
int query_visual_gl(Display *dpy,int screen,XVisualInfo *vis);
void postprocess_visual_gl(Display *dpy,int screen,XVisualInfo *vis);
int QueryOpenGLSupport();
GLXContext GetGLXContext();
#endif

#endif

