      /* This is worldmemory.c
      A part of the Ymol program
      Copyright (C) 1997-1998 Daniel Spangberg
      */

/* Beware!! 
   This file contains Fortran code converted to C, to allow for dynamic memory.
   The problem is that there are a lot of functions using Fortran style calling
   convention, making things look very ugly.
*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <Xco.h>
#include <stdlib.h>
#include <string.h>
#include "xinterface.h"
#include "maxs.h"
#include "worldmemory.h"
#include "fstring.h"
#include "defaults.h"

/* #define DEBUGME */

#ifdef DEBUGME 

static void debugfree(void *freeme)
{
  /*  printf("%u freed\n",(unsigned int)freeme); */
  fflush(NULL);
  free(freeme);
}

#define free debugfree
#endif

/* Memory hooks */

/* NOTE: I always need a temporary frame. This would be frame no 0!!!
 And another one. number of frames + 1 */

/* Frame based hooks */
static int nframes;
static int *atoms,*bonds;
static int *hasframetext;
static char **frametext;
static double *frametext_x;
static double *frametext_y;
static int *frame_is_initialized;
static double **crystal_matrix;

/* Atoms */
static double **atomx, **atomy, **atomz, **atomrad, **atomrsv,**atomweight, **atomscalerad;
static int **atomsort, **atomselected, **atomn, **atomid, **atomnr, **atomdrawstyle,
  **atomhasmessage;
static unsigned char **atomr, **atomg, **atomb,**defradweight,**defcol,**deflabel;
static char ***atomlabel;

/* Bonds */
static int **bond1,**bond2,**bondsort,**bondselected,**bondn1,**bondn2,**bondnslice,***bondp;
static unsigned char **bondr1,**bondg1,**bondb1,**bondr2,**bondg2,**bondb2,
  **defbcol,**drawbond;
static double **bondcompare,**bondrsv1,**bondrsv2,**bondrad1,**bondrad2,**bond1x,**bond1y,**bond1z,
  **bond2x,**bond2y,**bond2z;

/* Triangles (actually triangle points! Must be a multiple of three!!!) */
static int *triangles;
static float **trianglex,**triangley,**trianglez,**trianglenx,**triangleny,**trianglenz,**trianglefr, **trianglecompare, **triangleopaq;
static int **triangler,**triangleg,**triangleb,**trianglen, **trianglesort, **triangletwosided;


/* Measures */
typedef struct measure
{
  int type;
  int p[8];
  int x,y;
  struct measure *next;
} measure ;

static measure **measure_hook;

static int memory_initialized=0;

#if defined(USCORE2)
void initialize_memory__(int *frames)
#else
void initialize_memory_(int *frames)
#endif
{
  int i;
  if (memory_initialized)
    {
#if defined(USCORE2)
      deinitialize_memory__();
#else
      deinitialize_memory_();
#endif
    }
#if 0
  printf("Initializing memory\n");
  printf("sizeof(double)=%u, sizeof(int)=%u, sizeof(char)=%u\n",
	 (unsigned)sizeof(double),
	 (unsigned)sizeof(int),
	 (unsigned)sizeof(char));
  printf("sizeof(double*)=%u, sizeof(int*)=%u, sizeof(char*)=%u\n",
	 (unsigned)sizeof(double*),
	 (unsigned)sizeof(int*),
	 (unsigned)sizeof(char*));
#endif
  memory_initialized=1;
  nframes=*frames;
  frame_is_initialized=malloc(sizeof(int)*(nframes+2));
  for (i=0; i<=(nframes+1); i++)
    frame_is_initialized[i]=0;
  atoms=malloc(sizeof(int)*(nframes+2));
  bonds=malloc(sizeof(int)*(nframes+2));
  triangles=malloc(sizeof(int)*(nframes+2));
  hasframetext=malloc(sizeof(int)*(nframes+2));
  frametext=malloc(sizeof(char*)*(nframes+2));
  frametext_x=malloc(sizeof(double)*(nframes+2));
  frametext_y=malloc(sizeof(double)*(nframes+2));
  crystal_matrix=malloc(sizeof(double*)*(nframes+2));
  atomx=malloc(sizeof(double*)*(nframes+2));
  atomy=malloc(sizeof(double*)*(nframes+2));
  atomz=malloc(sizeof(double*)*(nframes+2));
  atomrad=malloc(sizeof(double*)*(nframes+2));
  atomscalerad=malloc(sizeof(double*)*(nframes+2));
  atomweight=malloc(sizeof(double*)*(nframes+2));
  atomrsv=malloc(sizeof(double*)*(nframes+2));
  atomsort=malloc(sizeof(int*)*(nframes+2));
  atomselected=malloc(sizeof(int*)*(nframes+2));
  atomn=malloc(sizeof(int*)*(nframes+2));
  atomid=malloc(sizeof(int*)*(nframes+2));
  atomnr=malloc(sizeof(int*)*(nframes+2));
  atomdrawstyle=malloc(sizeof(int*)*(nframes+2));
  atomhasmessage=malloc(sizeof(int*)*(nframes+2));
  atomr=malloc(sizeof(unsigned char*)*(nframes+2));
  atomg=malloc(sizeof(unsigned char*)*(nframes+2));
  atomb=malloc(sizeof(unsigned char*)*(nframes+2));
  defradweight=malloc(sizeof(unsigned char*)*(nframes+2));
  defcol=malloc(sizeof(unsigned char*)*(nframes+2));
  deflabel=malloc(sizeof(unsigned char*)*(nframes+2));
  atomlabel=malloc(sizeof(char**)*(nframes+2));
  bond1=malloc(sizeof(int*)*(nframes+2));
  bond2=malloc(sizeof(int*)*(nframes+2));
  bondp=malloc(sizeof(int**)*(nframes+2));
  bondsort=malloc(sizeof(int*)*(nframes+2));
  bondselected=malloc(sizeof(int*)*(nframes+2));
  bondn1=malloc(sizeof(int*)*(nframes+2));
  bondnslice=malloc(sizeof(int*)*(nframes+2));
  bondn2=malloc(sizeof(int*)*(nframes+2));
  bondr1=malloc(sizeof(unsigned char*)*(nframes+2));
  bondg1=malloc(sizeof(unsigned char*)*(nframes+2));
  bondb1=malloc(sizeof(unsigned char*)*(nframes+2));
  bondr2=malloc(sizeof(unsigned char*)*(nframes+2));
  bondg2=malloc(sizeof(unsigned char*)*(nframes+2));
  bondb2=malloc(sizeof(unsigned char*)*(nframes+2));
  defbcol=malloc(sizeof(unsigned char*)*(nframes+2));
  drawbond=malloc(sizeof(unsigned char*)*(nframes+2));
  bondcompare=malloc(sizeof(double*)*(nframes+2));
  bondrsv1=malloc(sizeof(double*)*(nframes+2));
  bondrsv2=malloc(sizeof(double*)*(nframes+2));
  bondrad1=malloc(sizeof(double*)*(nframes+2));
  bondrad2=malloc(sizeof(double*)*(nframes+2));
  bond1x=malloc(sizeof(double*)*(nframes+2));
  bond1y=malloc(sizeof(double*)*(nframes+2));
  bond1z=malloc(sizeof(double*)*(nframes+2));
  bond2x=malloc(sizeof(double*)*(nframes+2));
  bond2y=malloc(sizeof(double*)*(nframes+2));
  bond2z=malloc(sizeof(double*)*(nframes+2));
  measure_hook=malloc(sizeof(measure**)*(nframes+2));
  trianglex=malloc(sizeof(float*)*(nframes+2));
  triangley=malloc(sizeof(float*)*(nframes+2));
  trianglez=malloc(sizeof(float*)*(nframes+2));
  trianglenx=malloc(sizeof(float*)*(nframes+2));
  triangleny=malloc(sizeof(float*)*(nframes+2));
  trianglenz=malloc(sizeof(float*)*(nframes+2));
  trianglefr=malloc(sizeof(float*)*(nframes+2));
  triangleopaq=malloc(sizeof(float*)*(nframes+2));
  trianglecompare=malloc(sizeof(float*)*(nframes+2));
  triangler=malloc(sizeof(int*)*(nframes+2));
  triangleg=malloc(sizeof(int*)*(nframes+2));
  triangleb=malloc(sizeof(int*)*(nframes+2));
  trianglen=malloc(sizeof(int*)*(nframes+2));
  triangletwosided=malloc(sizeof(int*)*(nframes+2));
  trianglesort=malloc(sizeof(int*)*(nframes+2));
}

#if defined(USCORE2)
void deinitialize_memory__()
#else
void deinitialize_memory_()
#endif
{
  /* Deinitialize all frames */
  int i;
  /*  printf("Deinitializing memory\n");  */
  for (i=0; i<=(nframes+1); i++)
    {
      if (frame_is_initialized[i])
	{
#if defined(USCORE2)
	  deinitialize_frame__(&i);
#else
	  deinitialize_frame_(&i);
#endif
	}
    }
  /* Now remove the "backbone" */
  free(frame_is_initialized);
  free(atoms);
  free(bonds);
  free(triangles);
  free(hasframetext);
  free(frametext);
  free(frametext_x);
  free(frametext_y);
  free(crystal_matrix);
  free(atomx);
  free(atomy);
  free(atomz);
  free(atomrad);
  free(atomscalerad);
  free(atomweight);
  free(atomrsv);
  free(atomsort);
  free(atomselected);
  free(atomn);
  free(atomid);
  free(atomnr);
  free(atomdrawstyle);
  free(atomhasmessage);
  free(atomr);
  free(atomg);
  free(atomb);
  free(defradweight);
  free(defcol);
  free(deflabel);
  free(atomlabel);
  free(bond1);
  free(bond2);
  free(bondp);
  free(bondsort);
  free(bondselected);
  free(bondn1);
  free(bondnslice);
  free(bondn2);
  free(bondr1);
  free(bondg1);
  free(bondb1);
  free(bondr2);
  free(bondg2);
  free(bondb2);
  free(defbcol);
  free(drawbond);
  free(bondcompare);
  free(bondrsv1);
  free(bondrsv2);
  free(bondrad1);
  free(bondrad2);
  free(bond1x);
  free(bond1y);
  free(bond1z);
  free(bond2x);
  free(bond2y);
  free(bond2z);
  free(measure_hook);
  free(trianglex);
  free(triangley);
  free(trianglez);
  free(trianglenx);
  free(triangleny);
  free(trianglenz);
  free(trianglefr);
  free(triangleopaq);
  free(trianglecompare);
  free(triangler);
  free(triangleg);
  free(triangleb);
  free(trianglen);
  free(triangletwosided);
  free(trianglesort);
  memory_initialized=0;
}

#if defined(USCORE2)
void remove_measure__(int *nframe)
#else
void remove_measure_(int *nframe)
#endif
{
  measure *ptr=measure_hook[*nframe],*tmp;
  while(ptr!=NULL)
    {
      tmp=ptr;
      ptr=ptr->next;
      free(tmp);
    }
  measure_hook[*nframe]=NULL;
}

void remove_measure(int frame)
{
#if defined(USCORE2)
  remove_measure__(&frame);
#else
  remove_measure_(&frame);
#endif
}

#if defined(USCORE2)
void deinitialize_frame__(int *nframe)
#else
void deinitialize_frame_(int *nframe)
#endif
{
  int i,frame=*nframe;
#if 0
  printf("Deinitializing frame %d. Bonds=%d,Atoms=%d,T=%d. Finit=%d\n",frame,bonds[frame],atoms[frame],triangles[frame],

	 frame_is_initialized[frame]);
#endif
  frame_is_initialized[frame]=0;
  free(frametext[frame]);
  free(crystal_matrix[frame]);
  if (atoms[frame]>0)
    {
      free(atomx[frame]);
      free(atomy[frame]);
      free(atomz[frame]);
      free(atomrad[frame]);
      free(atomscalerad[frame]);
      free(atomweight[frame]);
      free(atomrsv[frame]);
      free(atomsort[frame]);
      free(atomselected[frame]);
      free(atomn[frame]);
      free(atomid[frame]);
      free(atomnr[frame]);
      free(atomdrawstyle[frame]);
      free(atomhasmessage[frame]);
      free(atomr[frame]);
      free(atomg[frame]);
      free(atomb[frame]);
      free(defradweight[frame]);
      free(defcol[frame]);
      free(deflabel[frame]);
      for (i=0; i<atoms[frame]; i++)
	free(atomlabel[frame][i]);
      free(atomlabel[frame]);
      atomx[frame]=NULL;
      atomy[frame]=NULL;
      atomz[frame]=NULL;
      atomrad[frame]=NULL;
      atomscalerad[frame]=NULL;
      atomweight[frame]=NULL;
      atomrsv[frame]=NULL;
      atomsort[frame]=NULL;
      atomselected[frame]=NULL;
      atomn[frame]=NULL;
      atomid[frame]=NULL;
      atomnr[frame]=NULL;
      atomdrawstyle[frame]=NULL;
      atomhasmessage[frame]=NULL;
      atomr[frame]=NULL;
      atomg[frame]=NULL;
      atomb[frame]=NULL;
      defradweight[frame]=NULL;
      defcol[frame]=NULL;
      deflabel[frame]=NULL;
      atomlabel[frame]=NULL;
    }
  if (bonds[frame]>0)
    {
      free(bond1[frame]);
      free(bond2[frame]);
      for (i=0; i<bonds[frame]; i++)
	free(bondp[frame][i]);
      free(bondp[frame]);
      free(bondsort[frame]);
      free(bondselected[frame]);
      free(bondn1[frame]);
      free(bondnslice[frame]);
      free(bondn2[frame]);
      free(bondr1[frame]);
      free(bondg1[frame]);
      free(bondb1[frame]);
      free(bondr2[frame]);
      free(bondg2[frame]);
      free(bondb2[frame]);
      free(defbcol[frame]);
      free(drawbond[frame]);
      free(bondcompare[frame]);
      free(bondrsv1[frame]);
      free(bondrsv2[frame]);
      free(bondrad1[frame]);
      free(bondrad2[frame]);
      free(bond1x[frame]);
      free(bond1y[frame]);
      free(bond1z[frame]);
      free(bond2x[frame]);
      free(bond2y[frame]);
      free(bond2z[frame]);
      bond1[frame]=NULL;
      bond2[frame]=NULL;
      bondp[frame]=NULL;
      bondsort[frame]=NULL;
      bondselected[frame]=NULL;
      bondn1[frame]=NULL;
      bondnslice[frame]=NULL;
      bondr1[frame]=NULL;
      bondg1[frame]=NULL;
      bondb1[frame]=NULL;
      bondn2[frame]=NULL;
      bondr2[frame]=NULL;
      bondg2[frame]=NULL;
      bondb2[frame]=NULL;
      defbcol[frame]=NULL;
      drawbond[frame]=NULL;
      bondcompare[frame]=NULL;
      bondrsv1[frame]=NULL;
      bondrsv2[frame]=NULL;
      bondrad1[frame]=NULL;
      bondrad2[frame]=NULL;
      bond1x[frame]=NULL;
      bond1y[frame]=NULL;
      bond1z[frame]=NULL;
      bond2x[frame]=NULL;
      bond2y[frame]=NULL;
      bond2z[frame]=NULL;
    }
  if (triangles[frame]>0)
    {
      free(trianglex[frame]);
      free(triangley[frame]);
      free(trianglez[frame]);
      free(trianglenx[frame]);
      free(triangleny[frame]);
      free(trianglenz[frame]);
      free(trianglefr[frame]);
      free(triangleopaq[frame]);
      free(trianglecompare[frame]);
      free(triangler[frame]);
      free(triangleg[frame]);
      free(triangleb[frame]);
      free(trianglen[frame]);
      free(triangletwosided[frame]);
      free(trianglesort[frame]);
      trianglex[frame]=NULL;
      triangley[frame]=NULL;
      trianglez[frame]=NULL;
      trianglenx[frame]=NULL;
      triangleny[frame]=NULL;
      trianglenz[frame]=NULL;
      trianglefr[frame]=NULL;
      triangleopaq[frame]=NULL;
      trianglecompare[frame]=NULL;
      triangler[frame]=NULL;
      triangleg[frame]=NULL;
      triangleb[frame]=NULL;
      trianglen[frame]=NULL;
      triangletwosided[frame]=NULL;
      trianglesort[frame]=NULL;
    }
  remove_measure(frame);
}


#if defined(USCORE2)
void initialize_frame__(int *nframe, int *atomsx, int *bondsx, int *trianglesx)
#else
void initialize_frame_(int *nframe, int *atomsx, int *bondsx, int *trianglesx)
#endif
{
  int i;
  int frame=*nframe,natoms=*atomsx,nbonds=*bondsx, ntriangles=*trianglesx;
  if (frame_is_initialized[frame])
    {
#if defined(USCORE2)
      deinitialize_frame__(nframe);
#else
      deinitialize_frame_(nframe);
#endif
    }
#if 0
  printf("Initializing frame %d. A=%d, B=%d, T=%d\n",frame,natoms,nbonds,ntriangles);
#endif
  frame_is_initialized[frame]=1;
  atoms[frame]=natoms;
  bonds[frame]=nbonds;
  triangles[frame]=ntriangles;
  hasframetext[frame]=0;
  frametext[frame]=malloc((MAXCHARSINFRAMETEXT+1));
  crystal_matrix[frame]=malloc(sizeof(double)*9);
  if (natoms>0) 
    {
      atomx[frame]=malloc(sizeof(double)*natoms);
      atomy[frame]=malloc(sizeof(double)*natoms);
      atomz[frame]=malloc(sizeof(double)*natoms);
      atomrad[frame]=malloc(sizeof(double)*natoms);
      atomscalerad[frame]=malloc(sizeof(double)*natoms);
      atomweight[frame]=malloc(sizeof(double)*natoms);
      atomrsv[frame]=malloc(sizeof(double)*natoms);
      atomsort[frame]=malloc(sizeof(int)*natoms);
      atomselected[frame]=malloc(sizeof(int)*natoms);
      atomn[frame]=malloc(sizeof(int)*natoms);
      atomid[frame]=malloc(sizeof(int)*natoms);
      atomnr[frame]=malloc(sizeof(int)*natoms);
      atomdrawstyle[frame]=malloc(sizeof(int)*natoms);
      atomhasmessage[frame]=malloc(sizeof(int)*natoms);
      atomr[frame]=malloc(sizeof(unsigned char)*natoms);
      atomg[frame]=malloc(sizeof(unsigned char)*natoms);
      atomb[frame]=malloc(sizeof(unsigned char)*natoms);
      defradweight[frame]=malloc(sizeof(unsigned char)*natoms);
      defcol[frame]=malloc(sizeof(unsigned char)*natoms);
      deflabel[frame]=malloc(sizeof(unsigned char)*natoms);
      atomlabel[frame]=malloc(sizeof(char*)*natoms);
      for (i=0; i<natoms; i++)
	atomlabel[frame][i]=malloc((MAXCHARSPERLABEL+1));
    }
  else
    {
      atomx[frame]=NULL;
      atomy[frame]=NULL;
      atomz[frame]=NULL;
      atomrad[frame]=NULL;
      atomscalerad[frame]=NULL;
      atomweight[frame]=NULL;
      atomrsv[frame]=NULL;
      atomsort[frame]=NULL;
      atomselected[frame]=NULL;
      atomn[frame]=NULL;
      atomid[frame]=NULL;
      atomnr[frame]=NULL;
      atomdrawstyle[frame]=NULL;
      atomhasmessage[frame]=NULL;
      atomr[frame]=NULL;
      atomg[frame]=NULL;
      atomb[frame]=NULL;
      defradweight[frame]=NULL;
      defcol[frame]=NULL;
      deflabel[frame]=NULL;
      atomlabel[frame]=NULL;
    }
  if (nbonds>0)
    {
      bond1[frame]=malloc(sizeof(int)*nbonds);
      bond2[frame]=malloc(sizeof(int)*nbonds);
      bondp[frame]=malloc(sizeof(int*)*nbonds);
      for (i=0; i<nbonds; i++)
	bondp[frame][i]=malloc(sizeof(int)*4);
      bondsort[frame]=malloc(sizeof(int)*nbonds);
      bondselected[frame]=malloc(sizeof(int)*nbonds);
      bondn1[frame]=malloc(sizeof(int)*nbonds);
      bondnslice[frame]=malloc(sizeof(int)*nbonds);
      bondr1[frame]=malloc(sizeof(unsigned char)*nbonds);
      bondg1[frame]=malloc(sizeof(unsigned char)*nbonds);
      bondb1[frame]=malloc(sizeof(unsigned char)*nbonds);
      bondn2[frame]=malloc(sizeof(int)*nbonds);
      bondr2[frame]=malloc(sizeof(unsigned char)*nbonds);
      bondg2[frame]=malloc(sizeof(unsigned char)*nbonds);
      bondb2[frame]=malloc(sizeof(unsigned char)*nbonds);
      defbcol[frame]=malloc(sizeof(unsigned char)*nbonds);
      drawbond[frame]=malloc(sizeof(unsigned char)*nbonds);
      bondcompare[frame]=malloc(sizeof(double)*nbonds);
      bondrsv1[frame]=malloc(sizeof(double)*nbonds);
      bondrsv2[frame]=malloc(sizeof(double)*nbonds);
      bondrad1[frame]=malloc(sizeof(double)*nbonds);
      bondrad2[frame]=malloc(sizeof(double)*nbonds);
      bond1x[frame]=malloc(sizeof(double)*nbonds);
      bond1y[frame]=malloc(sizeof(double)*nbonds);
      bond1z[frame]=malloc(sizeof(double)*nbonds);
      bond2x[frame]=malloc(sizeof(double)*nbonds);
      bond2y[frame]=malloc(sizeof(double)*nbonds);
      bond2z[frame]=malloc(sizeof(double)*nbonds);
    }
  else
    {
      bond1[frame]=NULL;
      bond2[frame]=NULL;
      bondp[frame]=NULL;
      bondsort[frame]=NULL;
      bondselected[frame]=NULL;
      bondn1[frame]=NULL;
      bondnslice[frame]=NULL;
      bondr1[frame]=NULL;
      bondg1[frame]=NULL;
      bondb1[frame]=NULL;
      bondn2[frame]=NULL;
      bondr2[frame]=NULL;
      bondg2[frame]=NULL;
      bondb2[frame]=NULL;
      defbcol[frame]=NULL;
      drawbond[frame]=NULL;
      bondcompare[frame]=NULL;
      bondrsv1[frame]=NULL;
      bondrsv2[frame]=NULL;
      bondrad1[frame]=NULL;
      bondrad2[frame]=NULL;
      bond1x[frame]=NULL;
      bond1y[frame]=NULL;
      bond1z[frame]=NULL;
      bond2x[frame]=NULL;
      bond2y[frame]=NULL;
      bond2z[frame]=NULL;
    }
  if (ntriangles>0)
    {
      trianglex[frame]=malloc(sizeof(float)*ntriangles);
      triangley[frame]=malloc(sizeof(float)*ntriangles);
      trianglez[frame]=malloc(sizeof(float)*ntriangles);
      trianglenx[frame]=malloc(sizeof(float)*ntriangles);
      triangleny[frame]=malloc(sizeof(float)*ntriangles);
      trianglenz[frame]=malloc(sizeof(float)*ntriangles);
      trianglefr[frame]=malloc(sizeof(float)*ntriangles);
      triangleopaq[frame]=malloc(sizeof(float)*ntriangles);
      trianglecompare[frame]=malloc(sizeof(float)*(ntriangles/3));
      triangler[frame]=malloc(sizeof(int)*ntriangles);
      triangleg[frame]=malloc(sizeof(int)*ntriangles);
      triangleb[frame]=malloc(sizeof(int)*ntriangles);
      trianglen[frame]=malloc(sizeof(int)*ntriangles);
      triangletwosided[frame]=malloc(sizeof(int)*ntriangles);
      trianglesort[frame]=malloc(sizeof(int)*(ntriangles/3));
    }
  else
    {
      trianglex[frame]=NULL;
      triangley[frame]=NULL;
      trianglez[frame]=NULL;
      trianglenx[frame]=NULL;
      triangleny[frame]=NULL;
      trianglenz[frame]=NULL;
      trianglefr[frame]=NULL;
      triangleopaq[frame]=NULL;
      trianglecompare[frame]=NULL;
      triangler[frame]=NULL;
      triangleg[frame]=NULL;
      triangleb[frame]=NULL;
      trianglen[frame]=NULL;
      triangletwosided[frame]=NULL;
      trianglesort[frame]=NULL;
    }
  measure_hook[frame]=NULL;
}

void reallocate_triangles(int frame,int ntriangles)
{
  triangles[frame]=ntriangles;
  if (ntriangles)
    {
      trianglex[frame]=realloc(trianglex[frame],sizeof(float)*ntriangles);
      triangley[frame]=realloc(triangley[frame],sizeof(float)*ntriangles);
      trianglez[frame]=realloc(trianglez[frame],sizeof(float)*ntriangles);
      trianglenx[frame]=realloc(trianglenx[frame],sizeof(float)*ntriangles);
      triangleny[frame]=realloc(triangleny[frame],sizeof(float)*ntriangles);
      trianglenz[frame]=realloc(trianglenz[frame],sizeof(float)*ntriangles);
      trianglefr[frame]=realloc(trianglefr[frame],sizeof(float)*ntriangles);
      triangleopaq[frame]=realloc(triangleopaq[frame],sizeof(float)*ntriangles);
      trianglecompare[frame]=realloc(trianglecompare[frame],sizeof(float)*(ntriangles/3));
      triangler[frame]=realloc(triangler[frame],sizeof(int)*ntriangles);
      triangleg[frame]=realloc(triangleg[frame],sizeof(int)*ntriangles);
      triangleb[frame]=realloc(triangleb[frame],sizeof(int)*ntriangles);
      trianglen[frame]=realloc(trianglen[frame],sizeof(int)*ntriangles);
      triangletwosided[frame]=realloc(triangletwosided[frame],sizeof(int)*ntriangles);
      trianglesort[frame]=realloc(trianglesort[frame],sizeof(int)*(ntriangles/3));
    }
}

void add_measure(int frame,int type,int *p,int x,int y)
{
  int i,n;
  measure *new=malloc(sizeof(measure));
  new->type=type;
  switch(type)
    {
    case MEASURE_DISTANCE:
      n=4;
      break;
    case MEASURE_ANGLE:
      n=6;
      break;
    case MEASURE_DIHEDRAL:
      n=8;
    }
  for (i=0; i<n; i++)
    new->p[i]=p[i];
  new->x=x;
  new->y=y;
  new->next=measure_hook[frame];
  measure_hook[frame]=new;
}

#if defined(USCORE2)
void add_measure__(int *frame,int *type,int *p,int *x,int *y)
#else
void add_measure_(int *frame,int *type,int *p,int *x,int *y)
#endif
{
  add_measure(*frame,*type,p,*x,*y);
}

static measure *measure_burst;

#if defined(USCORE2)
void get_next_measure__(int *frame,int *type,int *p,int *x,int *y)
#else
void get_next_measure_(int *frame,int *type,int *p,int *x,int *y)
#endif
{
  int i,n;
  if (measure_burst==NULL)
    {
      *type=MEASURE_NONE;
      return;
    }
  else
    {
      *type=measure_burst->type;
      switch(measure_burst->type)
	{
	case MEASURE_DISTANCE:
	  n=4;
	  break;
	case MEASURE_ANGLE:
	  n=6;
	  break;
	case MEASURE_DIHEDRAL:
	  n=8;
	}
      for (i=0; i<n; i++)
	p[i]=measure_burst->p[i];
      *x=measure_burst->x;
      *y=measure_burst->y;
      measure_burst=measure_burst->next;
    }
}

#if defined(USCORE2)
void get_first_measure__(int *frame,int *type,int *p,int *x,int *y)
#else
void get_first_measure_(int *frame,int *type,int *p,int *x,int *y)
#endif
{
  measure_burst=measure_hook[*frame];
#if defined(USCORE2)
  get_next_measure__(frame,type,p,x,y);
#else
  get_next_measure_(frame,type,p,x,y);
#endif
}


/* Some extra data required by the temporary frame 0 */
typedef struct mybond
{
  int bond1,bond2,bondsort,bondselected,bondn1,bondnslice,bondn2,bondp[4];
  unsigned char bondr1,bondg1,bondb1,bondr2,bondg2,bondb2,defbcol,drawbond;
  double bondcompare,bondrsv1,bondrsv2,bondrad1,bondrad2,
    bond1x,bond1y,bond1z,bond2x,bond2y,bond2z;
  struct mybond *next;
} mybond;

static int tempbonds;
static mybond *bondhook=NULL;

#if defined(USCORE2)
void initialize_temporary__(int *natoms, int *ntriangles)
#else
void initialize_temporary_(int *natoms, int *ntriangles)
#endif
{
  int f,b;
  if (frame_is_initialized[0])
    {
#if defined(USCORE2)
      deinitialize_temporary__();
#else
      deinitialize_temporary_();
#endif
    }
  f=0;
  b=0;
#if defined(USCORE2)
  initialize_frame__(&f, natoms, &b, ntriangles);
#else
  initialize_frame_(&f, natoms, &b, ntriangles);
#endif
  tempbonds=0;
}

#if defined(USCORE2)
void deinitialize_temporary__()
#else
void deinitialize_temporary_()
#endif
{
  mybond *ptr,*tmp;
  int f,b;
  f=0;
  b=0;
#if defined(USCORE2)
  deinitialize_frame__(&f);
#else
  deinitialize_frame_(&f);
#endif
  ptr=bondhook;
  while(ptr!=NULL)
    {
      tmp=ptr;
      ptr=ptr->next;
      free(tmp);
    }
  bondhook=NULL;
  tempbonds=0;
}

#if defined(USCORE2)
void add_temporary_bond__()
#else
void add_temporary_bond_()
#endif
{
  mybond *new=malloc(sizeof(mybond));
  new->next=bondhook;
  bondhook=new;
  tempbonds++;
}

static mybond *get_bond_ptr(int i)
{
  int j=tempbonds-1;
  mybond *ptr=bondhook;
  while (j>i)
    {
      ptr=ptr->next;
      j--;
    }
  return(ptr);
}

#if defined(USCORE2)
void copy_measures__(int *fromframe,int *toframe)
#else
void copy_measures_(int *fromframe,int *toframe)
#endif
{
  measure *measure_ptr=measure_hook[*fromframe];
  while(measure_ptr!=NULL)
    {
      add_measure(*toframe,measure_ptr->type,measure_ptr->p,measure_ptr->x,measure_ptr->y);
      measure_ptr=measure_ptr->next;
    }
}

#if defined(USCORE2)
void copy_temporary_to_frame__(int *nframe)
#else
void copy_temporary_to_frame_(int *nframe)
#endif
{
  int i;
  mybond *ptr=bondhook;
  /*   printf("Copying temporary to frame %d\n",*nframe); */
  if (frame_is_initialized[*nframe])
    {
#if defined(USCORE2)
      deinitialize_frame__(nframe);
#else
      deinitialize_frame_(nframe);
#endif
    }
#if defined(USCORE2)
  initialize_frame__(nframe,&atoms[0],&tempbonds, &triangles[0]);
#else
  initialize_frame_(nframe,&atoms[0],&tempbonds, &triangles[0]);
#endif
  /*  printf("Copying: 0 to %d\n",*nframe); */
  for (i=0; i<9; i++)
    crystal_matrix[*nframe][i]=crystal_matrix[0][i];
  for (i=0; i<atoms[0]; i++)
    {
      atomx[*nframe][i]=atomx[0][i];
      atomy[*nframe][i]=atomy[0][i];
      atomz[*nframe][i]=atomz[0][i];
      /*      printf("atom %d: %f,%f,%f\n",i,atomx[0][i],atomy[0][i],atomz[0][i]); */
      atomrad[*nframe][i]=atomrad[0][i];
      atomscalerad[*nframe][i]=atomscalerad[0][i];
#if 0
      printf("atomscalerad copied atom %d from frame 0 to frame %d\n",i,*nframe);
#endif
      atomweight[*nframe][i]=atomweight[0][i];
      atomrsv[*nframe][i]=atomrsv[0][i];
      atomsort[*nframe][i]=atomsort[0][i];
      atomselected[*nframe][i]=atomselected[0][i];
      atomn[*nframe][i]=atomn[0][i];
      atomid[*nframe][i]=atomid[0][i];
      atomnr[*nframe][i]=atomnr[0][i];
      atomdrawstyle[*nframe][i]=atomdrawstyle[0][i];
      atomhasmessage[*nframe][i]=atomhasmessage[0][i];
      atomr[*nframe][i]=atomr[0][i];
      atomg[*nframe][i]=atomg[0][i];
      atomb[*nframe][i]=atomb[0][i];
      defradweight[*nframe][i]=defradweight[0][i];
      defcol[*nframe][i]=defcol[0][i];
      deflabel[*nframe][i]=deflabel[0][i];
      {
	/* Paranoia check!! */
	int l=strlen(atomlabel[0][i]);
	if (l>MAXCHARSPERLABEL)
	  {
	    printf("Stupid!! Forgot to initialize atomlabel somewhere!! (copy_temporary_to_frame)\n");
	    exit(1);
	  }
      }
      strcpy(atomlabel[*nframe][i],atomlabel[0][i]);
    }
  for (i=0; i<triangles[0]; i++)
    {
      trianglex[*nframe][i]=trianglex[0][i];
      triangley[*nframe][i]=triangley[0][i];
      trianglez[*nframe][i]=trianglez[0][i];
      trianglenx[*nframe][i]=trianglenx[0][i];
      triangleny[*nframe][i]=triangleny[0][i];
      trianglenz[*nframe][i]=trianglenz[0][i];
      trianglefr[*nframe][i]=trianglefr[0][i];
      triangleopaq[*nframe][i]=triangleopaq[0][i];
      triangler[*nframe][i]=triangler[0][i];
      triangleg[*nframe][i]=triangleg[0][i];
      triangleb[*nframe][i]=triangleb[0][i];
      trianglen[*nframe][i]=trianglen[0][i];
      triangletwosided[*nframe][i]=triangletwosided[0][i];
    }
  for (i=0; i<triangles[0]/3; i++)
    {
      trianglecompare[*nframe][i]=trianglecompare[0][i];
      trianglesort[*nframe][i]=trianglesort[0][i];
    }

  i=tempbonds-1;
  while (ptr!=NULL)
    {
      int j;
      bond1[*nframe][i]=ptr->bond1;
      bond2[*nframe][i]=ptr->bond2;
      for (j=0; j<=3; j++)
	bondp[*nframe][i][j]=ptr->bondp[j];
      bondsort[*nframe][i]=ptr->bondsort;
      bondselected[*nframe][i]=ptr->bondselected;
      bondn1[*nframe][i]=ptr->bondn1;
      bondnslice[*nframe][i]=ptr->bondnslice;
      bondr1[*nframe][i]=ptr->bondr1;
      bondg1[*nframe][i]=ptr->bondg1;
      bondb1[*nframe][i]=ptr->bondb1;
      bondn2[*nframe][i]=ptr->bondn2;
      bondr2[*nframe][i]=ptr->bondr2;
      bondg2[*nframe][i]=ptr->bondg2;
      bondb2[*nframe][i]=ptr->bondb2;
      defbcol[*nframe][i]=ptr->defbcol;
      drawbond[*nframe][i]=ptr->drawbond;
      bondcompare[*nframe][i]=ptr->bondcompare;
      bondrsv1[*nframe][i]=ptr->bondrsv1;
      bondrsv2[*nframe][i]=ptr->bondrsv2;
      bondrad1[*nframe][i]=ptr->bondrad1;
      bondrad2[*nframe][i]=ptr->bondrad2;
      bond1x[*nframe][i]=ptr->bond1x;
      bond1y[*nframe][i]=ptr->bond1y;
      bond1z[*nframe][i]=ptr->bond1z;
      bond2x[*nframe][i]=ptr->bond2x;
      bond2y[*nframe][i]=ptr->bond2y;
      bond2z[*nframe][i]=ptr->bond2z;
      ptr=ptr->next;
      i--;
    }
  hasframetext[*nframe]=hasframetext[0];
  frametext_x[*nframe]=frametext_x[0];
  frametext_y[*nframe]=frametext_y[0];
  if (hasframetext[*nframe])
    {
      {
	/* Paranoia check!! */
	int l=strlen(frametext[0]);
	if (l>MAXCHARSINFRAMETEXT)
	  {
	    printf("Stupid!! Forgot to initialize frametext somewhere!! (copy_temporary_to_frame)\n");
	    exit(1);
	  }
      }
      strcpy(frametext[*nframe],frametext[0]);
    }
  else
    {
      strcpy(frametext[*nframe],"");
    }
  {
    int i=0;
#if defined(USCORE2)
    copy_measures__(&i,nframe);
#else
    copy_measures_(&i,nframe);
#endif
  }
}

#if defined(USCORE2)
void copy_frame_to_frame__(int *toframe, int *fromframe)
#else
void copy_frame_to_frame_(int *toframe, int *fromframe)
#endif
{
  int i;
  int *nframe=toframe;
  if (frame_is_initialized[*nframe])
    {
#if defined(USCORE2)
      deinitialize_frame__(nframe);
#else
      deinitialize_frame_(nframe);
#endif
    }
#if defined(USCORE2)
  initialize_frame__(nframe,&atoms[*fromframe],&bonds[*fromframe], &triangles[*fromframe]);
#else
  initialize_frame_(nframe,&atoms[*fromframe],&bonds[*fromframe], &triangles[*fromframe]);
#endif
  /*  printf("Copying: %d to %d\n",*fromframe,*nframe); */
  for (i=0; i<9; i++)
    crystal_matrix[*nframe][i]=crystal_matrix[*fromframe][i];
  for (i=0; i<atoms[*fromframe]; i++)
    {
      atomx[*nframe][i]=atomx[*fromframe][i];
      atomy[*nframe][i]=atomy[*fromframe][i];
      atomz[*nframe][i]=atomz[*fromframe][i];
      atomrad[*nframe][i]=atomrad[*fromframe][i];
      atomscalerad[*nframe][i]=atomscalerad[*fromframe][i];
#if 0
      printf("atomscalerad copied atom %d from frame %d to frame %d\n",i,*fromframe,*nframe);
#endif
      atomweight[*nframe][i]=atomweight[*fromframe][i];
      atomrsv[*nframe][i]=atomrsv[*fromframe][i];
      atomsort[*nframe][i]=atomsort[*fromframe][i];
      atomselected[*nframe][i]=atomselected[*fromframe][i];
      atomn[*nframe][i]=atomn[*fromframe][i];
      atomid[*nframe][i]=atomid[*fromframe][i];
      atomnr[*nframe][i]=atomnr[*fromframe][i];
      atomdrawstyle[*nframe][i]=atomdrawstyle[*fromframe][i];
      atomhasmessage[*nframe][i]=atomhasmessage[*fromframe][i];
      atomr[*nframe][i]=atomr[*fromframe][i];
      atomg[*nframe][i]=atomg[*fromframe][i];
      atomb[*nframe][i]=atomb[*fromframe][i];
      defradweight[*nframe][i]=defradweight[*fromframe][i];
      defcol[*nframe][i]=defcol[*fromframe][i];
      deflabel[*nframe][i]=deflabel[*fromframe][i];
      {
	/* Paranoia check!! */
	int l=strlen(atomlabel[*fromframe][i]);
	if (l>MAXCHARSPERLABEL)
	  {
	    printf("Stupid!! Forgot to initialize atomlabel somewhere!! (copy_frame_to_frame)\n");
	    exit(1);
	  }
      }
      strcpy(atomlabel[*nframe][i],atomlabel[*fromframe][i]);
    }
  for (i=0; i<triangles[*fromframe]; i++)
    {
      trianglex[*nframe][i]=trianglex[*fromframe][i];
      triangley[*nframe][i]=triangley[*fromframe][i];
      trianglez[*nframe][i]=trianglez[*fromframe][i];
      trianglenx[*nframe][i]=trianglenx[*fromframe][i];
      triangleny[*nframe][i]=triangleny[*fromframe][i];
      trianglenz[*nframe][i]=trianglenz[*fromframe][i];
      trianglefr[*nframe][i]=trianglefr[*fromframe][i];
      triangleopaq[*nframe][i]=triangleopaq[*fromframe][i];
      triangler[*nframe][i]=triangler[*fromframe][i];
      triangleg[*nframe][i]=triangleg[*fromframe][i];
      triangleb[*nframe][i]=triangleb[*fromframe][i];
      trianglen[*nframe][i]=trianglen[*fromframe][i];
      triangletwosided[*nframe][i]=triangletwosided[*fromframe][i];
    }

  for (i=0; i<triangles[*fromframe]/3; i++)
    {
      trianglecompare[*nframe][i]=trianglecompare[*fromframe][i];
      trianglesort[*nframe][i]=trianglesort[*fromframe][i];
    }

  for (i=0; i<bonds[*fromframe]; i++)
    {
      int j;
      bond1[*nframe][i]=bond1[*fromframe][i];
      bond2[*nframe][i]=bond2[*fromframe][i];
      for (j=0; j<=3; j++)
	bondp[*nframe][i][j]=bondp[*fromframe][i][j];
      bondsort[*nframe][i]=bondsort[*fromframe][i];
      bondselected[*nframe][i]=bondselected[*fromframe][i];
      bondn1[*nframe][i]=bondn1[*fromframe][i];
      bondnslice[*nframe][i]=bondnslice[*fromframe][i];
      bondr1[*nframe][i]=bondr1[*fromframe][i];
      bondg1[*nframe][i]=bondg1[*fromframe][i];
      bondb1[*nframe][i]=bondb1[*fromframe][i];
      bondn2[*nframe][i]=bondn2[*fromframe][i];
      bondr2[*nframe][i]=bondr2[*fromframe][i];
      bondg2[*nframe][i]=bondg2[*fromframe][i];
      bondb2[*nframe][i]=bondb2[*fromframe][i];
      defbcol[*nframe][i]=defbcol[*fromframe][i];
      drawbond[*nframe][i]=drawbond[*fromframe][i];
      bondcompare[*nframe][i]=bondcompare[*fromframe][i];
      bondrsv1[*nframe][i]=bondrsv1[*fromframe][i];
      bondrsv2[*nframe][i]=bondrsv2[*fromframe][i];
      bondrad1[*nframe][i]=bondrad1[*fromframe][i];
      bondrad2[*nframe][i]=bondrad2[*fromframe][i];
      bond1x[*nframe][i]=bond1x[*fromframe][i];
      bond1y[*nframe][i]=bond1y[*fromframe][i];
      bond1z[*nframe][i]=bond1z[*fromframe][i];
      bond2x[*nframe][i]=bond2x[*fromframe][i];
      bond2y[*nframe][i]=bond2y[*fromframe][i];
      bond2z[*nframe][i]=bond2z[*fromframe][i];
    }
  frametext_x[*nframe]=frametext_x[*fromframe];
  frametext_y[*nframe]=frametext_y[*fromframe];
  hasframetext[*nframe]=hasframetext[*fromframe];
  if (hasframetext[*nframe])
    {
      {
	/* Paranoia check!! */
	int l=strlen(frametext[*fromframe]);
	if (l>MAXCHARSINFRAMETEXT)
	  {
	    printf("Stupid!! Forgot to initialize frametext somewhere!! (copy_frame_to_frame)\n");
	    exit(1);
	  }
      }
      strcpy(frametext[*nframe],frametext[*fromframe]);
    }
  else
    {
      strcpy(frametext[*nframe],"");
    }
#if defined(USCORE2)
  copy_measures__(fromframe,toframe);
#else
  copy_measures_(fromframe,toframe);
#endif
}

#if defined(USCORE2)
void copy_frameatoms_to_temporary__(int *fromframe)
#else
void copy_frameatoms_to_temporary_(int *fromframe)
#endif
{
  /* Copies everything but the bonds */
  int i;
  int toframe=0;
  int *nframe=&toframe;
  if (frame_is_initialized[*nframe])
    {
#if defined(USCORE2)
      deinitialize_temporary__();
#else
      deinitialize_temporary_();
#endif
    }
#if defined(USCORE2)
  initialize_temporary__(&atoms[*fromframe], &triangles[*fromframe]);
#else
  initialize_temporary_(&atoms[*fromframe], &triangles[*fromframe]);
#endif
  /*  printf("Copying: %d to %d\n",*fromframe,*nframe); */
  for (i=0; i<9; i++)
    crystal_matrix[*nframe][i]=crystal_matrix[*fromframe][i];

  for (i=0; i<atoms[*fromframe]; i++)
    {
      atomx[*nframe][i]=atomx[*fromframe][i];
      atomy[*nframe][i]=atomy[*fromframe][i];
      atomz[*nframe][i]=atomz[*fromframe][i];
      atomrad[*nframe][i]=atomrad[*fromframe][i];
      atomscalerad[*nframe][i]=atomscalerad[*fromframe][i];
#if 0
      printf("atomscalerad copied atom %d from frame %d to frame %d\n",i,*fromframe,*nframe);
#endif
      atomweight[*nframe][i]=atomweight[*fromframe][i];
      atomrsv[*nframe][i]=atomrsv[*fromframe][i];
      atomsort[*nframe][i]=atomsort[*fromframe][i];
      atomselected[*nframe][i]=atomselected[*fromframe][i];
      atomn[*nframe][i]=atomn[*fromframe][i];
      atomid[*nframe][i]=atomid[*fromframe][i];
      atomnr[*nframe][i]=atomnr[*fromframe][i];
      atomdrawstyle[*nframe][i]=atomdrawstyle[*fromframe][i];
      atomhasmessage[*nframe][i]=atomhasmessage[*fromframe][i];
      atomr[*nframe][i]=atomr[*fromframe][i];
      atomg[*nframe][i]=atomg[*fromframe][i];
      atomb[*nframe][i]=atomb[*fromframe][i];
      defradweight[*nframe][i]=defradweight[*fromframe][i];
      defcol[*nframe][i]=defcol[*fromframe][i];
      deflabel[*nframe][i]=deflabel[*fromframe][i];
      {
	/* Paranoia check!! */
	int l=strlen(atomlabel[*fromframe][i]);
	if (l>MAXCHARSPERLABEL)
	  {
	    printf("Stupid!! Forgot to initialize atomlabel somewhere!! (copy_frame_to_temporary)\n");
	    exit(1);
	  }
      }
      strcpy(atomlabel[*nframe][i],atomlabel[*fromframe][i]);
    }
  for (i=0; i<triangles[*fromframe]; i++)
    {
      trianglex[*nframe][i]=trianglex[*fromframe][i];
      triangley[*nframe][i]=triangley[*fromframe][i];
      trianglez[*nframe][i]=trianglez[*fromframe][i];
      trianglenx[*nframe][i]=trianglenx[*fromframe][i];
      triangleny[*nframe][i]=triangleny[*fromframe][i];
      trianglenz[*nframe][i]=trianglenz[*fromframe][i];
      trianglefr[*nframe][i]=trianglefr[*fromframe][i];
      triangleopaq[*nframe][i]=triangleopaq[*fromframe][i];
      triangler[*nframe][i]=triangler[*fromframe][i];
      triangleg[*nframe][i]=triangleg[*fromframe][i];
      triangleb[*nframe][i]=triangleb[*fromframe][i];
      trianglen[*nframe][i]=trianglen[*fromframe][i];
      triangletwosided[*nframe][i]=triangletwosided[*fromframe][i];
    }

  for (i=0; i<triangles[*fromframe]/3; i++)
    {
      trianglecompare[*nframe][i]=trianglecompare[*fromframe][i];
      trianglesort[*nframe][i]=trianglesort[*fromframe][i];
    }

  frametext_x[*nframe]=frametext_x[*fromframe];
  frametext_y[*nframe]=frametext_y[*fromframe];
  hasframetext[*nframe]=hasframetext[*fromframe];
  if (hasframetext[*nframe])
    {
      {
	/* Paranoia check!! */
	int l=strlen(frametext[*fromframe]);
	if (l>MAXCHARSINFRAMETEXT)
	  {
	    printf("Stupid!! Forgot to initialize frametext somewhere!! (copy_frameatoms_to_temporary)\n");
	    exit(1);
	  }
      }
      strcpy(frametext[*nframe],frametext[*fromframe]);
    }
  else
    {
      strcpy(frametext[*nframe],"");
    }
  {
    int i=0;
#if defined(USCORE2)
  copy_measures__(fromframe,&i);
#else
  copy_measures_(fromframe,&i);
#endif
  }
}

#if defined(USCORE2)
void copy_framebonds_to_temporary__(int *nframe)
#else
void copy_framebonds_to_temporary_(int *nframe)
#endif
{
  int nbonds=bonds[*nframe];
  int i;
  for (i=0; i<nbonds; i++)
    {
      int j;
      mybond *ptr;
#if defined(USCORE2)
      add_temporary_bond__();
#else
      add_temporary_bond_();
#endif
      ptr=get_bond_ptr(i);
      ptr->bond1=bond1[*nframe][i];
      ptr->bond2=bond2[*nframe][i];
      for (j=0; j<=3; j++)
	ptr->bondp[j]=bondp[*nframe][i][j];
      ptr->bondsort=bondsort[*nframe][i];
      ptr->bondselected=bondselected[*nframe][i];
      ptr->bondn1=bondn1[*nframe][i];
      ptr->bondnslice=bondnslice[*nframe][i];
      ptr->bondr1=bondr1[*nframe][i];
      ptr->bondg1=bondg1[*nframe][i];
      ptr->bondb1=bondb1[*nframe][i];
      ptr->bondn2=bondn2[*nframe][i];
      ptr->bondr2=bondr2[*nframe][i];
      ptr->bondg2=bondg2[*nframe][i];
      ptr->bondb2=bondb2[*nframe][i];
      ptr->defbcol=defbcol[*nframe][i];
      ptr->drawbond=drawbond[*nframe][i];
      ptr->bondcompare=bondcompare[*nframe][i];
      ptr->bondrsv1=bondrsv1[*nframe][i];
      ptr->bondrsv2=bondrsv2[*nframe][i];
      ptr->bondrad1=bondrad1[*nframe][i];
      ptr->bondrad2=bondrad2[*nframe][i];
      ptr->bond1x=bond1x[*nframe][i];
      ptr->bond1y=bond1y[*nframe][i];
      ptr->bond1z=bond1z[*nframe][i];
      ptr->bond2x=bond2x[*nframe][i];
      ptr->bond2y=bond2y[*nframe][i];
      ptr->bond2z=bond2z[*nframe][i];
    }
}



/* Store and retrieve functions */

void get_nframes(int *n)
{
    *n=nframes;
}

#if defined(USCORE2)
void get_nframes__(int *n)
#else
void get_nframes_(int *n)
#endif
{
    get_nframes(n);
}

#if defined(USCORE2)
void get_frame_is_initialized__(int *frame,int *n)
#else
void get_frame_is_initialized_(int *frame,int *n)
#endif
{
  *n=frame_is_initialized[*frame];
}


/* Store and retrieve functions */
#if defined(USCORE2)
void get_crystal_matrix__(int *frame, double *m)
#else
void get_crystal_matrix_(int *frame, double *m)
#endif
{
  int i;
  for (i=0; i<9; i++)
    m[i]=crystal_matrix[*frame][i];
}

void get_atoms(int *frame,int *n)
{
    *n=atoms[*frame];
}

#if defined(USCORE2)
void get_atoms__(int *frame,int *n)
#else
void get_atoms_(int *frame,int *n)
#endif
{
    get_atoms(frame,n);
}

#if defined(USCORE2)
void get_triangles__(int *frame,int *n)
#else
void get_triangles_(int *frame,int *n)
#endif
{
  *n=triangles[*frame];
}

void get_bonds(int *frame,int *n)
{
  if (*frame==0)
    *n=tempbonds;
  else
    *n=bonds[*frame];
}

#if defined(USCORE2)
void get_bonds__(int *frame,int *n)
#else
void get_bonds_(int *frame,int *n)
#endif
{
    get_bonds(frame,n);
}

#if defined(USCORE2)
void get_hasframetext__(int *frame,int *n)
#else
void get_hasframetext_(int *frame,int *n)
#endif
{
  *n=hasframetext[*frame];
  /*  printf("Getting has frametext =%d for frame %d\n",*n,*frame); */
}

#if defined(USCORE2)
void get_frametextxy__(int *frame,double *x,double *y)
#else
void get_frametextxy_(int *frame,double *x,double *y)
#endif
{
  *x=frametext_x[*frame];
  *y=frametext_y[*frame];
}

void get_atomxyz(int *frame, int *natom, double *x, double *y, double *z)
{
  *x=atomx[*frame][*natom];
  *y=atomy[*frame][*natom];
  *z=atomz[*frame][*natom];
#if 0
  printf("Get atomxyz: %d,%d,%f,%f,%f\n",*frame,*natom,*x,*y,*z);
#endif
}

#if defined(USCORE2)
void get_atomxyz__(int *frame, int *natom, double *x, double *y, double *z)
#else
void get_atomxyz_(int *frame, int *natom, double *x, double *y, double *z)
#endif
{
    get_atomxyz(frame,natom,x,y,z);
}

extern void compute_pairs(double *posx, double *posy, double *posz, int nsites, double rmax, int *npairs);

#if defined(USCORE2)
void compute_pairs__(int *frame, double *rmax, int *npairs)
#else
void compute_pairs_(int *frame, double *rmax, int *npairs)
#endif
{
    compute_pairs(atomx[*frame],atomy[*frame],atomz[*frame], atoms[*frame], *rmax, npairs);
}

void compute_pairs_frame(int frame, double rmax, int *npairs)
{
  compute_pairs(atomx[frame],atomy[frame],atomz[frame],atoms[frame],rmax,npairs);
}


#if defined(USCORE2)
void get_triangle__(int *frame, int *nt, double *x, double *y, double *z,
		    double *nx, double *ny, double *nz, double *fr,
		    double *opaq,
		    int *r, int *g, int *b, int *n, int *twosid)
#else
void get_triangle_(int *frame, int *nt, double *x, double *y, double *z,
		   double *nx, double *ny, double *nz, double *fr,
		   double *opaq,
		   int *r, int *g, int *b, int *n, int *twosid)
#endif
{
  *x=(double)trianglex[*frame][*nt];
  *y=(double)triangley[*frame][*nt];
  *z=(double)trianglez[*frame][*nt];
  *nx=(double)trianglenx[*frame][*nt];
  *ny=(double)triangleny[*frame][*nt];
  *nz=(double)trianglenz[*frame][*nt];
  *fr=(double)trianglefr[*frame][*nt];
  *fr=(double)trianglefr[*frame][*nt];
  *r=triangler[*frame][*nt];
  *g=triangleg[*frame][*nt];
  *b=triangleb[*frame][*nt];
  *n=trianglen[*frame][*nt];
  *twosid=triangletwosided[*frame][*nt];
  *opaq=triangleopaq[*frame][*nt];
}

#if defined(USCORE2)
void set_triangle__(int *frame, int *nt, double *x, double *y, double *z,
		    double *nx, double *ny, double *nz, double *fr,
		    double *opaq,
		    int *r, int *g, int *b, int *n, int *twosid)
#else
void set_triangle_(int *frame, int *nt, double *x, double *y, double *z,
		   double *nx, double *ny, double *nz, double *fr,
		   double *opaq,
		   int *r, int *g, int *b, int *n, int *twosid)
#endif
{
  trianglex[*frame][*nt]=(float)*x;
  triangley[*frame][*nt]=(float)*y;
  trianglez[*frame][*nt]=(float)*z;
  trianglenx[*frame][*nt]=(float)*nx;
  triangleny[*frame][*nt]=(float)*ny;
  trianglenz[*frame][*nt]=(float)*nz;
  trianglefr[*frame][*nt]=(float)*fr;
  triangler[*frame][*nt]=*r;
  triangleg[*frame][*nt]=*g;
  triangleb[*frame][*nt]=*b;
  trianglen[*frame][*nt]=*n;
  triangletwosided[*frame][*nt]=*twosid;
  triangleopaq[*frame][*nt]=*opaq;
}

void set_frame_triangle(int frame, int nt, double x, double y, double z,
			double nx, double ny, double nz, double fr,
			double opaq,
			int r, int g, int b, int n, int twosid)
{
  trianglex[frame][nt]=(float)x;
  triangley[frame][nt]=(float)y;
  trianglez[frame][nt]=(float)z;
  trianglenx[frame][nt]=(float)nx;
  triangleny[frame][nt]=(float)ny;
  trianglenz[frame][nt]=(float)nz;
  trianglefr[frame][nt]=(float)fr;
  triangler[frame][nt]=r;
  triangleg[frame][nt]=g;
  triangleb[frame][nt]=b;
  trianglen[frame][nt]=n;
  triangletwosided[frame][nt]=twosid;
  triangleopaq[frame][nt]=opaq;
}

#if defined(USCORE2)
void set_trianglecompare__(int *frame, int *nt, double *x)
#else
void set_trianglecompare_(int *frame, int *nt, double *x)
#endif
{
  trianglecompare[*frame][*nt]=(float)*x;
}

#if defined(USCORE2)
void get_trianglecompare__(int *frame, int *nt, double *x)
#else
void get_trianglecompare_(int *frame, int *nt, double *x)
#endif
{
  *x=(double)trianglecompare[*frame][*nt];
}

void get_atomrad(int *frame, int *natom, double *rad)
{
  *rad=atomrad[*frame][*natom];
#if 0
  printf("arad=%d %f\n",*frame,*rad);
#endif
}

#if defined(USCORE2)
void get_atomrad__(int *frame, int *natom, double *rad)
#else
void get_atomrad_(int *frame, int *natom, double *rad)
#endif
{
    get_atomrad(frame,natom,rad);
}

void get_atomscalerad(int *frame, int *natom, double *rad)
{
  *rad=atomscalerad[*frame][*natom];
#if 0
  printf("Get atomscalerad for atom %d from frame %d: %g\n",*natom,*frame,*rad);
#endif
}

#if defined(USCORE2)
void get_atomscalerad__(int *frame, int *natom, double *rad)
#else
void get_atomscalerad_(int *frame, int *natom, double *rad)
#endif
{
    get_atomscalerad(frame,natom,rad);
}

#if defined(USCORE2)
void get_atomweight__(int *frame, int *natom, double *weight)
#else
void get_atomweight_(int *frame, int *natom, double *weight)
#endif
{
  *weight=atomweight[*frame][*natom];
}

#if defined(USCORE2)
void get_atomrsv__(int *frame, int *natom, double *rsv)
#else
void get_atomrsv_(int *frame, int *natom, double *rsv)
#endif
{
  *rsv=atomrsv[*frame][*natom];
}

#if defined(USCORE2)
void get_atomsort__(int *frame, int *natom, int *sort)
#else
void get_atomsort_(int *frame, int *natom, int *sort)
#endif
{
  *sort=atomsort[*frame][*natom];
}

#if defined(USCORE2)
void get_trianglesort__(int *frame, int *natom, int *sort)
#else
void get_trianglesort_(int *frame, int *natom, int *sort)
#endif
{
  *sort=trianglesort[*frame][*natom];
}

#if defined(USCORE2)
void get_atomselected__(int *frame, int *natom, int *selected)
#else
void get_atomselected_(int *frame, int *natom, int *selected)
#endif
{
  *selected=atomselected[*frame][*natom];
}

#if defined(USCORE2)
void get_atomn__(int *frame, int *natom, int *n)
#else
void get_atomn_(int *frame, int *natom, int *n)
#endif
{
  *n=atomn[*frame][*natom];
}

#if defined(USCORE2)
void get_atomid__(int *frame, int *natom, int *id)
#else
void get_atomid_(int *frame, int *natom, int *id)
#endif
{
  *id=atomid[*frame][*natom];
}

void get_atomnr(int *frame, int *natom, int *nr)
{
  *nr=atomnr[*frame][*natom];
}

#if defined(USCORE2)
void get_atomnr__(int *frame, int *natom, int *nr)
#else
void get_atomnr_(int *frame, int *natom, int *nr)
#endif
{
    get_atomnr(frame,natom,nr);
}

#if defined(USCORE2)
void get_atomdrawstyle__(int *frame, int *natom, int *drawstyle)
#else
void get_atomdrawstyle_(int *frame, int *natom, int *drawstyle)
#endif
{
  *drawstyle=atomdrawstyle[*frame][*natom];
}

#if defined(USCORE2)
void get_atomhasmessage__(int *frame, int *natom, int *hasmessage)
#else
void get_atomhasmessage_(int *frame, int *natom, int *hasmessage)
#endif
{
  *hasmessage=atomhasmessage[*frame][*natom];
}

#if defined(USCORE2)
void get_atomr__(int *frame, int *natom, int *r)
#else
void get_atomr_(int *frame, int *natom, int *r)
#endif
{
  *r=(int)atomr[*frame][*natom];
}

#if defined(USCORE2)
void get_atomg__(int *frame, int *natom, int *g)
#else
void get_atomg_(int *frame, int *natom, int *g)
#endif
{
  *g=(int)atomg[*frame][*natom];
}

#if defined(USCORE2)
void get_atomb__(int *frame, int *natom, int *b)
#else
void get_atomb_(int *frame, int *natom, int *b)
#endif
{
  *b=(int)atomb[*frame][*natom];
}

void get_defradweight(int *frame, int *natom, int *b)
{
  *b=(int)defradweight[*frame][*natom];
}

#if defined(USCORE2)
void get_defradweight__(int *frame, int *natom, int *b)
#else
void get_defradweight_(int *frame, int *natom, int *b)
#endif
{
    get_defradweight(frame,natom,b);
}

#if defined(USCORE2)
void get_defcol__(int *frame, int *natom, int *b)
#else
void get_defcol_(int *frame, int *natom, int *b)
#endif
{
  *b=(int)defcol[*frame][*natom];
}

#if defined(USCORE2)
void get_deflabel__(int *frame, int *natom, int *b)
#else
void get_deflabel_(int *frame, int *natom, int *b)
#endif
{
  *b=(int)deflabel[*frame][*natom];
}

#if defined(USCORE2)
void get_atomlabel__(int *frame, int *natom, char *label,int length)
#else
void get_atomlabel_(int *frame, int *natom, char *label,int length)
#endif
{
  {
    /* Paranoia check!! */
    int l=strlen(atomlabel[*frame][*natom]);
    if (l>MAXCHARSPERLABEL)
      {
	printf("Stupid!! Forgot to initialize atomlabel somewhere!! (get_atomlabel)\n");
	exit(1);
      }
  }
  strcpy(label,atomlabel[*frame][*natom]);
}

#if defined(USCORE2)
void get_frametext__(int *frame, char *label,int length)
#else
void get_frametext_(int *frame,  char *label,int length)
#endif
{
  {
    /* Paranoia check!! */
    int l=strlen(frametext[*frame]);
    if (l>MAXCHARSINFRAMETEXT)
      {
	printf("Stupid!! Forgot to initialize frametext somewhere!! (get_frametext)\n");
	exit(1);
      }
  }
  strcpy(label,frametext[*frame]);
}

void get_bond1(int *frame, int *nbond, int *bond1x)
{
  if (*frame==0)
    *bond1x=get_bond_ptr(*nbond)->bond1;
  else
    *bond1x=bond1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bond1__(int *frame, int *nbond, int *bond1x)
#else
void get_bond1_(int *frame, int *nbond, int *bond1x)
#endif
{
    get_bond1(frame,nbond,bond1x);
}

void get_bond2(int *frame, int *nbond, int *bond2x)
{
  if (*frame==0)
    *bond2x=get_bond_ptr(*nbond)->bond2;
  else
    *bond2x=bond2[*frame][*nbond];
}

#if defined(USCORE2)
void get_bond2__(int *frame, int *nbond, int *bond2x)
#else
void get_bond2_(int *frame, int *nbond, int *bond2x)
#endif
{
    get_bond2(frame,nbond,bond2x);
}

#if defined(USCORE2)
void get_bondp__(int *frame, int *nbond, int *bond1x,int *bond2x,int *bond3x,int *bond4x)
#else
void get_bondp_(int *frame, int *nbond,  int *bond1x,int *bond2x,int *bond3x,int *bond4x)
#endif
{
  if (*frame==0)
    {
      *bond1x=get_bond_ptr(*nbond)->bondp[0];
      *bond2x=get_bond_ptr(*nbond)->bondp[1];
      *bond3x=get_bond_ptr(*nbond)->bondp[2];
      *bond4x=get_bond_ptr(*nbond)->bondp[3];
    }
  else
    {
      *bond1x=bondp[*frame][*nbond][0];
      *bond2x=bondp[*frame][*nbond][1];
      *bond3x=bondp[*frame][*nbond][2];
      *bond4x=bondp[*frame][*nbond][3];
    }
  /*  printf("get bondp: %d,%d,%d,%d,%d,%d\n",*frame,*nbond,*bond1x,*bond2x,*bond3x,*bond4x); */
}

#if defined(USCORE2)
void get_bondsort__(int *frame, int *nbond, int *bondsortx)
#else
void get_bondsort_(int *frame, int *nbond, int *bondsortx)
#endif
{
  if (*frame==0)
    *bondsortx=get_bond_ptr(*nbond)->bondsort;
  else
    *bondsortx=bondsort[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondselected__(int *frame, int *nbond, int *bondselectedx)
#else
void get_bondselected_(int *frame, int *nbond, int *bondselectedx)
#endif
{
  if (*frame==0)
    *bondselectedx=get_bond_ptr(*nbond)->bondselected;
  else
    *bondselectedx=bondselected[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondn1__(int *frame, int *nbond, int *bondnx)
#else
void get_bondn1_(int *frame, int *nbond, int *bondnx)
#endif
{
  if (*frame==0)
    *bondnx=get_bond_ptr(*nbond)->bondn1;
  else
    *bondnx=bondn1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondnslice__(int *frame, int *nbond, int *bondnx)
#else
void get_bondnslice_(int *frame, int *nbond, int *bondnx)
#endif
{
  if (*frame==0)
    *bondnx=get_bond_ptr(*nbond)->bondnslice;
  else
    *bondnx=bondnslice[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondr1__(int *frame, int *nbond, int *bondrx)
#else
void get_bondr1_(int *frame, int *nbond, int *bondrx)
#endif
{
  if (*frame==0)
    *bondrx=(int)get_bond_ptr(*nbond)->bondr1;
  else
    *bondrx=(int)bondr1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondg1__(int *frame, int *nbond, int *bondgx)
#else
void get_bondg1_(int *frame, int *nbond, int *bondgx)
#endif
{
  if (*frame==0)
    *bondgx=(int)get_bond_ptr(*nbond)->bondg1;
  else
    *bondgx=(int)bondg1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondb1__(int *frame, int *nbond, int *bondbx)
#else
void get_bondb1_(int *frame, int *nbond, int *bondbx)
#endif
{
  if (*frame==0)
    *bondbx=(int)get_bond_ptr(*nbond)->bondb1;
  else
    *bondbx=(int)bondb1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondn2__(int *frame, int *nbond, int *bondnx)
#else
void get_bondn2_(int *frame, int *nbond, int *bondnx)
#endif
{
  if (*frame==0)
    *bondnx=get_bond_ptr(*nbond)->bondn2;
  else
    *bondnx=bondn2[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondr2__(int *frame, int *nbond, int *bondrx)
#else
void get_bondr2_(int *frame, int *nbond, int *bondrx)
#endif
{
  if (*frame==0)
    *bondrx=(int)get_bond_ptr(*nbond)->bondr2;
  else
    *bondrx=(int)bondr2[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondg2__(int *frame, int *nbond, int *bondgx)
#else
void get_bondg2_(int *frame, int *nbond, int *bondgx)
#endif
{
  if (*frame==0)
    *bondgx=(int)get_bond_ptr(*nbond)->bondg2;
  else
    *bondgx=(int)bondg2[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondb2__(int *frame, int *nbond, int *bondbx)
#else
void get_bondb2_(int *frame, int *nbond, int *bondbx)
#endif
{
  if (*frame==0)
    *bondbx=(int)get_bond_ptr(*nbond)->bondb2;
  else
    *bondbx=(int)bondb2[*frame][*nbond];
}

#if defined(USCORE2)
void get_defbcol__(int *frame, int *nbond, int *bondbx)
#else
void get_defbcol_(int *frame, int *nbond, int *bondbx)
#endif
{
  if (*frame==0)
    *bondbx=(int)get_bond_ptr(*nbond)->defbcol;
  else
    *bondbx=(int)defbcol[*frame][*nbond];
}

#if defined(USCORE2)
void get_drawbond__(int *frame, int *nbond, int *bondbx)
#else
void get_drawbond_(int *frame, int *nbond, int *bondbx)
#endif
{
  if (*frame==0)
    *bondbx=(int)get_bond_ptr(*nbond)->drawbond;
  else
    *bondbx=(int)drawbond[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondcompare__(int *frame, int *nbond, double *bondcomparex)
#else
void get_bondcompare_(int *frame, int *nbond, double *bondcomparex)
#endif
{
  if (*frame==0)
    *bondcomparex=get_bond_ptr(*nbond)->bondcompare;
  else
    *bondcomparex=bondcompare[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondrsv1__(int *frame, int *nbond, double *bondrsvx)
#else
void get_bondrsv1_(int *frame, int *nbond, double *bondrsvx)
#endif
{
  if (*frame==0)
    *bondrsvx=get_bond_ptr(*nbond)->bondrsv1;
  else
    *bondrsvx=bondrsv1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondrsv2__(int *frame, int *nbond, double *bondrsvx)
#else
void get_bondrsv2_(int *frame, int *nbond, double *bondrsvx)
#endif
{
  if (*frame==0)
    *bondrsvx=get_bond_ptr(*nbond)->bondrsv2;
  else
    *bondrsvx=bondrsv2[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondrad1__(int *frame, int *nbond, double *bondradx)
#else
void get_bondrad1_(int *frame, int *nbond, double *bondradx)
#endif
{
  if (*frame==0)
    *bondradx=get_bond_ptr(*nbond)->bondrad1;
  else
    *bondradx=bondrad1[*frame][*nbond];
}

#if defined(USCORE2)
void get_bondrad2__(int *frame, int *nbond, double *bondradx)
#else
void get_bondrad2_(int *frame, int *nbond, double *bondradx)
#endif
{
  if (*frame==0)
    *bondradx=get_bond_ptr(*nbond)->bondrad2;
  else
    *bondradx=bondrad2[*frame][*nbond];
}

#if defined(USCORE2)
void get_bond1xyz__(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#else
void get_bond1xyz_(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#endif
{
  if (*frame==0)
    {
      mybond *ptr=get_bond_ptr(*nbond);
      *bondxx=ptr->bond1x;
      *bondyx=ptr->bond1y;
      *bondzx=ptr->bond1z;
    }
  else
    {
      *bondxx=bond1x[*frame][*nbond];
      *bondyx=bond1y[*frame][*nbond];
      *bondzx=bond1z[*frame][*nbond];
    }
}

#if defined(USCORE2)
void get_bond2xyz__(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#else
void get_bond2xyz_(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#endif
{
  if (*frame==0)
    {
      mybond *ptr=get_bond_ptr(*nbond);
      *bondxx=ptr->bond2x;
      *bondyx=ptr->bond2y;
      *bondzx=ptr->bond2z;
    }
  else
    {
      *bondxx=bond2x[*frame][*nbond];
      *bondyx=bond2y[*frame][*nbond];
      *bondzx=bond2z[*frame][*nbond];
    }
}


#if defined(USCORE2)
void set_hasframetext__(int *frame,int *n)
#else
void set_hasframetext_(int *frame,int *n)
#endif
{
  hasframetext[*frame]=*n;
  /*  printf("Setting has frametext =%d for frame %d\n",*n,*frame); */
}

#if defined(USCORE2)
void set_frametextxy__(int *frame,double *x,double *y)
#else
void set_frametextxy_(int *frame,double *x,double *y)
#endif
{
  frametext_x[*frame]=*x;
  frametext_y[*frame]=*y;
}


/* Store and retrieve functions */
#if defined(USCORE2)
void set_crystal_matrix__(int *frame, double *m)
#else
void set_crystal_matrix_(int *frame, double *m)
#endif
{
  int i;
  for (i=0; i<9; i++)
    crystal_matrix[*frame][i]=m[i];
}

#if defined(USCORE2)
void set_atomxyz__(int *frame, int *nbond, double *x, double *y, double *z)
#else
void set_atomxyz_(int *frame, int *nbond, double *x, double *y, double *z)
#endif
{
  /*  printf("Set atomxyz: %d,%d,%f,%f,%f\n",*frame,*nbond,*x,*y,*z); */
  atomx[*frame][*nbond]=*x;
  atomy[*frame][*nbond]=*y;
  atomz[*frame][*nbond]=*z;
}

#if defined(USCORE2)
void set_atomrad__(int *frame, int *nbond, double *rad)
#else
void set_atomrad_(int *frame, int *nbond, double *rad)
#endif
{
  atomrad[*frame][*nbond]=*rad;
}

void set_atomscalerad(int *frame, int *nbond, double *rad)
{
#if 0
  printf("Set atomscalerad for atom %d from frame %d: %g\n",*nbond,*frame,*rad);
#endif
  atomscalerad[*frame][*nbond]=*rad;
}

#if defined(USCORE2)
void set_atomscalerad__(int *frame, int *nbond, double *rad)
#else
void set_atomscalerad_(int *frame, int *nbond, double *rad)
#endif
{
  set_atomscalerad(frame,nbond,rad);
}

#if defined(USCORE2)
void set_atomweight__(int *frame, int *nbond, double *weight)
#else
void set_atomweight_(int *frame, int *nbond, double *weight)
#endif
{
  atomweight[*frame][*nbond]=*weight;
}

#if defined(USCORE2)
void set_atomrsv__(int *frame, int *nbond, double *rsv)
#else
void set_atomrsv_(int *frame, int *nbond, double *rsv)
#endif
{
  atomrsv[*frame][*nbond]=*rsv;
}

#if defined(USCORE2)
void set_atomsort__(int *frame, int *nbond, int *sort)
#else
void set_atomsort_(int *frame, int *nbond, int *sort)
#endif
{
  atomsort[*frame][*nbond]=*sort;
}

#if defined(USCORE2)
void set_trianglesort__(int *frame, int *nbond, int *sort)
#else
void set_trianglesort_(int *frame, int *nbond, int *sort)
#endif
{
  trianglesort[*frame][*nbond]=*sort;
}

#if defined(USCORE2)
void set_atomselected__(int *frame, int *nbond, int *selected)
#else
void set_atomselected_(int *frame, int *nbond, int *selected)
#endif
{
  atomselected[*frame][*nbond]=*selected;
}

#if defined(USCORE2)
void set_atomn__(int *frame, int *nbond, int *n)
#else
void set_atomn_(int *frame, int *nbond, int *n)
#endif
{
  atomn[*frame][*nbond]=*n;
}

#if defined(USCORE2)
void set_atomid__(int *frame, int *nbond, int *id)
#else
void set_atomid_(int *frame, int *nbond, int *id)
#endif
{
  atomid[*frame][*nbond]=*id;
}

#if defined(USCORE2)
void set_atomnr__(int *frame, int *nbond, int *nr)
#else
void set_atomnr_(int *frame, int *nbond, int *nr)
#endif
{
  atomnr[*frame][*nbond]=*nr;
}

#if defined(USCORE2)
void set_atomdrawstyle__(int *frame, int *nbond, int *drawstyle)
#else
void set_atomdrawstyle_(int *frame, int *nbond, int *drawstyle)
#endif
{
  atomdrawstyle[*frame][*nbond]=*drawstyle;
}

#if defined(USCORE2)
void set_atomhasmessage__(int *frame, int *nbond, int *hasmessage)
#else
void set_atomhasmessage_(int *frame, int *nbond, int *hasmessage)
#endif
{
  atomhasmessage[*frame][*nbond]=*hasmessage;
}

#if defined(USCORE2)
void set_atomr__(int *frame, int *nbond, int *r)
#else
void set_atomr_(int *frame, int *nbond, int *r)
#endif
{
  atomr[*frame][*nbond]=(unsigned char)*r;
}

#if defined(USCORE2)
void set_atomg__(int *frame, int *nbond, int *g)
#else
void set_atomg_(int *frame, int *nbond, int *g)
#endif
{
  atomg[*frame][*nbond]=(unsigned char)*g;
}

#if defined(USCORE2)
void set_atomb__(int *frame, int *nbond, int *b)
#else
void set_atomb_(int *frame, int *nbond, int *b)
#endif
{
  atomb[*frame][*nbond]=(unsigned char)*b;
}

#if defined(USCORE2)
void set_defradweight__(int *frame, int *nbond, int *b)
#else
void set_defradweight_(int *frame, int *nbond, int *b)
#endif
{
  defradweight[*frame][*nbond]=(unsigned char)*b;
}

#if defined(USCORE2)
void set_defcol__(int *frame, int *nbond, int *b)
#else
void set_defcol_(int *frame, int *nbond, int *b)
#endif
{
  defcol[*frame][*nbond]=(unsigned char)*b;
}

#if defined(USCORE2)
void set_deflabel__(int *frame, int *nbond, int *b)
#else
void set_deflabel_(int *frame, int *nbond, int *b)
#endif
{
  deflabel[*frame][*nbond]=(unsigned char)*b;
}

#if defined(USCORE2)
void set_atomlabel__(int *frame, int *nbond, char *label,int length)
#else
void set_atomlabel_(int *frame, int *nbond, char *label,int length)
#endif
{
    char *label2=malloc(length);
    memcpy(label2,label,length);
    {
	label2[length-1]=0;
	/* Paranoia check!! */
	if (strlen(label2)>MAXCHARSPERLABEL)
	{
	    printf("Stupid!! Too long string!! (set_atomlabel)\n");
	    exit(1);
	}
    }
    strcpy(atomlabel[*frame][*nbond],label2);
    atomlabel[*frame][*nbond][length]='\0';
    free(label2);
}

#if defined(USCORE2)
void set_frametext__(int *frame, char *label,int length)
#else
void set_frametext_(int *frame,  char *label,int length)
#endif
{
    char *label2=malloc(length);
    memcpy(label2,label,length);
    {
	label2[length-1]=0;
	/* Paranoia check!! */
	if (strlen(label2)>MAXCHARSINFRAMETEXT)
	{
	    printf("Stupid!! Too long string!! (set_frametext)\n");
	    exit(1);
	}
    }
    strcpy(frametext[*frame],label2);
    frametext[*frame][length]='\0';
    free(label2);
}


#if defined(USCORE2)
void set_bond1__(int *frame, int *nbond, int *bond1x)
#else
void set_bond1_(int *frame, int *nbond, int *bond1x)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bond1=*bond1x;
  else
    bond1[*frame][*nbond]=*bond1x;
}

#if defined(USCORE2)
void set_bond2__(int *frame, int *nbond, int *bond2x)
#else
void set_bond2_(int *frame, int *nbond, int *bond2x)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bond2=*bond2x;
  else
    bond2[*frame][*nbond]=*bond2x;
}

#if defined(USCORE2)
void set_bondp__(int *frame, int *nbond, int *bond1x,int *bond2x,int *bond3x,int *bond4x)
#else
void set_bondp_(int *frame, int *nbond, int *bond1x,int *bond2x,int *bond3x,int *bond4x)
#endif
{
  /*  printf("set bondp: %d,%d,%d,%d,%d,%d\n",*frame,*nbond,*bond1x,*bond2x,*bond3x,*bond4x); */
  if (*frame==0)
    {
      get_bond_ptr(*nbond)->bondp[0]=*bond1x;
      get_bond_ptr(*nbond)->bondp[1]=*bond2x;
      get_bond_ptr(*nbond)->bondp[2]=*bond3x;
      get_bond_ptr(*nbond)->bondp[3]=*bond4x;
    }
  else
    {
      bondp[*frame][*nbond][0]=*bond1x;
      bondp[*frame][*nbond][1]=*bond2x;
      bondp[*frame][*nbond][2]=*bond3x;
      bondp[*frame][*nbond][3]=*bond4x;
    }
}

#if defined(USCORE2)
void set_bondsort__(int *frame, int *nbond, int *bondsortx)
#else
void set_bondsort_(int *frame, int *nbond, int *bondsortx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondsort=*bondsortx;
  else
    bondsort[*frame][*nbond]=*bondsortx;
}

#if defined(USCORE2)
void set_bondselected__(int *frame, int *nbond, int *bondselectedx)
#else
void set_bondselected_(int *frame, int *nbond, int *bondselectedx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondselected=*bondselectedx;
  else
    bondselected[*frame][*nbond]=*bondselectedx;
}

#if defined(USCORE2)
void set_bondn1__(int *frame, int *nbond, int *bondnx)
#else
void set_bondn1_(int *frame, int *nbond, int *bondnx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondn1=*bondnx;
  else
    bondn1[*frame][*nbond]=*bondnx;
}

#if defined(USCORE2)
void set_bondnslice__(int *frame, int *nbond, int *bondnx)
#else
void set_bondnslice_(int *frame, int *nbond, int *bondnx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondnslice=*bondnx;
  else
    bondnslice[*frame][*nbond]=*bondnx;
}

#if defined(USCORE2)
void set_bondr1__(int *frame, int *nbond, int *bondrx)
#else
void set_bondr1_(int *frame, int *nbond, int *bondrx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondr1=*bondrx;
  else
    bondr1[*frame][*nbond]=(unsigned char)*bondrx;
}

#if defined(USCORE2)
void set_bondg1__(int *frame, int *nbond, int *bondgx)
#else
void set_bondg1_(int *frame, int *nbond, int *bondgx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondg1=*bondgx;
  else
    bondg1[*frame][*nbond]=(unsigned char)*bondgx;
}

#if defined(USCORE2)
void set_bondb1__(int *frame, int *nbond, int *bondbx)
#else
void set_bondb1_(int *frame, int *nbond, int *bondbx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondb1=*bondbx;
  else
    bondb1[*frame][*nbond]=(unsigned char)*bondbx;
}

#if defined(USCORE2)
void set_bondn2__(int *frame, int *nbond, int *bondnx)
#else
void set_bondn2_(int *frame, int *nbond, int *bondnx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondn2=*bondnx;
  else
    bondn2[*frame][*nbond]=*bondnx;
}

#if defined(USCORE2)
void set_bondr2__(int *frame, int *nbond, int *bondrx)
#else
void set_bondr2_(int *frame, int *nbond, int *bondrx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondr2=*bondrx;
  else
    bondr2[*frame][*nbond]=(unsigned char)*bondrx;
}

#if defined(USCORE2)
void set_bondg2__(int *frame, int *nbond, int *bondgx)
#else
void set_bondg2_(int *frame, int *nbond, int *bondgx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondg2=*bondgx;
  else
    bondg2[*frame][*nbond]=(unsigned char)*bondgx;
}

#if defined(USCORE2)
void set_bondb2__(int *frame, int *nbond, int *bondbx)
#else
void set_bondb2_(int *frame, int *nbond, int *bondbx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondb2=*bondbx;
  else
    bondb2[*frame][*nbond]=(unsigned char)*bondbx;
}

#if defined(USCORE2)
void set_defbcol__(int *frame, int *nbond, int *bondb)
#else
void set_defbcol_(int *frame, int *nbond, int *bondb)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->defbcol=*bondb;
  else
    defbcol[*frame][*nbond]=(unsigned char)*bondb;
}

#if defined(USCORE2)
void set_drawbond__(int *frame, int *nbond, int *bondb)
#else
void set_drawbond_(int *frame, int *nbond, int *bondb)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->drawbond=*bondb;
  else
    drawbond[*frame][*nbond]=(unsigned char)*bondb;
}

#if defined(USCORE2)
void set_bondcompare__(int *frame, int *nbond, double *bondcomparex)
#else
void set_bondcompare_(int *frame, int *nbond, double *bondcomparex)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondcompare=*bondcomparex;
  else
    bondcompare[*frame][*nbond]=*bondcomparex;
}

#if defined(USCORE2)
void set_bondrsv1__(int *frame, int *nbond, double *bondrsvx)
#else
void set_bondrsv1_(int *frame, int *nbond, double *bondrsvx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondrsv1=*bondrsvx;
  else
    bondrsv1[*frame][*nbond]=*bondrsvx;
}

#if defined(USCORE2)
void set_bondrsv2__(int *frame, int *nbond, double *bondrsvx)
#else
void set_bondrsv2_(int *frame, int *nbond, double *bondrsvx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondrsv2=*bondrsvx;
  else
    bondrsv2[*frame][*nbond]=*bondrsvx;
}

#if defined(USCORE2)
void set_bondrad1__(int *frame, int *nbond, double *bondradx)
#else
void set_bondrad1_(int *frame, int *nbond, double *bondradx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondrad1=*bondradx;
  else
    bondrad1[*frame][*nbond]=*bondradx;
}

#if defined(USCORE2)
void set_bondrad2__(int *frame, int *nbond, double *bondradx)
#else
void set_bondrad2_(int *frame, int *nbond, double *bondradx)
#endif
{
  if (*frame==0)
    get_bond_ptr(*nbond)->bondrad2=*bondradx;
  else
    bondrad2[*frame][*nbond]=*bondradx;
}

#if defined(USCORE2)
void set_bond1xyz__(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#else
void set_bond1xyz_(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#endif
{
  if (*frame==0)
    {
      get_bond_ptr(*nbond)->bond1x=*bondxx;
      get_bond_ptr(*nbond)->bond1y=*bondyx;
      get_bond_ptr(*nbond)->bond1z=*bondzx;
    }
  else
    {
      bond1x[*frame][*nbond]=*bondxx;
      bond1y[*frame][*nbond]=*bondyx;
      bond1z[*frame][*nbond]=*bondzx;
    }
}

#if defined(USCORE2)
void set_bond2xyz__(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#else
void set_bond2xyz_(int *frame, int *nbond, double *bondxx,double *bondyx,double *bondzx)
#endif
{
  if (*frame==0)
    {
      get_bond_ptr(*nbond)->bond2x=*bondxx;
      get_bond_ptr(*nbond)->bond2y=*bondyx;
      get_bond_ptr(*nbond)->bond2z=*bondzx;
    }
  else
    {
      bond2x[*frame][*nbond]=*bondxx;
      bond2y[*frame][*nbond]=*bondyx;
      bond2z[*frame][*nbond]=*bondzx;
    }
}

static int acompare(const void *a,const void *b)
{
  if (atomz[nframes+1][*(int*)a-1]>atomz[nframes+1][*(int*)b-1])
    return 1;
  else if (atomz[nframes+1][*(int*)a-1]<atomz[nframes+1][*(int*)b-1])
    return -1;
  else
    return 0;
}

static int bcompare(const void *a,const void *b)
{
  if (bondcompare[nframes+1][*(int*)a-1]>bondcompare[nframes+1][*(int*)b-1])
    return 1;
  else if (bondcompare[nframes+1][*(int*)a-1]<bondcompare[nframes+1][*(int*)b-1])
    return -1;
  else
    return 0;
}

static int tcompare(const void *a,const void *b)
{
  if (trianglecompare[nframes+1][*(int*)a-1]>trianglecompare[nframes+1][*(int*)b-1])
    return 1;
  else if (trianglecompare[nframes+1][*(int*)a-1]<trianglecompare[nframes+1][*(int*)b-1])
    return -1;
  else
    return 0;
}

static int acompare_r(const void *a,const void *b)
{
  if (atomz[nframes+1][*(int*)a-1]<atomz[nframes+1][*(int*)b-1])
    return 1;
  else if (atomz[nframes+1][*(int*)a-1]>atomz[nframes+1][*(int*)b-1])
    return -1;
  else
    return 0;
}

static int bcompare_r(const void *a,const void *b)
{
  if (bondcompare[nframes+1][*(int*)a-1]<bondcompare[nframes+1][*(int*)b-1])
    return 1;
  else if (bondcompare[nframes+1][*(int*)a-1]>bondcompare[nframes+1][*(int*)b-1])
    return -1;
  else
    return 0;
}

static int tcompare_r(const void *a,const void *b)
{
  if (trianglecompare[nframes+1][*(int*)a-1]<trianglecompare[nframes+1][*(int*)b-1])
    return 1;
  else if (trianglecompare[nframes+1][*(int*)a-1]>trianglecompare[nframes+1][*(int*)b-1])
    return -1;
  else
    return 0;
}

#if defined(USCORE2)
void cqsortda_()
#else
void cqsortda_()
#endif
{
#if 0
  if (get_draw_style()==DRAW_STYLE_3D_SPHERES)
    qsort(atomsort[nframes+1],atoms[nframes+1],sizeof(int),acompare_r);
  else
#endif
    qsort(atomsort[nframes+1],atoms[nframes+1],sizeof(int),acompare);
}

#if defined(USCORE2)
void cqsortdb_()
#else
void cqsortdb_()
#endif
{
#if 0
  if (get_draw_style()==DRAW_STYLE_3D_SPHERES)
    qsort(bondsort[nframes+1],bonds[nframes+1],sizeof(int),bcompare_r);
  else
#endif
    qsort(bondsort[nframes+1],bonds[nframes+1],sizeof(int),bcompare);
}

#if defined(USCORE2)
void cqsortdt_()
#else
void cqsortdt_()
#endif
{
#if 0
  if (get_draw_style()==DRAW_STYLE_3D_SPHERES)
    qsort(trianglesort[nframes+1],triangles[nframes+1]/3,sizeof(int),tcompare_r);
  else
#endif
    qsort(trianglesort[nframes+1],triangles[nframes+1]/3,sizeof(int),tcompare);
}
