      /* This is transformationmatrix.F
      A part of the Ymol program
      Copyright (C) 1997-1998 Daniel Spangberg
      */

c     all vectors are column vectors

      subroutine init_t_matrix
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
      do i=1,4
         do j=1,4
            t_matrix(j,i)=0.d0
            r_matrix(j,i)=0.d0
         enddo
      enddo
      do i=1,4
         t_matrix(i,i)=1.d0
         r_matrix(i,i)=1.d0
      enddo
      return
      end


      subroutine itmatr
      call init_t_matrix
      return
      end

      subroutine multiply_vector(matrix,vector)
      implicit double precision (a-h,o-z)
      double precision matrix(4,4)
      double precision vector(3)
      double precision nvector(4)
      do i=1,3
         nvector(i)=vector(i)
      enddo
      nvector(4)=1
      do i=1,3
         vector(i)=0
         do j=1,4
            vector(i)=vector(i)+matrix(j,i)*nvector(j)
         enddo
      enddo
      return
      end

      subroutine transform_vector(vector)
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
      double precision vector(3)
      call multiply_vector(r_matrix,vector)
      call multiply_vector(t_matrix,vector)
      return
      end

      subroutine multiply_local_matrix(matrix,lmatrix)
      implicit double precision (a-h,o-z)
      double precision matrix(4,4),lmatrix(4,4)
      double precision new_t_matrix(4,4)

      do i=1,4
         do j=1,4
            new_t_matrix(i,j)=0
            do k=1,4
               new_t_matrix(i,j)=new_t_matrix(i,j)+
     x              matrix(k,j)*lmatrix(i,k)
            enddo
         enddo
      enddo
      do i=1,4
         do j=1,4
            lmatrix(j,i)=new_t_matrix(j,i)
         enddo
      enddo
      return
      end

      subroutine multiply_global_r_matrix(matrix)
      implicit double precision (a-h,o-z)
      double precision matrix(4,4)
#include "transformationmatrix.commonblock"
c      write(*,*) 'global r:'
c      call write_matrix(r_matrix)
      call multiply_local_matrix(matrix,r_matrix)
      return
      end

      subroutine multiply_global_t_matrix(matrix)
      implicit double precision (a-h,o-z)
      double precision matrix(4,4)
#include "transformationmatrix.commonblock"
c      write(*,*) 'global t:'
c      call write_matrix(t_matrix)
      call multiply_local_matrix(matrix,t_matrix)
      return
      end


      subroutine write_matrix(matrix)
      implicit double precision (a-h,o-z)
      double precision matrix(4,4)
      do i=1,4
         write(*,*) (matrix(i,j),j=1,4)
      enddo
      return
      end





