      program testsock
      implicit double precision (a-h,o-z)
      t=0.d0
      n=10
      nstep=200
      r=5.d0
      step=1.d0/(n*50);
      pi=3.1415926
C     Color components for the bonds (between 0.d0 and 1.d0 all red, green, blue = 1.d0 means white
      xred=1.d0
      xgreen=1.d0
      xblue=1.d0
C     Bond radius
      xrad=0.05d0
C     Reflection parameters
      xrsv=0.7d0
      nrefl=20
C     Initialize
      call yscini
C     Write data in a loop
 10   call yscchy(ierr)
      if (ierr.ne.0) then
C     There are 10 atoms and 9 bonds
        call yswnab(n,n-1,ierr)
        if (ierr.ne.0) then
C     Write atom positions
          do i=1,n
            x=r*sin(3*(t+i*pi*2/nstep))
            y=r*cos(5*(t+i*pi*2/nstep))
            z=r*cos(7*(t+i*pi*2/nstep))
            call yscwat(i,1,x,y,z,ierr)
          enddo
C     Write bonds (connections between atoms)
          do i=1,n-1
C     Connect atom i with atom i+1
            call yscwbd(i,i+1,xred,xgreen,xblue,xrsv,nrefl,xrad,ierr)
          enddo
        endif
      endif
      t=t+pi*2*step
      goto 10
      call yscdin
      stop
      end
