/* This is showframeno.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <X11/Xlib.h>
#include <Xco.h>
#include <string.h>
#include "ccinterface.h"

static int is_open=0;
static char labeltext[100];
static XcoObject window,label;

void update_showframe()
{
  int frame,nframes;
  gframe_(&frame,&nframes);
  if (nframes!=0)
    sprintf(labeltext,"%d/%d",frame,nframes);
  else
    strcpy(labeltext,"-/-");
  if (is_open)
    {
      XcoSetLabelString(label,labeltext);
    }
}

static void delete_callback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      XcoDeleteObject(window);
      is_open=0;
    } 
}


void open_showframe()
{
  if (!is_open)
    {
      XcoObject decorbox;
      update_showframe();
      window=XcoCreateNamedWindow(0,0,166,36,DEFAULT_BACKGROUND,1,-1,"Current Frame");
      XcoAddCallback(window,delete_callback);
      decorbox=XcoCreateBox3D(window,5,5,156,26,2,1);
      label=XcoCreateLabel(decorbox,7,5,labeltext,146,18);
      is_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(window));
    }
}
