/* This is selectanimate.cc
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include "Xco.h"

#include "xinterface.h"

#define ANIMTYPE_CIRCLE 1
#define ANIMTYPE_LINE 2

#define ANIM_SPEED 10

typedef struct anim_object
{
  unsigned char type;
  int x,y;
  int x2,y2;
  struct anim_object *next;
} anim_object;


static anim_object *mylist=NULL;

static int init=0;
static int blackpixel;
static int whitepixel;
static int sequence=0;
static int this_speed=0;

static GC animgc1;
static char dash_list[2]={3,5};

static void anim_init()
{
  XGCValues xgcvalues1;
  unsigned long valuemask1=GCLineStyle|GCForeground|GCBackground;
  whitepixel=XcoGetPixel32(0,0,PIXEL(255,255,255));
  blackpixel=XcoGetPixel32(0,0,PIXEL(0,0,0));


  xgcvalues1.line_style=LineDoubleDash;
  xgcvalues1.foreground=whitepixel;
  xgcvalues1.background=blackpixel;
    
  animgc1=XCreateGC(XcoGetDisplay(),XcoWindow(get_drawbox()),valuemask1,&xgcvalues1);
  init=1;
}


void new_list()
{
  anim_object *t;
  if (!init)
    anim_init();
  t=mylist;
  while (t!=NULL)
    {
      anim_object *t2=t->next;
      free( t);
      t=t2;
    }
  mylist=NULL;
}

void add_anim_circle(int x,int y,int r)
{
  anim_object *nob=malloc(sizeof( anim_object));
  nob->type=ANIMTYPE_CIRCLE;
  nob->x=x;
  nob->y=y;
  nob->x2=r;
  nob->next=mylist;
  mylist=nob;
}

void add_anim_line(int x,int y,int x2,int y2)
{
  anim_object *nob=malloc(sizeof( anim_object));
  nob->type=ANIMTYPE_LINE;
  nob->x=x;
  nob->y=y;
  nob->x2=x2;
  nob->y2=y2;
  nob->next=mylist;
  mylist=nob;
}

void anim_hook()
{
  if (init)
    {
      this_speed--;
      if (this_speed<=0)
	{
	  anim_object *mob=mylist;

	  XSetDashes(XcoGetDisplay(),animgc1,sequence,dash_list,2);
	  while (mob!=NULL)
	    {
	      if (mob->type==ANIMTYPE_CIRCLE)
		{
		  XDrawArc(XcoGetDisplay(),XcoWindow(get_drawbox()),animgc1,
			   mob->x-mob->x2,mob->y-mob->x2,
			   2*mob->x2,2*mob->x2,0,64*360);
		}
	      else if (mob->type==ANIMTYPE_LINE)
		{
		  XDrawLine(XcoGetDisplay(),XcoWindow(get_drawbox()),animgc1,
			    mob->x,mob->y,mob->x2,mob->y2);
		}
	      mob=mob->next;
	    }

	  this_speed=ANIM_SPEED;
	  sequence++;
	  if (sequence>=8)
	    sequence=0;
	}
    }
}

