/* This is render_params.cc
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */


#include <stdio.h>
#include <stdlib.h>
#include "Xco.h"
#include "ccinterface.h"
#include "xinterface.h"
#include "defaults.h"
#include "register_update.h"
#include "triangleworld.h"

static int my_bkgr_color=PIXEL(BKGR_R,BKGR_G,BKGR_B);
static int use_fogging=0;
static double my_fogging_prop=5.0;
static double my_fogging_prop2=0.4;
static int temp_color;
static int temp_fogging,temp_fogging_prop;
static int fading=255;
static int virgin=1;
static int ndots=3;
static double xhowfar=1.;
static double stereoscale,stereoangle,stereotranslate;
static int ntriangles=10;

static double label_color[]={0.,0.,0.};
static double label_z_offset=0.;
static double label_scale=1.;
static double label_xy_offset[]={0.,0.};

static int my_global_oversampling=2;

void set_global_oversampling(int i)
{
  my_global_oversampling=i;
}

int get_global_oversampling()
{
  return(my_global_oversampling);
}

int get_ndots()
{
    return ndots;
}

double get_xhowfar()
{
    return xhowfar;
}

void set_ndots(int x)
{
    ndots=x;
}

void set_xhowfar(double x)
{
    xhowfar=x;
}

void set_bkgr_color(int color)
{
  my_bkgr_color=color;
}

int get_bkgr_color()
{
  return (my_bkgr_color);
}

void get_bkgr_color_vector(int *r,int *g,int *b)
{
  int i=get_bkgr_color();
  *r=R_OF_PIXEL(i);
  *g=G_OF_PIXEL(i);
  *b=B_OF_PIXEL(i);
}

void set_use_fogging(int i)
{
  use_fogging=i;
}

int get_use_fogging()
{
  return(use_fogging);
}

void set_fogging_prop(double i)
{
  my_fogging_prop=i;
}

double get_fogging_prop()
{
  return(my_fogging_prop);
}

void set_fogging_prop2(double i)
{
  my_fogging_prop2=i;
}

double get_fogging_prop2()
{
  return(my_fogging_prop2);
}

void set_fading(int i)
{
  fading=i;
}

int get_fading()
{
  return (fading);
}

void set_label_color(double *rgb)
{
    int i;
    for (i=0; i<3; i++)
	label_color[i]=rgb[i];
}

void get_label_color(double *rgb)
{
    int i;
    for (i=0; i<3; i++)
	rgb[i]=label_color[i];
}

void set_label_xy_offset(double *x)
{
    int i;
    for (i=0; i<2; i++)
	label_xy_offset[i]=x[i];
}

void get_label_xy_offset(double *x)
{
    int i;
    for (i=0; i<2; i++)
	x[i]=label_xy_offset[i];
}

void set_label_z_offset(double z)
{
    label_z_offset=z;
}

void get_label_z_offset(double *z)
{
    *z=label_z_offset;
}

void set_label_scale(double z)
{
    label_scale=z;
}

void get_label_scale(double *z)
{
    *z=label_scale;
}

#define WINDOW_WIDTH 200
#define WINDOW_HEIGHT 450

static int edit_open=0;
static XcoObject ewindow,colorhole,fogtoggle,propdialog,prop2dialog,osdialog;
static XcoObject ckdialog,zmindialog,zmaxdialog,colsel,ndotsdialog,xhowfardialog;
static XcoObject xstereoangle,xstereoscale,xstereotranslate,ntrianglesdialog;

static void e_delete_window(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      XcoDeleteObject(ewindow);
      edit_open=0;
    }
}

static void set_colorpixmap(unsigned int pixel)
{
  int i;
  Pixmap colorpixmap;
  unsigned int image[16];
  for (i=0; i<16; i++)
    image[i]=pixel;
  colorpixmap=XcoCreatePixmapFromImage(colorhole,image,4,4);
  XcoSetBackgroundPixmap(colorhole,colorpixmap,True);
  XFreePixmap(XcoGetDisplay(),colorpixmap);
}

static void use_color(int r,int g,int b,int ok)
{
  if (edit_open)
    if (ok)
      {
	temp_color=PIXEL(r,g,b);
	set_colorpixmap(temp_color);
      }
}

static int open_bcolor=0;

static void dcolsel(XcoObject dummy,XEvent event)
{
  if (event.type==DestroyNotify)
    {
      open_bcolor=0;
    }
}


static void browse_colors(XcoObject dummy,XEvent event)
{
  if (edit_open)
    {
      if (event.type==ButtonPress)
	{
	  if (!open_bcolor)
	    {
	      colsel=XcoColorselector(R_OF_PIXEL(temp_color),
						G_OF_PIXEL(temp_color),
						B_OF_PIXEL(temp_color),
						use_color);
	      XcoAddCallback(colsel,dcolsel);
	      open_bcolor=1;
	    }
	}
    }
}

static void apply_changes(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int tmp;
      int dowupd=0;
      set_use_fogging(XcoGetToggleSelected(fogtoggle));
      set_bkgr_color(temp_color);
      set_global_oversampling(atoi(XcoGetDialogValue(osdialog)));
      set_fogging_prop(atof(XcoGetDialogValue(propdialog)));
      set_fogging_prop2(atof(XcoGetDialogValue(prop2dialog)));
      setck(atof(XcoGetDialogValue(ckdialog)));
      setZMIN(atof(XcoGetDialogValue(zmindialog)));
      setZMAX(atof(XcoGetDialogValue(zmaxdialog)));
      xhowfar=atof(XcoGetDialogValue(xhowfardialog));
      if (xhowfar<1.)
      {
	  char props[10];
	  xhowfar=1.0;
	  sprintf(props,"%4.2f",xhowfar);
	  XcoSetDialogValue(xhowfardialog,props);
      }
      stereoangle=atof(XcoGetDialogValue(xstereoangle));
      stereoscale=atof(XcoGetDialogValue(xstereoscale));
      stereotranslate=atof(XcoGetDialogValue(xstereotranslate));
      stepar_(&stereoangle,&stereoscale,&stereotranslate);
      steqry_(&tmp);
      setste_(&tmp);

      ndots=atoi(XcoGetDialogValue(ndotsdialog));

      
      tmp=atoi(XcoGetDialogValue(ntrianglesdialog));
      if (ntriangles!=tmp)
	{
	  dowupd=1;
	  ntriangles=tmp;
	  stntrz_(&ntriangles);
	}

      if (get_draw_style()==DRAW_STYLE_3D_SPHERES)
	set_oversampling(get_global_oversampling());
      if (dowupd)
	wupd_();
      else
	fupd_();
    }
}

static void update_em()
{
  if (open_bcolor)
    {
      XcoDeleteObject(colsel);
      open_bcolor=0;
    }
  if (edit_open)
    {
      char props[10];
      set_colorpixmap(get_bkgr_color());
      XcoSetToggleSelected(fogtoggle,get_use_fogging());
      sprintf(props,"%4.2f",get_fogging_prop());
      XcoSetDialogValue(propdialog,props);
      sprintf(props,"%4.2f",get_fogging_prop2());
      XcoSetDialogValue(prop2dialog,props);
      sprintf(props,"%d",get_global_oversampling());
      XcoSetDialogValue(osdialog,props);
      sprintf(props,"%4.2f",getck());
      XcoSetDialogValue(ckdialog,props);
      sprintf(props,"%4.2f",getZMIN());
      XcoSetDialogValue(zmindialog,props);
      sprintf(props,"%4.2f",getZMAX());
      XcoSetDialogValue(zmaxdialog,props);
      sprintf(props,"%4.2f",xhowfar);
      XcoSetDialogValue(xhowfardialog,props);
      sprintf(props,"%d",ndots);
      XcoSetDialogValue(ndotsdialog,props);
      tznqry_(&ntriangles);
      sprintf(props,"%d",ntriangles);
      XcoSetDialogValue(ntrianglesdialog,props);
      stepqy_(&stereoangle,&stereoscale,&stereotranslate);
      sprintf(props,"%4.2f",stereoangle);
      XcoSetDialogValue(xstereoangle,props);
      sprintf(props,"%4.2f",stereoscale);
      XcoSetDialogValue(xstereoscale,props);
      sprintf(props,"%4.2f",stereotranslate);
      XcoSetDialogValue(xstereotranslate,props);
    }
}

void edit_rendering_parameters()
{
  if (!edit_open)
    {
      int ypos;
      XcoObject hole,hole2,label,hole3,bcmd,colorbox,acmd,decorbox;
      char props[10];
      if (virgin)
	{
	  register_update_function(update_em);
	  virgin=0;
	}

      ewindow=XcoCreateNamedDialogParent(-1,0,0,WINDOW_WIDTH,WINDOW_HEIGHT,"Render parameters");

      XcoAddCallback(ewindow,e_delete_window);

      decorbox=XcoCreateBox3D(ewindow,5,5,WINDOW_WIDTH-10,WINDOW_HEIGHT-45,2,1);

      hole=XcoCreateHole(decorbox,5,5,WINDOW_WIDTH-20,50);
      hole2=XcoCreateHole(hole,0,0,WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Background color",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      hole3=XcoCreateHole(hole2,0,ypos,WINDOW_WIDTH-20,50-ypos);
      XcoSetResizeMethod(hole3,XcoUpResize);
      bcmd=XcoCreateCommand(hole3,60,0,"Browse",0,0);
      colorbox=XcoCreateBox3D(hole3,0,0,50,XcoGetObjectHeight(bcmd),0,1);
      colorhole=XcoCreateHole(colorbox,2,2,46,XcoGetObjectHeight(bcmd)-4);
      XcoAddCallback(bcmd,browse_colors);
      XcoSetResizeMethod(colorbox,XcoUpLeftDownRight);
      XcoSetResizeMethod(colorhole,XcoUpLeftDownRight);
      XcoSetResizeMethod(bcmd,XcoUpRight);
      
      temp_color=get_bkgr_color();
      set_colorpixmap(temp_color);

      hole=XcoCreateHole(decorbox,5,55,WINDOW_WIDTH-20,50);
      label=XcoCreateLabel(hole,0,0,"Use fogging",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      fogtoggle=XcoCreateToggle(hole,XcoGetObjectWidth(label)+10,
				(XcoGetObjectHeight(label)-10)/2,
				10,10,PIXEL(255,0,0),1,get_use_fogging());

      acmd=XcoCreateCommand(ewindow,10,WINDOW_HEIGHT-30,"Apply",0,0);
      XcoAddCallback(acmd,apply_changes);

      label=XcoCreateLabel(decorbox,5,80,"Fog amount:",0,0);
      sprintf(props,"%4.2f",get_fogging_prop());
      propdialog=XcoCreateDialog(decorbox,95,
				 80,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,105,"Fog origin:",0,0);
      sprintf(props,"%4.2f",get_fogging_prop2());
      prop2dialog=XcoCreateDialog(decorbox,95,
				 105,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,130,"Oversampling:",0,0);
      sprintf(props,"%d",get_global_oversampling());
      osdialog=XcoCreateDialog(decorbox,95,
				 130,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,155,"Camera K:",0,0);
      sprintf(props,"%4.2f",getck());
      ckdialog=XcoCreateDialog(decorbox,95,
				 155,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,180,"Clip Z-min:",0,0);
      sprintf(props,"%4.2f",getZMIN());
      zmindialog=XcoCreateDialog(decorbox,95,
				 180,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,205,"Clip Z-max:",0,0);
      sprintf(props,"%4.2f",getZMAX());
      zmaxdialog=XcoCreateDialog(decorbox,95,
				 205,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,230,"# shades:",0,0);
      sprintf(props,"%d",ndots);
      ndotsdialog=XcoCreateDialog(decorbox,95,
				  230,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,255,"Less white:",0,0);
      sprintf(props,"%4.2f",xhowfar);
      xhowfardialog=XcoCreateDialog(decorbox,95,
				  255,ewindow,props,4,80,0);


      stepqy_(&stereoangle,&stereoscale,&stereotranslate);

      label=XcoCreateLabel(decorbox,5,280,"Stereoangle:",0,0);
      sprintf(props,"%4.2f",stereoangle);
      xstereoangle=XcoCreateDialog(decorbox,95,280,ewindow,props,5,80,0);

      label=XcoCreateLabel(decorbox,5,305,"Stereoscale:",0,0);
      sprintf(props,"%4.2f",stereoscale);
      xstereoscale=XcoCreateDialog(decorbox,95,305,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,330,"Stereotrans:",0,0);
      sprintf(props,"%4.2f",stereotranslate);
      xstereotranslate=XcoCreateDialog(decorbox,95,330,ewindow,props,4,80,0);

      label=XcoCreateLabel(decorbox,5,355,"Triangles:",0,0);
      tznqry_(&ntriangles);
      sprintf(props,"%d",ntriangles);
      ntrianglesdialog=XcoCreateDialog(decorbox,95,
				       355,ewindow,props,4,80,0);

      edit_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(ewindow));
    }
}

