      /* This is render.F
      A part of the Ymol program
      Copyright (C) 1997-1998 Daniel Spangberg
      */

#include "defaults.h"
#include "phongdef.h"

      function isqrt(i)
      integer isqrt,i
c     should be a true integer sqrt function
      isqrt=int(sqrt(real(i)))
      return
      end

      function dsgn(f)
      implicit double precision (a-h,o-z)
      double precision f
      if (f.gt.0) then
         dsgn=1.d0
      else
         dsgn=-1.d0
      endif
      return
      end

      subroutine def_res(x,y)
      implicit double precision (a-h,o-z)
      integer x,y
#include "coordinates.commonblock"
#include "stereo.commonblock"
c      write (*,*) 'def res called with: ',x
      xrescp=x
      if (nstereo.eq.1) then
         call dsget(istyle)
c         write (*,*) 'istyle is ',istyle
c         write (*,*) 'DRS3 is ', DRAW_STYLE_3D_SPHERES
         if (istyle.ne.DRAW_STYLE_3D_SPHERES) then
            xres=x/2
c            write(*,*) 'halving resolution'
          else
            xres=x
         endif
      else
         xres=x
      endif
      yres=y
      zres=ZMAXDEPTH
      xmid=xres/2
      ymid=yres/2
c      write (*,*) 'def_res result: ',xres,xmid
      return
      end
      



c     THIS ONE IS CURRENTLY WRONG!!
c     u is the largest value of any coordinate
      subroutine def_unit(unit)
      implicit double precision (a-h,o-z)
      double precision unit,u
#include "coordinates.commonblock"
#include "stereo.commonblock"

      call dsget(ids)

      xresscale=xres
      xmidscale=xmid
      if (nstereo.eq.1) then
         if (ids.eq.DRAW_STYLE_3D_SPHERES) then
            xresscale=xresscale*0.5d0
            xmidscale=xmidscale*0.5d0
         endif
      endif

      myunit=unit
      u=unit*CAMERA_K/(CAMERA_K-1.d0)
      if (yres.gt.xresscale) then
         xcoord=u
         ycoord=u*dble(yres)/dble(xresscale)
      else
         ycoord=u
         xcoord=u*dble(xresscale)/dble(yres)
      endif
      zcoord=u
      xc2xr=xmidscale/xcoord
      xc2xr=xc2xr*currentscale
c      write(*,*) 'xc2xr:',
c     x     xc2xr
      return
      end

#if 0
      function camera(zcoord,size)
      implicit double precision (a-h,o-z)
      camera=size*CAMERATYPE/(CAMERATYPE-zcoord)
      return
      end
#endif

c     This routine should be called with the coordinates and the
c     size of the object to be shown. It will return the correct
c     coordinates and size of the object.
      subroutine coord_convert(x,y,z,object_size)
      implicit double precision (a-h,o-z)
      double precision x,y,z,object_size
#include "coordinates.commonblock"
      x=xmid+x*xc2xr
      y=ymid-y*xc2xr
      z=z*xc2xr
      object_size=object_size*xc2xr
c      if (object_size.lt.1.d0) object_size=1.d0
      if (object_size.lt.0.01d0) object_size=0.01d0
c      write(*,*) 'xcf:',xc2xr
      return
      end

      subroutine fperspective(x,y,z,xsize,ysize)
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
      integer x,y,z
      integer xsize,ysize,xmid,ymid,ZMAXP,ZMINP
      call gpersp(ip)
      call getzmn(ZMIN)
      call getzmx(ZMAX)
      if (ip.ne.0) then
         xmid=xsize/2
         ymid=ysize/2
         if (xsize.gt.ysize) then
            ZMAXP=xsize
         else
            ZMAXP=ysize
         endif
         ZMINP=-ZMAXP
         dv=1.d0/dble(ZMAXP-ZMINP)
         zv=1.d0-dv*(z-ZMINP)
         x=xmid+int((x-xmid)*getck()/zv)
         y=ymid+int((y-ymid)*getck()/zv)
         zv=(1.d0-(ZMIN/zv))/(1.d0-ZMIN/ZMAX)
         z=ZMAXP-int(zv*(ZMAXP-ZMINP))
      else
         xmid=xsize/2
         ymid=ysize/2
         ztrans=t_matrix(4,3)
c         write(*,*) 'Z:',ztrans
         x=xmid+int(x-xmid)*(1.d0+(ztrans*0.1d0))
         y=ymid+int(y-ymid)*(1.d0+(ztrans*0.1d0))
      endif
      return
      end

      subroutine fperspectivef(x,y,z,xsize,ysize)
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
      integer xsize,ysize,xmid,ymid,ZMAXP,ZMINP
      call gpersp(ip)
      call getzmn(ZMIN)
      call getzmx(ZMAX)
      if (ip.ne.0) then
         xmid=xsize/2
         ymid=ysize/2
         if (xsize.gt.ysize) then
            ZMAXP=xsize
         else
            ZMAXP=ysize
         endif
         ZMINP=-ZMAXP
         dv=1.d0/dble(ZMAXP-ZMINP)
         zv=1.d0-dv*(z-ZMINP)
         x=xmid+(x-xmid)*getck()/zv
         y=ymid+(y-ymid)*getck()/zv
         zv=(1.d0-(ZMIN/zv))/(1.d0-ZMIN/ZMAX)
         z=ZMAXP-zv*(ZMAXP-ZMINP)
      else
         xmid=xsize/2
         ymid=ysize/2
         ztrans=t_matrix(4,3)
c         write(*,*) 'Z:',ztrans
         x=xmid+(x-xmid)*(1.d0+(ztrans*0.1d0))
         y=ymid+(y-ymid)*(1.d0+(ztrans*0.1d0))
      endif
      return
      end

      subroutine gztr(zt)
      implicit double precision (a-h,o-z)
#include "transformationmatrix.commonblock"
      zt=t_matrix(4,3)
      return
      end

      subroutine fogfac(z,xsize,ysize,prop,prop2,dv)
      implicit double precision (a-h,o-z)
      integer z,xsize,ysize
      double precision prop,prop2,dv
      integer ZMAXP,ZMINP
c      write(*,*) 'I got this z=',z
c      write(*,*) 'fog props:',prop,prop2
      xmid=xsize/2
      ymid=ysize/2
      if (xsize.gt.ysize) then
         ZMAXP=xsize
      else
         ZMAXP=ysize
      endif
      ZMINP=-ZMAXP
      dv=dble(z-ZMINP)/(ZMAXP-ZMINP)
      call gpersp(ip)
c     Add some (empirical) factors.
      if (ip.ne.0) then
         dv=dv+prop2
         dv=(dv-0.5d0)*prop+0.5d0
         if (dv.lt.0.d0) dv=0.d0
         if (dv.gt.1.d0) dv=1.d0
      else
         dv=dv+prop2-0.5d0
         dv=(dv-0.5d0)*prop*0.4d0+0.5d0
         if (dv.lt.0.d0) dv=0.d0
         if (dv.gt.1.d0) dv=1.d0
      endif
      return
      end

      subroutine fog(z,r,g,b,xsize,ysize,prop,prop2)
      implicit double precision (a-h,o-z)
      integer z,r,g,b,xsize,ysize
      double precision prop,prop2
      call fogfac(z,xsize,ysize,prop,prop2,dv)
      call gbkgrv(ir,ig,ib)
      r=int(r*dv+ir*(1.d0-dv))
      g=int(g*dv+ig*(1.d0-dv))
      b=int(b*dv+ib*(1.d0-dv))
      return
      end

      subroutine fade(r,g,b,f)
      implicit double precision (a-h,o-z)
      integer r,g,b,f
      if (f.ne.255) then
         call gbkgrv(ir,ig,ib)
         dv=dble(f)/255.d0
         r=int(r*dv+ir*(1.d0-dv))
         g=int(g*dv+ig*(1.d0-dv))
         b=int(b*dv+ib*(1.d0-dv))
      endif
      return
      end

      function iclip(z,xsize,ysize)
      implicit double precision (a-h,o-z)
      integer z
      integer xsize,ysize,xmid,ymid,ZMAXP,ZMINP
      call getzmn(ZMIN)
      call getzmx(ZMAX)
      xmid=xsize/2
      ymid=ysize/2
      if (xsize.gt.ysize) then
         ZMAXP=xsize
      else
         ZMAXP=ysize
      endif
      ZMINP=-ZMAXP
      dv=1.d0/dble(ZMAXP-ZMINP)
      zv=1.d0-dv*(z-ZMINP)
      if ((zv.gt.ZMAX).or.(zv.lt.ZMIN)) then
         iclip=1
      else
         iclip=0
      endif
      return
      end


c     default values for the phongshading routines
      subroutine init_phongtables
      implicit double precision (a-h,o-z)
#include "phong.commonblock"
c     the color of the diffuse light
      Ibv(1)=0.3d0
      Ibv(2)=0.3d0
      Ibv(3)=0.3d0
      call bglght(int(255*Ibv(1)),int(255*Ibv(2)),int(255*Ibv(3)))
      
c     the spheres reflection coefficient for mirroring reflection
      Rsv(1)=0.7d0
      Rsv(2)=0.7d0
      Rsv(3)=0.7d0


c     the number of lamps
      lamps=2

c     the vector to the lamps
      lampv(1,1)=15
      lampv(1,2)=5
      lampv(1,3)=6

      lampv(2,1)=-5
      lampv(2,2)=5
      lampv(2,3)=1

      lampv(3,1)=-5
      lampv(3,2)=-15
      lampv(3,3)=0

      lampv(4,1)=5
      lampv(4,2)=-15
      lampv(4,3)=0

c     the color of the lamps
      Idv(1,1)=0.7d0
      Idv(1,2)=0.7d0
      Idv(1,3)=0.7d0

      Idv(2,1)=0.3d0
      Idv(2,2)=0.3d0
      Idv(2,3)=0.3d0

      Idv(3,1)=0.15d0
      Idv(3,2)=0.15d0
      Idv(3,3)=0.15d0

      Idv(4,1)=0.15d0
      Idv(4,2)=0.15d0
      Idv(4,3)=0.15d0

c     How "shiny" the objects should be
      npot=20



c     Normalize lamp vector.
c     We could use the lampvector as coordinates instead and recalculate
c     the vector for each dot. This allows rays not to be forced to be
c     parallel.

      call lnew(lamps)

      do i=1,lamps
         lampn=sqrt(lampv(i,1)*lampv(i,1)+
     x        lampv(i,2)*lampv(i,2)+
     x        lampv(i,3)*lampv(i,3))
         lampv(i,1)=lampv(i,1)/lampn
         lampv(i,2)=lampv(i,2)/lampn
         lampv(i,3)=lampv(i,3)/lampn
         
         call lmpadd(lampv(i,1),lampv(i,2),lampv(i,3),
     x        int(Idv(i,1)*255),int(Idv(i,2)*255),int(Idv(i,3)*255))




      enddo

      return
      end

C     Synchronize lamps
      subroutine sylamp
      implicit double precision (a-h,o-z)
#include "phong.commonblock"
      call gtlmps(lamps)
      do i=1,lamps
         call lmpget(i-1,lampv(i,1),lampv(i,2),lampv(i,3),
     x        ir,ig,ib)
         Idv(i,1)=ir/255.d0
         Idv(i,2)=ig/255.d0
         Idv(i,3)=ib/255.d0
      enddo

      return
      end



      subroutine init_action
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      playmovie=0
      loopmovie=0
      rotate_x=0
      rotate_y=0
      rotate_z=0
      iematrix=0
      itmatrix=0
      ie2matrix=0
      zoom_inout=0
      continous=0
      continous_play=0
      world_update=0
      ihardupdate=1
      force_update=0
      dump_ppm=0
      showlabel=0
      return
      end

      subroutine init_status
      implicit double precision (a-h,o-z)
#include "status.commonblock"
c      angle_x=0
c      angle_y=0
c      angle_z=0
      speed=5
      angle_inc=speed*3.1415926d0/180.0d0
      zoomfac=speed*0.1d0
      frame=1
      anything=0
      oversample=2
      return
      end

      subroutine govsmp(i)
      implicit double precision (a-h,o-z)
#include "status.commonblock"
      i=oversample
      return
      end

      subroutine sovsmp(i)
      implicit double precision (a-h,o-z)
#include "status.commonblock"
      oversample=i
      return
      end


      subroutine dlqry(i)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      i=showlabel
      return
      end

      subroutine dlbl(i)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      showlabel=i
      return
      end


      subroutine getlop(i)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      i=loopmovie
      return
      end

      subroutine setlop(i)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      loopmovie=i
      return
      end

      subroutine dppm(i)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      dump_ppm=i
      return
      end

      subroutine mplay(i,icont)
      implicit double precision (a-h,o-z)
      integer i
#include "action.commonblock"
      playmovie=i
      continous_play=icont
      return
      end


c     force update and reread the frame (world update)
      subroutine wupd
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      world_update=1
      ihardupdate=1
      return
      end

c     force update and reread the frame (world update)
      subroutine wupds
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      world_update=1
      ihardupdate=0
      return
      end

c     force update without reading the frame
      subroutine fupd
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      force_update=1
      return
      end

      subroutine rotx(i)
      implicit double precision (a-h,o-z)
      integer i
#include "action.commonblock"
      rotate_x=i
      return
      end

      subroutine rspd(sp)
      implicit double precision (a-h,o-z)
      double precision sp
#include "status.commonblock"
      speed=sp
      angle_inc=speed*3.1415926d0/180.0d0      
      return
      end

      subroutine roty(i)
      implicit double precision (a-h,o-z)
      integer i
#include "action.commonblock"
      rotate_y=i
      return
      end

      subroutine rotz(i)
      implicit double precision (a-h,o-z)
      integer i
#include "action.commonblock"
      rotate_z=i
      return
      end

      subroutine zinout(i)
      implicit double precision (a-h,o-z)
      integer i
#include "action.commonblock"
      zoom_inout=i
      return
      end

      subroutine cont(i)
      implicit double precision (a-h,o-z)
      integer i
#include "action.commonblock"
      continous=i
      return
      end

      subroutine setany(i)
      implicit double precision (a-h,o-z)
      integer i
#include "status.commonblock"
      anything=i
      return
      end

      subroutine getany(i)
      implicit double precision (a-h,o-z)
      integer i
#include "status.commonblock"
      i=anything
      return
      end

      subroutine gframe(iframe,nframes)
      implicit double precision (a-h,o-z)
      integer iframe,nframes
#include "status.commonblock"
      iframe=frame
      call get_nframes(nframes)
      return
      end

      subroutine sframe(iframe)
      implicit double precision (a-h,o-z)
      integer iframe,nframes
#include "status.commonblock"
      frame=iframe
      return
      end

      subroutine sematr()
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      iematrix=1
      return
      end

      subroutine stmatr()
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      itmatrix=1
      return
      end

      subroutine se2mat()
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      ie2matrix=1
      return
      end

      subroutine fsorg(x,y)
      implicit double precision (a-h,o-z)
#include "externmatrix.commonblock"
      integer x,y
      exfrom=x
      eyfrom=y
      exto=x
      eyto=y
      extto=x
      eytto=y
      return
      end

      subroutine gsorg(x,y)
      implicit double precision (a-h,o-z)
#include "externmatrix.commonblock"
      integer x,y
      x=exfrom
      y=eyfrom
      return
      end

      subroutine fsto(x,y)
      implicit double precision (a-h,o-z)
#include "externmatrix.commonblock"
      integer x,y
      exto=x
      eyto=y
      return
      end

      subroutine fstto(x,y)
      implicit double precision (a-h,o-z)
#include "externmatrix.commonblock"
      integer x,y
      extto=x
      eytto=y
      return
      end


      subroutine se2mel(i,x)
      implicit double precision (a-h,o-z)
#include "e2matrix.commonblock"
      j=MOD(i,4)
      e2matrix(1+i/4,1+j)=x
      return
      end

      subroutine ttrans(xsize,ysize)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
#include "externmatrix.commonblock"
      integer xsize,ysize
      integer xmid,ymid
      double precision lmatrix(4,4)
      do i=1,4
         do j=1,4
            tmatrix(j,i)=0.d0
         enddo
      enddo
      do j=1,4
         tmatrix(j,j)=1.d0
      enddo

      if ((exfrom.ne.extto).or.(eyfrom.ne.eytto)) then
        xdiff=extto-exfrom
        ydiff=eytto-eyfrom
        
        tmatrix(4,1)=xdiff*0.02d0
        tmatrix(4,2)=-ydiff*0.02d0

        exfrom=extto
        eyfrom=eytto
        exto=extto
        eyto=eytto
      endif


      return
      end

      subroutine erotate(xsize,ysize)
      implicit double precision (a-h,o-z)
#include "action.commonblock"
#include "externmatrix.commonblock"
      integer xsize,ysize
      integer xmid,ymid
      double precision lmatrix(4,4)

      do i=1,4
         do j=1,4
            ematrix(j,i)=0.d0
         enddo
      enddo
      do j=1,4
         ematrix(j,j)=1.d0
      enddo

      if ((exfrom.ne.exto).or.(eyfrom.ne.eyto)) then
         xmid=xsize/2
         ymid=ysize/2
         if (xmid.lt.ymid) then
            min=xmid
         else
            min=ymid
         endif
         x1=exfrom-xmid
         y1=eyfrom-ymid
         x2=exto-xmid
         y2=eyto-ymid
         if (x1.gt.min) x1=min
         if (x1.lt.-min) x1=-min
         if (y1.gt.min) y1=min
         if (y1.lt.-min) y1=-min
         if (x2.gt.min) x2=min
         if (x2.lt.-min) x2=-min
         if (y2.gt.min) y2=min
         if (y2.lt.-min) y2=-min
         a=dble(x1)/dble(min)
         b=dble(y1)/dble(min)
         d=dble(x2)/dble(min)
         e=dble(y2)/dble(min)
         ablen=sqrt(a*a+b*b)
         if (ablen.gt.1.d0) then
            a=a/ablen
            b=b/ablen
         endif
         delen=sqrt(d*d+e*e)
         if (delen.gt.1.d0) then
            d=d/delen
            e=e/delen
         endif
         
         if (ablen.gt.1.d0) then
            c=0.d0
         else
            c=sqrt(1.d0-a*a-b*b)
         endif
         if (delen.gt.1.d0) then
            f=0.d0
         else
            f=sqrt(1.d0-d*d-e*e)
         endif


c         write(*,*) 'a,b,c',a,b,c
c         write(*,*) 'd,e,f:',d,e,f


         vlen=sqrt(a*a+b*b+c*c)
         a=a/vlen
         b=b/vlen
         c=c/vlen
         vlen=sqrt(d*d+e*e+f*f)
         d=d/vlen
         e=e/vlen
         f=f/vlen
         



         x=b*f-c*e
         y=c*d-a*f
         z=a*e-b*d
         vlen=sqrt(x*x+y*y+z*z)
c         write(*,*) 'vlen:',vlen
         if (vlen.gt.0) then
            x=x/vlen
            y=y/vlen
            z=z/vlen
            y=-y

            x=-x
            y=-y
            z=-z


            q=sqrt(x*x+y*y)
            if (q.ne.0) then
c     r1
               do i=1,4
                  do j=1,4
                     lmatrix(j,i)=0.d0
                  enddo
               enddo
               do j=1,4
                  lmatrix(j,j)=1.d0
               enddo
               lmatrix(1,1)=x/q
               lmatrix(1,2)=-y/q
               lmatrix(2,1)=y/q
               lmatrix(2,2)=x/q
               call multiply_local_matrix(lmatrix,ematrix)
c     r2
               do i=1,4
                  do j=1,4
                     lmatrix(j,i)=0.d0
                  enddo
               enddo
               do j=1,4
                  lmatrix(j,j)=1.d0
               enddo
               lmatrix(1,1)=z
               lmatrix(1,3)=q
               lmatrix(3,1)=-q
               lmatrix(3,3)=z
               call multiply_local_matrix(lmatrix,ematrix)

c     r3
               do i=1,4
                  do j=1,4
                     lmatrix(j,i)=0.d0
                  enddo
               enddo
               do j=1,4
                  lmatrix(j,j)=1.d0
               enddo
               costheta1=a*d+b*e+c*f
               sintheta1=sqrt(1.d0-costheta1*costheta1)
c     Use double angle.
               costheta=1.d0-2.d0*sintheta1*sintheta1
               sintheta=2.d0*sintheta1*costheta1
               lmatrix(1,1)=costheta
               lmatrix(1,2)=sintheta
               lmatrix(2,1)=-sintheta
               lmatrix(2,2)=costheta
               call multiply_local_matrix(lmatrix,ematrix)

c     r2-1
               do i=1,4
                  do j=1,4
                     lmatrix(j,i)=0.d0
                  enddo
               enddo
               do j=1,4
                  lmatrix(j,j)=1.d0
               enddo
               lmatrix(1,1)=z
               lmatrix(1,3)=-q
               lmatrix(3,1)=q
               lmatrix(3,3)=z
               call multiply_local_matrix(lmatrix,ematrix)
c     r1-1
               do i=1,4
                  do j=1,4
                     lmatrix(j,i)=0.d0
                  enddo
               enddo
               do j=1,4
                  lmatrix(j,j)=1.d0
               enddo
               lmatrix(1,1)=x/q
               lmatrix(1,2)=y/q
               lmatrix(2,1)=-y/q
               lmatrix(2,2)=x/q
               call multiply_local_matrix(lmatrix,ematrix)
            endif
         endif

         exfrom=exto
         eyfrom=eyto
         extto=exto
         eytto=eyto

      endif

      return
      end


      subroutine fsppm
      implicit double precision (a-h,o-z)
#include "action.commonblock"
      character*80 filename
      integer flen
      call tempfilename('ymol','.ppm',filename,flen)
c     write(*,*) 'returned filelen:',flen
      call fpstr(filename(1:flen))
      call wppm
      return
      end
      
      subroutine pact(framebuffer,zbuffer,xs,ys,ianyaction)
      implicit double precision (a-h,o-z)
      integer framebuffer,zbuffer,xsize,ysize,xs,ys,ianyaction
      dimension framebuffer(*),zbuffer(*)
#include "action.commonblock"
#include "status.commonblock"
#include "externmatrix.commonblock"
#include "e2matrix.commonblock"
c     Keep two matrices. One for rotation and one for translation.
      double precision local_r_matrix(4,4)
      double precision local_t_matrix(4,4)
      double precision my_matrix(4,4)
      call dsget(i)
      if (i.eq.DRAW_STYLE_3D_SPHERES) then
        call gtdsty(i)
        if (i.eq.2) then
          call povchk(i)
          if (i.eq.1) return
        endif
      endif
      call vmsncd
      xsize=xs*oversample
      ysize=ys*oversample
      do i=1,4
        do j=1,4
          local_r_matrix(j,i)=0.d0
          local_t_matrix(j,i)=0.d0
        enddo
      enddo
      do i=1,4
        local_r_matrix(i,i)=1.d0
        local_t_matrix(i,i)=1.d0
      enddo
c     if (anything.ne.0) then
c     write(*,*) 'anything:',anything
c     endif
      if (anything.eq.0) then
        world_update=0
        force_update=0
      endif
      iglobaltransform=0
      ianyaction=0
      if (world_update.ne.0) then
        ianyaction=1
        call build_world(frame,ihardupdate)
        world_update=0
        ihardupdate=1
        iglobaltransform=1
c     write(*,*) 'world update...'
      endif
      if (force_update.ne.0) then
        ianyaction=1
        force_update=0
      endif

      if (anything.ne.0) then
        if (playmovie.ne.0) then
          call get_nframes(nframes)
          xoldframe=frame
          frame=frame+playmovie
          ilooped=0
          if (frame.gt.nframes) then
            frame=1
            ilooped=1
          endif
          if (frame.lt.1) then
            frame=nframes
            ilooped=1
          endif
          if ((loopmovie.eq.0).and.(ilooped.eq.1)) then
            frame=xoldframe
          else
            ianyaction=1
            iglobaltransform=1
            call build_world(frame,1)
          endif
        endif
        
        if (rotate_x.ne.0) then
          ianyaction=1
          angle=angle_inc*rotate_x
          my_matrix(1,1)=1.d0
          my_matrix(1,2)=0.d0
          my_matrix(1,3)=0.d0
          my_matrix(1,4)=0.d0

          my_matrix(2,1)=0.d0
          my_matrix(2,2)=cos(angle)
          my_matrix(2,3)=sin(angle)
          my_matrix(2,4)=0.d0

          my_matrix(3,1)=0.d0
          my_matrix(3,2)=-sin(angle)
          my_matrix(3,3)=cos(angle)
          my_matrix(3,4)=0.d0

          my_matrix(4,1)=0.d0
          my_matrix(4,2)=0.d0
          my_matrix(4,3)=0.d0
          my_matrix(4,4)=1.d0
c     transform local transformation matrix...
          call multiply_local_matrix(my_matrix,local_r_matrix)
        endif
        if (rotate_y.ne.0) then
          ianyaction=1
          angle=angle_inc*rotate_y
          my_matrix(1,1)=cos(angle)
          my_matrix(1,2)=0.d0
          my_matrix(1,3)=-sin(angle)
          my_matrix(1,4)=0.d0

          my_matrix(2,1)=0.d0
          my_matrix(2,2)=1.d0
          my_matrix(2,3)=0.d0
          my_matrix(2,4)=0.d0

          my_matrix(3,1)=sin(angle)
          my_matrix(3,2)=0.d0
          my_matrix(3,3)=cos(angle)
          my_matrix(3,4)=0.d0

          my_matrix(4,1)=0.d0
          my_matrix(4,2)=0.d0
          my_matrix(4,3)=0.d0
          my_matrix(4,4)=1.d0
c     transform local transformation matrix...
          call multiply_local_matrix(my_matrix,local_r_matrix)
        endif
        if (rotate_z.ne.0) then
          ianyaction=1
          angle=angle_inc*rotate_z
          my_matrix(1,1)=cos(angle)
          my_matrix(1,2)=sin(angle)
          my_matrix(1,3)=0.d0
          my_matrix(1,4)=0.d0

          my_matrix(2,1)=-sin(angle)
          my_matrix(2,2)=cos(angle)
          my_matrix(2,3)=0.d0
          my_matrix(2,4)=0.d0

          my_matrix(3,1)=0.d0
          my_matrix(3,2)=0.d0
          my_matrix(3,3)=1.d0
          my_matrix(3,4)=0.d0

          my_matrix(4,1)=0.d0
          my_matrix(4,2)=0.d0
          my_matrix(4,3)=0.d0
          my_matrix(4,4)=1.d0
c     transform local transformation matrix...
          call multiply_local_matrix(my_matrix,local_r_matrix)
        endif
        
        if (zoom_inout.ne.0) then
          ianyaction=1
          my_matrix(1,1)=1.d0
          my_matrix(1,2)=0.d0
          my_matrix(1,3)=0.d0
          my_matrix(1,4)=0.d0
          
          my_matrix(2,1)=0.d0
          my_matrix(2,2)=1.d0
          my_matrix(2,3)=0.d0
          my_matrix(2,4)=0.d0
          
          my_matrix(3,1)=0.d0
          my_matrix(3,2)=0.d0
          my_matrix(3,3)=1.d0
          my_matrix(3,4)=0.d0
          
          my_matrix(4,1)=0.d0
          my_matrix(4,2)=0.d0
          my_matrix(4,3)=zoomfac*dble(zoom_inout)
          my_matrix(4,4)=1.d0

c     transform local transformation matrix...
          call multiply_local_matrix(my_matrix,local_t_matrix)
c     call write_matrix(local_matrix)
        endif
        if (itmatrix.ne.0) then
          ianyaction=1
          call ttrans(xsize,ysize)
          call multiply_local_matrix(tmatrix,local_t_matrix)
          itmatrix=0
        endif
        if (iematrix.ne.0) then
          ianyaction=1
          call erotate(xsize,ysize)
          call multiply_local_matrix(ematrix,local_r_matrix)
          iematrix=0
        endif
        if (ie2matrix.ne.0) then
          ianyaction=1
          call multiply_local_matrix(e2matrix,local_r_matrix)
          ie2matrix=0
        endif
      endif
      if (ianyaction.ne.0) then
        if (anything.ne.0) then
          call multiply_global_r_matrix(local_r_matrix)
          call multiply_global_t_matrix(local_t_matrix)
        endif
c     If there is a new frame just read in we multiply with
c     the global transformation matrix.
c     If the frame is the old one we will just multiply with
c     the local matrix since the older operations are already
c     done on this molbuffer
        if (anything.ne.0) then
          if (iglobaltransform.ne.0) then
c     global:
            call transform_molbuffer 
          else
c     local:
c     Don't perform translations until world is drawn
#if 0
      do i=1,4
        do j=1,4
          my_matrix(j,i)=local_r_matrix(j,i)
        enddo
      enddo
      call multiply_local_matrix(
     x     local_t_matrix,my_matrix)
      call multiply_molbuffer(my_matrix)
#endif
      call multiply_molbuffer(local_r_matrix)
      endif
      endif
      if (anything.ne.0) then
        call supd(framebuffer,zbuffer,xsize,ysize)
      endif
      if (dump_ppm.ne.0) then
        call fsppm
      endif
      endif
      if (continous.eq.0) then
        rotate_x=0
        rotate_y=0
        rotate_z=0
        zoom_inout=0
      endif
      if (continous_play.eq.0) then
        playmovie=0
      endif

c     if (ianyaction.eq.0) then
c     write(*,*) 'No action...'
c     endif
      return
      end

      subroutine supd(framebuffer,zbuffer,xsize,ysize)
      implicit double precision (a-h,o-z)
#include "stereo.commonblock"
      integer framebuffer,zbuffer,xsize,ysize,xsizecp
      dimension framebuffer(*),zbuffer(*)
      xsizecp=xsize
      call dsget(idrawstyle)
      if (idrawstyle.eq.DRAW_STYLE_3D_SPHERES) then
         call draw_molbuffer(framebuffer,zbuffer,xsizecp,ysize)
         call gtdsty(i)
         if (i.eq.2) then
            call pgbset
         else
            call sflush
            call bswap
         endif
      else /* 2D SPHERES or WIREFRAME */
         call gbkgrv(ir,ig,ib)
         call frect(0,0,xsizecp,ysize,ir,ig,ib)
         if (nstereo.eq.1) then
            call steclr(ir,ig,ib)
         endif
         call draw_molbuffer(framebuffer,zbuffer,xsizecp,ysize)
         call bswap
         call xflush
      endif
      call xsync
      return
      end


      subroutine reinif(xs,ys)
      implicit double precision (a-h,o-z)
      integer xs,ys,xsize,ysize
      integer oversample
      call govsmp(oversample)
      xsize=xs*oversample
      ysize=ys*oversample
c      write (*,*) 'reinif calling def_res:',xsize,ysize
      call def_res(xsize,ysize)
      call redef_unit
      call fupd
      return
      end


      subroutine initf(framebuffer,zbuffer,xsize,ysize)
      implicit double precision (a-h,o-z)
      integer framebuffer,zbuffer,xsize,ysize
      dimension framebuffer(*),zbuffer(*)
#include "status.commonblock"
#include "psflag.commonblock"
      character*120 tempdirname
      integer xpoints(10),ypoints(10)

      iprintps=0
      call init_phongtables     
      call read_tables
      call inittempdir
c      write (*,*) 'initf calling def_res:',xsize,ysize
      call def_res(xsize,ysize)
c      call read_molbuffer
      call init_atomlabels


c     test import:
c      call fiflag(1,1.d0)
c      call fiflag(2,0.3d0)
c      call fiflag(3,0.3d0)
c      call fimp('c60.mol')

c      call gettempdir(tempdirname)
c      iz=index(tempdirname,' ')-1
c      tempdirname=tempdirname(1:iz)//'import.tmp'
c      call fload(tempdirname(1:iz+10))



c     test save...
c      call fsave('blaj.ymol')

c     test open imported file
c      call fload('blaj.ymol')

c      call build_world(1)


c      call rotate_molbuffer(0.d0,0.d0,0.d0)
c      call def_bound_molbuf
      call init_action
      call init_status
      call init_t_matrix


      call dsset(DRAW_STYLE_2D_CIRCLES)
c      call dsset(DRAW_STYLE_WIREFRAME)

c      call supd(framebuffer,zbuffer,xsize,ysize)

c     place beautiful background in window
      call bgset

c     test play:
c      call mplay(1,1)
      


      return
      end


      subroutine deinif
      implicit double precision (a-h,o-z)
      call removetempdir
      return
      end
