/* This is register_update.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>

typedef struct register_func
{
  void (*reg_fn)();
  struct register_func *next;
} register_func;

static register_func *register_func_hook=NULL;

void register_update_function(void (*reg_fn)())
{
  register_func *new=malloc(sizeof(register_func));
  new->reg_fn=reg_fn;
  new->next=register_func_hook;
  register_func_hook=new;
}

void execute_update_functions()
{
  register_func *ptr=register_func_hook;

  while (ptr!=NULL)
    {
      ptr->reg_fn();
      ptr=ptr->next;
    }
}

#if defined(USCORE2)
void execute_update_functions__()
#else
void execute_update_functions_()
#endif
{
  execute_update_functions();
}
