/*
  This is ppm.c
  Copyright (C) 1997-1998 Daniel Spaangberg
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include "ppm.h"


static char rcsid[]="$Id: ppm.c 44 2006-03-06 19:22:18Z daniels $";
/* silly ppm read and write. requires format to be raw and in 24 bit format
   P6
   # comment line
   x y
   255
   raw data...

   (I have to check the true ppm file format)
 */

unsigned int *read_ppm(char *filename,int *ppm_xsize,int *ppm_ysize)
{
  int xwrite,ywrite;
  FILE *ppmfile;
  ppmfile= fopen(filename,"r");
  if (ppmfile!=NULL)
    {
      char ch;
      unsigned int *image_ptr,*myptr;
      char header[1000];
      int hptr=0;
      fscanf(ppmfile,"%s",header);
      if (strcmp(header,"P6")!=0)
	{
	  fclose(ppmfile);
	  return 0;
	}
      while (fgetc(ppmfile)!='\n');
      while ((ch=fgetc(ppmfile))=='#')
	while (fgetc(ppmfile)!='\n');
      header[hptr++]=ch;
      while ((header[hptr++]=fgetc(ppmfile))!='\n');
      header[hptr]=0;
      /*  printf("Header: '%s'\n",header); */
      sscanf(header,"%d%d",ppm_xsize,ppm_ysize);
      while (fgetc(ppmfile)!='\n');
      /* printf("ppm xsize=%d, ysize=%d\n",*ppm_xsize,*ppm_ysize); */
      image_ptr=malloc(sizeof( unsigned int)*(*ppm_xsize * *ppm_ysize));
      myptr=image_ptr;
      for (ywrite=0; ywrite<*ppm_ysize; ywrite++)
	for (xwrite=0; xwrite<*ppm_xsize; xwrite++)
	  {
	    unsigned char byte[3];
	    unsigned int rgb[3];
	    size_t s=fread((char*) &byte,sizeof(char),3,ppmfile);
	    if (s!=3)
	      {
		fclose(ppmfile);
		return(image_ptr);
	      }
	    rgb[0]=byte[0]; 
	    rgb[1]=byte[1];
 	    rgb[2]=byte[2]; 
	    *myptr++=rgb[0]|(rgb[1]<<8)|(rgb[2]<<16);
	  }
      fclose(ppmfile);
      return(image_ptr);
    }
  else
      return(0);
}

void write_ppm(char *filename,int ppm_xsize,int ppm_ysize,unsigned int *buffer)
{
  FILE *outfile;
  outfile=fopen(filename,"w");
  if (outfile!=NULL)
    {
      int ywrite,xwrite;
      char header[100];
      unsigned int *myptr=buffer;
      sprintf(header,"P6\n#write_ppm by Daniel Spaangberg\n%d %d 255\n",
	      ppm_xsize,ppm_ysize);
      fwrite((char*) &header,strlen(header),1,outfile);
      for (ywrite=0; ywrite<ppm_ysize; ywrite++)
	for (xwrite=0; xwrite<ppm_xsize; xwrite++)
	  {
	    char byte[3];
	    byte[0]=(*myptr) & 0xFF;
	    byte[1]=((*myptr) & 0xFF00)>>8;
	    byte[2]=((*myptr++) & 0xFF0000)>>16;
	    fwrite((char*) &byte,sizeof(char),3,outfile);
	  }
      fclose(outfile);
    }
  else
    {
	printf("Couldn't open file: %s\n",filename);
    }
}

