/* This is povraybg.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <Xco.h>
#include "xinterface.h"
#include "ppm.h"
#include "vmconsole.h"
#include "render_params.h"
#include "ccinterface.h"

static int povray_active[2]={0,0};
static pid_t mypid[2];
static time_t mytime;

void povchk_(int *i)
{
  /* Here we may update info in buffer from povray .ppm file */
  int status;
  int istereo,nstereo;
  time_t t2=time(NULL);
  int anyactive=0;
  int updatedany=0;
  steqry_(&nstereo);
  for (istereo=0; istereo<=nstereo; istereo++)
    {
      if (povray_active[istereo]) 
	{
	  anyactive=1;
	  if (waitpid(mypid[istereo],&status,WNOHANG))
	    povray_active[istereo]=0;
	  if ((!povray_active[istereo]) || ((t2-mytime)>=4))
	    {
	      char fname[100];
	      /* Read the ppm file... */
	      int x,y,x2,y2,s;
	      uint32 *ptr,*buf;
	      sprintf(fname,"povraymode%d.ppm",istereo);
	      ptr=read_ppm(fname,&x,&y);
#if 0
	      printf("ppm size is %dx%d\n",x,y);
#endif
	      buf=get_conv_buffer_ptr();
	      get_buffer_size(&x2,&y2);
#if 0
	      printf("buffer size is %dx%d\n",x2,y2);
#endif
	      govsmp_(&s);
	      x2/=s;
	      y2/=s;
	      /* printf("Reading pov: %d,%d\n",x2,y2); */
	      if (nstereo)
		{
		  int xlength=x;
		  if ((xlength*2<=x2) && (y<=y2))
		  {
		    int yline;
		    for (yline=0; yline<y; yline++)
		      memcpy(buf+yline*x2+xlength*istereo,
			     ptr+yline*x,xlength*sizeof(uint32));
		  }
		}
	      else
		{
		  if (x>x2) x=x2;
		  if (y>y2) y=y2;
		  memcpy(buf,ptr,x*y*sizeof(uint32));
		}
	      free(ptr);
	      flush_image();
	      swap_pixmaps();
	      XSync(XcoGetDisplay(),False);
	      updatedany=1;
	    }
	}
    }
  if (!anyactive)
    vmconsole_interrupt(0);
  if (updatedany)
    mytime=t2;

#if 0
  if (povray_active)
    printf("Povray is active\n");
  else
    printf("Povray is not active\n");
#endif
  *i=anyactive;
}

void pgbset_()
{
  int istereo,nstereo;
  steqry_(&nstereo);
  for (istereo=0; istereo<=nstereo; istereo++)
    {
      povray_active[istereo]=1;
      if (!(mypid[istereo]=fork()))
	{
	  int x,y,s;
	  int ostest=get_global_oversampling();
	  char cmd[1000];
	  get_buffer_size(&x,&y);
	  govsmp_(&s);
	  x/=s;
	  y/=s;
	  if (nstereo)
	    x/=2;
	  /* printf("Rendering pov: %d,%d\n",x,y); */
	  if (ostest>2)
	    sprintf(cmd,"povray +a +FP +W%d +H%d +Ipovraymode%d.pov",x,y,istereo);
	  else
	    sprintf(cmd,"povray +FP +W%d +H%d +Ipovraymode%d.pov",x,y,istereo);
	  system(cmd);
	  exit(0);
	}
    }
  mytime=time(NULL);
}
