/* This is postscript.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <Xco.h>
#include <y4vm.h>
#include "ccinterface.h"
#include "fstring.h"
#include "xinterface.h"
#include "userinterface.h"

#define IN72TOMM (25.4/72.)

static FILE *psfile;
static int xsize,ysize;

void ymol_save_ps_image(char *myname)
{
  int oversample;
  psfile=fopen(myname,"w");
  get_buffer_size(&xsize,&ysize);
  govsmp_(&oversample);
  xsize/=oversample;
  ysize/=oversample;
  pssave_(&xsize,&ysize);
}

void pshead_()
{
  double scalex,scaley,transx,transy;
  double paperwidth=vm_get_variable_value("paperwidth",0);
  double paperheight=vm_get_variable_value("paperheight",0);
  double papermargin=vm_get_variable_value("papermargin",0);
  double bbx1,bby1,bbx2,bby2;
  int paperportraitflag=(int)vm_get_variable_value("paperportraitflag",0);
#if 0
  printf("I have a papersize of %6.2f mm x %6.2f mm with a margin of %6.2f mm\n",
	 paperwidth,paperheight,papermargin);
  if (paperportraitflag)
    printf("I will print portrait\n");
  else
    printf("I will print landscape\n");
#endif
  transx=paperwidth*0.5;
  transy=paperheight*0.5;
  transx/=IN72TOMM;
  transy/=IN72TOMM;
  paperwidth-=papermargin*2;
  paperheight-=papermargin*2;
  bbx1=papermargin/IN72TOMM;
  bby1=papermargin/IN72TOMM;
  bbx2=(paperwidth+papermargin)/IN72TOMM;
  bby2=(paperheight+papermargin)/IN72TOMM;
  if (!paperportraitflag)
    {
      /* Landscape */
      double x=paperwidth;
      paperwidth=paperheight;
      paperheight=x;
    }
  scalex=paperwidth/((double)xsize*IN72TOMM);
  scaley=paperheight/((double)ysize*IN72TOMM);
  if (scalex>scaley)
    {
      if (!paperportraitflag)
	{
	  bby1+=(0.5*paperwidth*(1.-scaley/scalex))/IN72TOMM;
	  bby2-=(0.5*paperwidth*(1.-scaley/scalex))/IN72TOMM;
	}
      else
	{
	  bbx1+=(0.5*paperwidth*(1.-scaley/scalex))/IN72TOMM;
	  bbx2-=(0.5*paperwidth*(1.-scaley/scalex))/IN72TOMM;
	}
      scalex=scaley;
    }
  else
    {
      if (!paperportraitflag)
	{
	  bbx1+=(0.5*paperheight*(1.-scalex/scaley))/IN72TOMM;
	  bbx2-=(0.5*paperheight*(1.-scalex/scaley))/IN72TOMM;
	}
      else
	{
	  bby1+=(0.5*paperheight*(1.-scalex/scaley))/IN72TOMM;
	  bby2-=(0.5*paperheight*(1.-scalex/scaley))/IN72TOMM;
	}
      scaley=scalex;
    }
  
  fprintf(psfile,"%%!PS-Adobe-3.0 EPSF-3.0\n"
	  "%%%%DocumentFonts: Helvetica\n"
	  "%%%%Title: %s\n"
	  "%%%%Creator: Ymol\n"
	  "%%%%Pages: 1\n"
	  "%%%%BoundingBox: %5i %5i %5i %5i\n"
	  "%%%%EndComments\n"
	  ,get_current_filename(),(int)floor(bbx1),(int)floor(bby1),(int)ceil(bbx2),(int)ceil(bby2));


  fprintf(psfile,
	  /* A line */
	  "/yl { setrgbcolor setlinewidth newpath moveto lineto stroke } def\n"
	  /* A circle */
	  "/yc { setrgbcolor setlinewidth newpath 0 360 arc stroke } def\n"
	  /* A filled circle */
	  "/yfc { setrgbcolor newpath 0 360 arc fill } def\n"
	  /* A polygon with four corners */
	  "/yp { setrgbcolor setlinewidth dup 9 1 roll exch dup 10 1 roll exch newpath moveto lineto lineto lineto lineto closepath stroke } def\n"
	  /* A filled polygon with four corners */
	  "/yfp { setrgbcolor dup 9 1 roll exch dup 10 1 roll exch newpath moveto lineto lineto lineto lineto closepath fill } def\n"
	  /* A polygon with three corners */
	  "/ypt { setrgbcolor setlinewidth dup 7 1 roll exch dup 8 1 roll exch newpath moveto lineto lineto lineto closepath stroke } def\n"
	  /* A filled polygon with three corners */
	  "/yfpt { setrgbcolor dup 7 1 roll exch dup 8 1 roll exch newpath moveto lineto lineto lineto closepath fill } def\n"
	  /* The default font */
	  "/dfnt /Helvetica findfont def\n"
	  /* A colored centered text string */
	  "/ycts { setrgbcolor dup 5 1 roll dfnt exch scalefont setfont moveto dup stringwidth pop 3 -1 roll -0.5 mul exch -0.5 mul exch rmoveto show } def\n"
	  /* A colored centered image text string */
	  "/ycits { setrgbcolor 7 3 roll dup 5 1 roll dfnt exch scalefont setfont newpath moveto dup stringwidth pop 3 -1 roll dup 3 -1 roll dup 4 1 roll -0.5 mul exch -0.5 mul rmoveto gsave dup 0 exch rlineto exch dup 0 rlineto exch 0 exch neg rlineto neg 0 rlineto closepath fill grestore 4 1 roll setrgbcolor show } def\n"
	  );
  fprintf(psfile,
	  "%%%%EndProlog\n"
	  "%%%%Page: 1 1\n"
	  );

  fprintf(psfile,"%6.2f %6.2f translate\n",transx,transy);
  fprintf(psfile,"%6.2f %6.2f scale\n",scalex,scaley);
  if (!paperportraitflag)
    fprintf(psfile,"90 rotate\n");
  fprintf(psfile,"%6.2f %6.2f translate\n",-xsize*0.5,-ysize*0.5);
  fprintf(psfile,"gsave\n");
  fprintf(psfile,"newpath %6.2f %6.2f moveto %6.2f %6.2f lineto %6.2f %6.2f lineto %6.2f %6.2f lineto %6.2f %6.2f lineto closepath clip\n",0.,0.,(double)xsize,0.,(double)xsize,(double)ysize,0.,(double)ysize,0.,0.);
}

void psgsav_()
{
  fprintf(psfile,"gsave\n");
}

void psgres_()
{
  fprintf(psfile,"grestore\n");
}

void psclip_(int *xstart, int *xend, int *ysize)
{
  fprintf(psfile,"newpath %6.2f %6.2f moveto %6.2f %6.2f lineto %6.2f %6.2f lineto %6.2f %6.2f lineto %6.2f %6.2f lineto closepath clip\n",(double)*xstart,0.,(double)*xend,0.,(double)*xend,(double)*ysize,(double)*xstart,(double)*ysize,(double)*xstart,0.);
}

void psfoot_()
{
  fprintf(psfile,"grestore\nshowpage\n");
  fprintf(psfile,"%%%%Trailer\n");
  fclose(psfile);
}

void psyl_(double *x1,double *y1,double *x2,double *y2,double *w,int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f yl\n",*x1,ysize-*y1,*x2,ysize-*y2,*w,*r/255.0,*g/255.0,*b/255.0);
}

void psyc_(double *x,double *y,double *rad,double *w,int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f yc\n",*x,ysize-*y,*rad,*w,*r/255.0,*g/255.0,*b/255.0);
}

void psyfc_(double *x,double *y,double *rad,int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %4.2f %4.2f %4.2f yfc\n",*x,ysize-*y,*rad,*r/255.0,*g/255.0,*b/255.0);
}

void psyp_(double *x1,double *y1,
	     double *x2,double *y2,
	     double *x3,double *y3,
	     double *x4,double *y4,
	     double *w,int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f yp\n",*x1,ysize-*y1,*x2,ysize-*y2,*x3,ysize-*y3,*x4,ysize-*y4,*w,*r/255.0,*g/255.0,*b/255.0);
}

void psyfp_(double *x1,double *y1,
	     double *x2,double *y2,
	     double *x3,double *y3,
	     double *x4,double *y4,
	     int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f yfp\n",*x1,ysize-*y1,*x2,ysize-*y2,*x3,ysize-*y3,*x4,ysize-*y4,*r/255.0,*g/255.0,*b/255.0);
}

void psypt_(double *x1,double *y1,
	     double *x2,double *y2,
	     double *x3,double *y3,
	     double *w,int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f ypt\n",*x1,ysize-*y1,*x2,ysize-*y2,*x3,ysize-*y3,*w,*r/255.0,*g/255.0,*b/255.0);
}

void psyfpt_(double *x1,double *y1,
	     double *x2,double *y2,
	     double *x3,double *y3,
	     int *r,int *g,int *b)
{
  fprintf(psfile,"%6.2f %6.2f %6.2f %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f yfpt\n",*x1,ysize-*y1,*x2,ysize-*y2,*x3,ysize-*y3,*r/255.0,*g/255.0,*b/255.0);
}

void psycts_(double *x,double *y,double *size,char *str,int *r,int *g,int *b,int len)
{
  char *s=malloc((len+1));
  memcpy(s,str,len);
  fscs_(s,len);
  fprintf(psfile,"(%s) %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f ycts\n",s,*x,ysize-*y,*size,*r/255.0,*g/255.0,*b/255.0);
  free(s);
}

void psyits_(double *x,double *y,double *size,char *str,int *r,int *g,int *b,int *rb,int *gb,int *bb,int len)
{
  char *s=malloc((len+1));
  memcpy(s,str,len);
  fscs_(s,len);
  fprintf(psfile,"(%s) %6.2f %6.2f %6.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f ycits\n",s,*x,ysize-*y,*size,*r/255.0,*g/255.0,*b/255.0,*rb/255.0,*gb/255.0,*bb/255.0);
  free(s);
}


void psimg_()
{
  int oversample,myx,myy;
  uint32 *buffer=get_conv_buffer_ptr();
  int iwrite=0;
  int x,y;
  get_displayed_image();
#if 0
  govsmp_(&oversample);
  myx=xsize/oversample;
  myy=ysize/oversample;
#else
  myx=xsize;
  myy=ysize;
#endif
  fprintf(psfile,
	  "gsave\n"
	  "%5i %5i scale\n",xsize,ysize);
  fprintf(psfile,
	  "/rstr %5i string def\n"
	  "/gstr %5i string def\n"
	  "/bstr %5i string def\n"
	  "%5i %5i 8\n"
	  "[%5i 0 0 %5i 0 %5i]\n"
	  "{ currentfile rstr readhexstring pop }\n"
	  "{ currentfile gstr readhexstring pop }\n"
	  "{ currentfile bstr readhexstring pop }\n"
	  "true 3 colorimage\n",
	  myx,myx,myx,myx,myy,myx,-myy,myy);
  for (y=0; y<myy; y++)
    {
      int rgb;
      for (rgb=0; rgb<=2; rgb++)
	for (x=0; x<myx; x++)
	  {
	    uint32 pixel=(buffer[x]>>(8*rgb))&0xff;
	    if (iwrite>30)
	      {
		fprintf(psfile,"\n");
		iwrite=0;
	      }
	    if (pixel>0xf)
	      fprintf(psfile,"%2x",pixel);
	    else
	      fprintf(psfile,"0%1x",pixel);
	    iwrite++;
	  }
      buffer+=myx;
    }

  fprintf(psfile,"grestore\n");
}
