/* This is pcx.c
    Copyright (C) 1994-1998 Daniel Spaangberg

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "pcx.h"

static char rcsid[]="$Id: pcx.c 2 2001-10-30 14:54:51Z daniels $";

char *read_pcx24(char *filename,int *pcx_xsize,int *pcx_ysize)
{
  FILE *pcxfile; 
  pcxheader myheader;
  pcxfile= fopen(filename,"r");
  if (pcxfile!=NULL)
    {
      fread( (char*) &myheader,sizeof(pcxheader),1,pcxfile );
      
      if (((myheader.manufacturer==10)) && ((myheader.bits_per_pixel)==8) &&
	  ((myheader.planes==3)))
	
	{
	  int x,y;
	  char *pcxbuffer;
	  char *pcxpointer;
	  char *pcxline;
  	  int xsize,ysize,bpl;
      	  bpl=myheader.bytes_per_line;
	  
	  xsize=(myheader.xmax-myheader.xmin)+1;
	  ysize=(myheader.ymax-myheader.ymin)+1;
	  pcxbuffer=malloc(xsize*ysize*3);
	  *pcx_xsize=xsize;
	  *pcx_ysize=ysize;
          pcxpointer=pcxbuffer;
          pcxline=malloc(bpl*3);

	  for (y=0; y<ysize; y++)
	    {
	      int plane;
	      int plane_r,plane_g,plane_b;
	      for (plane=0; plane<=2; plane++)
		{
		  int plane_offset=plane*bpl;
		  int read_bytes=0;
		  char byte;
		  while(read_bytes<bpl)
		    {
		      fread((char*) &byte,sizeof(char),1,pcxfile);
		      if ((byte & 0xC0)==0xC0) /* compressed */
			{
			  int i;
			  int decompress_bytes=byte & 0x3F;
			  fread((char*) &byte,sizeof(char),1,pcxfile);
			  for (i=1; i<=decompress_bytes; i++)
			    {
			      pcxline[plane_offset+read_bytes++]=byte;
			    }
			}
		      else
			{
			  pcxline[plane_offset+read_bytes++]=byte;
			}
		    }
		}
	      plane_r=0;
	      plane_g=bpl;
	      plane_b=bpl<<1;
	      for (x=0; x<xsize; x++)
		{
		  *pcxpointer++=pcxline[plane_r+x];
		  *pcxpointer++=pcxline[plane_g+x];
		  *pcxpointer++=pcxline[plane_b+x];
		}
	    }
	  free(pcxline);
	  fclose(pcxfile);
	  return(pcxbuffer);
	}
      else
	{
	  fclose(pcxfile);
	  return(0);
	}
    }
  else
    {
      fclose(pcxfile);
      return(0);
    }
}


void write_pcx24(char *filename,int pcx_xsize,int pcx_ysize,char *buffer)
{
  FILE *outfile=outfile=fopen(filename,"w");
  /* write header */
  pcxheader myheader;
  char storebyte=0;
  char new_byte,the_byte;
  int ywrite,xwrite,plane;
  myheader.manufacturer=10;
  myheader.encoding=1;
  myheader.version=5;
  myheader.bits_per_pixel=8;
  myheader.xmin=0;
  myheader.ymin=0;
  myheader.xmax=pcx_xsize-1;
  myheader.ymax=pcx_ysize-1;
  myheader.hres=pcx_xsize;
  myheader.vres=pcx_ysize;
  myheader.reserved=0;
  myheader.planes=3;
  myheader.bytes_per_line=pcx_xsize;
  myheader.palette_type=1;
  strcpy(myheader.filler,"                                                         ");

  fwrite((char*) &myheader,sizeof(myheader),1,outfile);
  
  for (ywrite=0; ywrite<pcx_ysize; ywrite++)
    {
      for (plane=0; plane<=2; plane++)
	{
	  int z_index=3*pcx_xsize*ywrite;
	  for (xwrite=0; xwrite<pcx_xsize; xwrite++)
	    {
	      new_byte=buffer[z_index+xwrite*3+plane];
	      if (storebyte==0)
		{
		  the_byte=new_byte;
		  storebyte=1;
		}
	      else
		{
		  if ((storebyte<63) && (new_byte==the_byte))
		    {
		      storebyte++;
		    }
		  else
		    {
		      if (storebyte>1)
			{
			  storebyte|=0xC0;
			  fwrite((char*) &storebyte,sizeof(char),1,outfile);
			  fwrite((char*) &the_byte,sizeof(char),1,outfile);
			}
		      else
			{
			  if ((the_byte & 0xC0)==0xC0)
			    {
			      char sbyte=0xC1;
			      fwrite((char*) &sbyte,sizeof(char),1,outfile);
			    }
			  fwrite((char*) &the_byte,sizeof(char),1,outfile);
			}
		      storebyte=1;
		      the_byte=new_byte;
		    }
		}
	    }
	  if (storebyte>1)
	    {
	      storebyte|=0xC0;
	      fwrite((char*) &storebyte,sizeof(char),1,outfile);
	      fwrite((char*) &the_byte,sizeof(char),1,outfile);
	    }
	  else
	    {
	      if ((the_byte & 0xC0)==0xC0)
		{
		  char sbyte=0xC1;
		  fwrite((char*) &sbyte,sizeof(char),1,outfile);
		}
	      fwrite((char*) &the_byte,sizeof(char),1,outfile);
	    }
	  storebyte=0;
	}
    }
}

char *resize24(int from_x,int from_y,char *from_buffer,int to_x,int to_y)
{
  char *new_buffer=(char*) malloc(to_x*to_y*3);
  char *new_ptr=new_buffer;
  int y,x;
  for (y=0; y<to_y; y++)
    {
      int y_pos=(y*from_y)/to_y;
      char *y_pos_from=from_buffer+3*y_pos*from_x;
      for (x=0; x<to_x; x++)
	{
	  int x_pos=(x*from_x)/to_x;
	  char *x_pos_from=y_pos_from+x_pos*3;
	  *new_ptr++=*x_pos_from++;
	  *new_ptr++=*x_pos_from++;
	  *new_ptr++=*x_pos_from;
	}
    }
  return(new_buffer);
}

