      /* This is modify.F
      A part of the Ymol program
      Copyright (C) 1997-2002 Daniel Spangberg
      */

#include "maxs.h"
#include "tempfileformat.h"
#include "defaults.h"

#define TEMPFILE1 12
#define TEMPFILE2 13

#define EXPORTFILE 14

c     Export selected atoms...
      subroutine esela(iframe,iframe2,delatomid,ndelatoms,filename)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer delatomid(*)
      integer atoms,bonds
      integer ip(10)
      character*(*) filename
      character*120 tempfilename1
      character*120 tempfilename2
      character*120 tempdirname
      character*FMAXCHARSPERLABEL labeltext
      character*FMAXCHARSINFRAMETEXT ftext

      iflen=LEN(filename)
      open(unit=EXPORTFILE,file=filename(1:iflen),
     x     status='unknown',
     x     form='formatted')
      

      write (EXPORTFILE,*) iframe2-iframe+1

      do ifi=iframe,iframe2
         call get_atoms(ifi,natoms)
         nframeatoms=0
         do iatom=1,natoms
            call get_atomid(ifi,iatom-1,id)
            do idel=1,ndelatoms
               if (id.eq.delatomid(idel)) then
                  nframeatoms=nframeatoms+1
               endif
            enddo
         enddo
         write (EXPORTFILE,*) nframeatoms
         do iatom=1,natoms
            call get_atomid(ifi,iatom-1,id)
            do idel=1,ndelatoms
               if (id.eq.delatomid(idel)) then
                  call get_atomnr(ifi,iatom-1,inr)
                  call get_atomxyz(ifi,iatom-1,x,y,z)
                  write(EXPORTFILE,*) id,inr,x,y,z
               endif
            enddo
         enddo
      enddo
      close(EXPORTFILE)
      
      return
      end


c     **************
c     All modifications must be followed by a world update
c     **************

c     Modify DELete Atom
      subroutine mdela(iframe,delatomid,ndelatoms)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer delatomid(*)
      integer atoms,bonds
      integer ip(10)
      character*120 tempfilename1
      character*120 tempfilename2
      character*120 tempdirname
      character*FMAXCHARSPERLABEL labeltext
      character*FMAXCHARSINFRAMETEXT ftext

      call get_nframes(nframes)
      nworld=nframes+1
c      write(*,*) 'Deleting atom in frame ',iframe

c      call gettempdir(tempdirname)
c      iz=index(tempdirname,' ')-1
c      tempdirname=tempdirname(1:iz)//'world'
c      call framefilename(tempdirname(1:iz+5),iframe,tempfilename1)
c      tempdirname=tempdirname(1:iz)//'newworld'
c      call framefilename(tempdirname(1:iz+8),iframe,tempfilename2)
c      open(unit=TEMPFILE1,file=tempfilename1,
c     x     form=TEMPFORMAT,status='unknown')
c      open(unit=TEMPFILE2,file=tempfilename2,
c     x     form=TEMPFORMAT,status='unknown')

      
      call get_atoms(iframe,natoms)
      call get_bonds(iframe,nbonds)
      ntriangles=0


      inumber_of_deleted_atoms=0
      do iatom=1,natoms
         call get_atomid(iframe,iatom-1,id)
         do idel=1,ndelatoms
            if (id.eq.delatomid(idel)) then
               inumber_of_deleted_atoms=inumber_of_deleted_atoms+1
            endif
         enddo
      enddo
      
      call initialize_temporary(natoms-inumber_of_deleted_atoms,
     x     ntriangles)
      
c      read(TEMPFILE1 TEMPRW) natoms
c      write(TEMPFILE2 TEMPRW) natoms-inumber_of_deleted_atoms
      nwritten_atoms=0
      do iatom=1,natoms
         iwrite_this_atom=1
         call get_atomid(iframe,iatom-1,id)
c         read(TEMPFILE1 TEMPRW) id,inr,x,y,z
         do idel=1,ndelatoms
            if (id.eq.delatomid(idel)) then
               iwrite_this_atom=0
            endif
         enddo
         if (iwrite_this_atom.eq.1) then
            call get_atomnr(iframe,iatom-1,inr)
            call get_atomxyz(iframe,iatom-1,x,y,z)
c            write(TEMPFILE2 TEMPRW) id,inr,x,y,z
            nwritten_atoms=nwritten_atoms+1
c            atomid(nwritten_atoms)=id
            call set_atomid(0,nwritten_atoms-1,id)
            call set_atomnr(0,nwritten_atoms-1,inr)
            call set_atomxyz(0,nwritten_atoms-1,x,y,z)
            call get_atomscalerad(iframe,iatom-1,xrad)
            call set_atomscalerad(0,nwritten_atoms-1,xrad)
            call get_defradweight(iframe,iatom-1,idef)
            call set_defradweight(0,nwritten_atoms-1,idef)
            if (idef.ne.1) then
               call get_atomrad(iframe,iatom-1,xrad)
               call set_atomrad(0,nwritten_atoms-1,xrad)
               call get_atomweight(iframe,iatom-1,xrad)
               call set_atomweight(0,nwritten_atoms-1,xrad)
            endif
            call get_defcol(iframe,iatom-1,idef)
            call set_defcol(0,nwritten_atoms-1,idef)
            if (idef.ne.1) then
               call get_atomrsv(iframe,iatom-1,xrad)
               call set_atomrsv(0,nwritten_atoms-1,xrad)
               call get_atomr(iframe,iatom-1,ir)
               call set_atomr(0,nwritten_atoms-1,ir)
               call get_atomg(iframe,iatom-1,ir)
               call set_atomg(0,nwritten_atoms-1,ir)
               call get_atomb(iframe,iatom-1,ir)
               call set_atomb(0,nwritten_atoms-1,ir)
               call get_atomn(iframe,iatom-1,ir)
               call set_atomn(0,nwritten_atoms-1,ir)
            endif
            call get_atomdrawstyle(iframe,iatom-1,itmp)
            call set_atomdrawstyle(0,nwritten_atoms-1,itmp)
            call get_deflabel(iframe,iatom-1,iatomlabel)
            call set_deflabel(0,nwritten_atoms-1,iatomlabel)
            if (iatomlabel.ne.0) then
               call get_atomlabel(iframe,iatom-1,labeltext)
               call set_atomlabel(0,nwritten_atoms-1,labeltext)
            else
               call set_atomlabel(0,nwritten_atoms-1," ")
            endif
            call get_atomhasmessage(iframe,iatom-1,itmp)
            call set_atomhasmessage(0,nwritten_atoms-1,itmp)
         endif
      enddo
      iwbond=0
      do ibond=1,nbonds
         iwrite_this_bond=1
c         read(TEMPFILE1 TEMPRW) idrawbond
c         read(TEMPFILE1 TEMPRW) ino1,ino2,id1,id2
         
         call get_bondp(iframe,ibond-1,ino1,ino2,id1,id2)
c     Delete this bond?
         do idel=1,ndelatoms
            if ((delatomid(idel).eq.id1).or.
     x           (delatomid(idel).eq.id2)) then
               iwrite_this_bond=0
            endif
         enddo
         if (iwrite_this_bond.eq.1) then
            call add_temporary_bond
            iwbond=iwbond+1
c     Ok, keep this bond. But we may have to reassign the numbers.
            do iatom=1,nwritten_atoms
               call get_atomid(0,iatom-1,icmp)
               if (icmp.eq.id1) ino1=iatom
               if (icmp.eq.id2) ino2=iatom
            enddo
            call get_drawbond(iframe,ibond-1,idrawbond)
            call set_drawbond(0,iwbond-1,idrawbond)
            call set_bondp(0,iwbond-1,ino1,ino2,id1,id2)
            call set_bond1(0,iwbond-1,ino1)
            call set_bond2(0,iwbond-1,ino2)
            call get_defbcol(iframe,ibond-1,idef)
            call set_defbcol(0,iwbond-1,idef)
            if (idef.ne.1) then
               call get_bondr1(iframe,ibond-1,ir)
               call set_bondr1(0,iwbond-1,ir)
               call get_bondg1(iframe,ibond-1,ir)
               call set_bondg1(0,iwbond-1,ir)
               call get_bondb1(iframe,ibond-1,ir)
               call set_bondb1(0,iwbond-1,ir)
               call get_bondn1(iframe,ibond-1,ir)
               call set_bondn1(0,iwbond-1,ir)
               call get_bondnslice(iframe,ibond-1,ir)
               call set_bondnslice(0,iwbond-1,ir)
               call get_bondrsv1(iframe,ibond-1,xr)
               call set_bondrsv1(0,iwbond-1,xr)
               call get_bondrad1(iframe,ibond-1,xr)
               call set_bondrad1(0,iwbond-1,xr)
            endif
         endif
      enddo
c     Measures... Bloerk.
      call get_first_measure(iframe,itype,ip,ix,iy)
 2001 continue
      if (itype.ne.0) then
         ikeep=1
         if (itype.eq.1) then
            np=2
         else if (itype.eq.2) then
            np=3
         else if (itype.eq.3) then
            np=4
         endif
         do i=1,np
            do idel=1,ndelatoms
               if (delatomid(idel).eq.ip(np+i)) then
                  ikeep=0
               endif
            enddo
         enddo
         if (ikeep.ne.0) then
c     Keep and reassign
            do iatom=1,nwritten_atoms
               call get_atomid(0,iatom-1,icmp)
               do i=1,np
                  if (icmp.eq.ip(np+i)) ip(i)=iatom
               enddo
            enddo
            call add_measure(0,itype,ip,ix,iy)
         endif
         call get_next_measure(iframe,itype,ip,ix,iy)
         goto 2001
      endif




c     frametext
      call get_hasframetext(iframe,ir)
      call set_hasframetext(0,ir)
      if (ir.eq.1) then
         call get_frametext(iframe,ftext)
         call set_frametext(0,ftext)
      else
         ftext='  '
         call set_frametext(0,ftext)
      endif
      call copy_temporary_to_frame(iframe)
      call deinitialize_temporary
      return
      end

c     Modify Apply Bond Rules Frame
      subroutine mabrf(iframe)
      implicit double precision (a-h,o-z)

#include "world.commonblock"
#include "table.commonblock"
#include "bondrule.commonblock"
      character*120 tempfilename1
      character*120 tempfilename2
      character*120 tempdirname
      character*FMAXCHARSPERLABEL labeltext
      character*FMAXCHARSINFRAMETEXT ftext
      integer atoms,bonds
      integer connect1(12)
      integer connect2(12)
      data connect1 / 1,1,1,2,2,3,3,4,5,5,6,7 /
      data connect2 / 2,3,5,4,6,7,4,8,6,7,8,8 /

      call get_atoms(iframe,natoms)
      call get_triangles(iframe,ntriangles)
      call initialize_temporary(natoms,ntriangles)
      call copy_measures(iframe,0)
      call get_crystal_matrix(iframe,xcrystal)
      call set_crystal_matrix(0,xcrystal)
      natomcryst=0
      do it=1,ntriangles
        call get_triangle(iframe,it-1,tx,ty,tz,tnx,tny,tnz,
     x       tfr,opaq,nr,ng,nb,nn,ntwo)
        call set_triangle(0,it-1,tx,ty,tz,tnx,tny,tnz,
     x       tfr,opaq,nr,ng,nb,nn,ntwo)
      enddo
      do iatom=1,natoms
        call get_atomid(iframe,iatom-1,itmp)
        call set_atomid(0,iatom-1,itmp)
        call get_atomnr(iframe,iatom-1,itmp)
        if (itmp.eq.256) natomcryst=natomcryst+1
        call set_atomnr(0,iatom-1,itmp)
        call get_atomxyz(iframe,iatom-1,x,y,z)
        call set_atomxyz(0,iatom-1,x,y,z)
        call get_atomscalerad(iframe,iatom-1,xtmp)
        call set_atomscalerad(0,iatom-1,xtmp)
        call get_defradweight(iframe,iatom-1,idef)
        call set_defradweight(0,iatom-1,idef)
        if (idef.ne.1) then
          call get_atomrad(iframe,iatom-1,xtmp)
          call set_atomrad(0,iatom-1,xtmp)
          call get_atomweight(iframe,iatom-1,xtmp)
          call set_atomweight(0,iatom-1,xtmp)
        endif
        call get_defcol(iframe,iatom-1,idefc)
        call set_defcol(0,iatom-1,idefc)
        if (idefc.ne.1) then
          call get_atomr(iframe,iatom-1,itmp)
          call set_atomr(0,iatom-1,itmp)
          call get_atomg(iframe,iatom-1,itmp)
          call set_atomg(0,iatom-1,itmp)
          call get_atomb(iframe,iatom-1,itmp)
          call set_atomb(0,iatom-1,itmp)
          call get_atomn(iframe,iatom-1,itmp)
          call set_atomn(0,iatom-1,itmp)
          call get_atomrsv(iframe,iatom-1,xtmp)
          call set_atomrsv(0,iatom-1,xtmp)
        endif
        call get_atomdrawstyle(iframe,iatom-1,itmp)
        call set_atomdrawstyle(0,iatom-1,itmp)
        call get_deflabel(iframe,iatom-1,iatomlabel)
        call set_deflabel(0,iatom-1,iatomlabel)
        if (iatomlabel.ne.0) then
          call get_atomlabel(iframe,iatom-1,labeltext)
          call set_atomlabel(0,iatom-1,labeltext)
        else
          call set_atomlabel(0,iatom-1,' ')
        endif
        call get_atomhasmessage(iframe,iatom-1,itmp)
        call set_atomhasmessage(0,iatom-1,itmp)
      enddo
      rmaxmax=0.
      do ibond=1,natoms
        call get_atomnr(0,ibond-1,inr)
        if (atom_radius(inr).gt.rmaxmax) rmaxmax=atom_radius(inr)
      enddo
      fuzzmax=0.
      do ibond=1,nbondrules
        if (fuzzfactor(ibond).gt.fuzzmax) fuzzmax=fuzzfactor(ibond)
      enddo
      rmaxmax=2*rmaxmax+fuzzmax
      call compute_pairs(0,rmaxmax,npairs)
      bonds=0
c     compute new bonds using the bond rules
      if (nbondrules.gt.0) then
        do ipair=1,npairs
          call pairgt(ipair-1,ibond,jbond)
          ibond=ibond+1
          jbond=jbond+1

          ibondr=1
 100      continue
          if (ibond.ne.jbond) then
c     test for donors and acceptors!!!
            if ((ndonors(ibondr).eq.0).and.
     x           (nacceptors(ibondr).eq.0)) goto 105
            if (ndonors(ibondr).eq.0) then
c     search for acceptor
              do k=1,nacceptors(ibondr)
                call get_atomnr(0,ibond,inr)
                if (acceptors(ibondr,k).eq.
     x               inr) goto 105
                call get_atomnr(0,jbond,jnr)
                if (acceptors(ibondr,k).eq.
     x               jnr) goto 105
              enddo
            else
              if (nacceptors(ibondr).eq.0) then
c     search for donor
                do k=1,ndonors(ibondr)
                  call get_atomnr(0,ibond,inr)
                  if (donors(ibondr,k).eq.
     x                 inr) goto 105
                  call get_atomnr(0,jbond,jnr)
                  if (donors(ibondr,k).eq.
     x                 jnr) goto 105
                enddo
              else
c     search for both donor and acceptor
                call get_atomnr(0,ibond-1,inr)
                call get_atomnr(0,jbond-1,jnr)
c     write(*,*) 'Btest:',inr,jnr
                do k1=1,ndonors(ibondr)
                  do k2=1,nacceptors(ibondr)
c     write(*,*) 'D:',donors(ibondr,k1),
c     x                             ' A:',acceptors(ibondr,k2)
                    if (donors(ibondr,k1).eq.
     x                   inr) then
                      if (acceptors(ibondr,k2).eq.
     x                     jnr) goto 105
                    endif
                    if (donors(ibondr,k1).eq.
     x                   jnr) then
                      if (acceptors(ibondr,k2).eq.
     x                     inr) goto 105
                    endif
                  enddo
                enddo
              endif
            endif
            goto 120
 105        continue
c     test for bond making
            call get_atomnr(0,ibond-1,inr)
            call get_atomnr(0,jbond-1,jnr)
c     write(*,*) 'Testing: ',inr,jnr
            if ((inr.eq.256).or.(jnr.eq.256)) goto 120
            call get_atomxyz(0,ibond-1,x1,y1,z1)
            call get_atomxyz(0,jbond-1,x2,y2,z2)
            xd=x1-x2
            yd=y1-y2
            zd=z1-z2
            dist=sqrt(xd*xd+yd*yd+zd*zd)
            if (vdwsub(ibondr).ne.0) then
              dist=dist-atom_radius(inr)-atom_radius(jnr)
            endif
            if (dist.lt.fuzzfactor(ibondr)) goto 110
            goto 120
 110        continue
c     create a bond

c     new bond
            call add_temporary_bond
            bonds=bonds+1
c     draw bond
            call set_drawbond(0,bonds-1,1)
c     atom numbers in buffer and atom ids:
            call get_atomid(0,ibond-1,iid)
            call get_atomid(0,jbond-1,jid)
            call set_bondp(0,bonds-1,ibond,jbond,iid,jid)
            call set_bond1(0,bonds-1,ibond)
            call set_bond2(0,bonds-1,jbond)

            if (colors(ibondr).eq.-1) then
c     default color parameters and default radius
              call set_defbcol(0,bonds-1,1)
            else
              call set_defbcol(0,bonds-1,0)
              ir=MOD(colors(ibondr),256)
              ig=MOD(colors(ibondr)/256,256)
              ib=MOD(colors(ibondr)/65536,256)
              drsv=bondrulersv(ibondr)
              in=bondrulen(ibondr)
              inslice=bondrulenslice(ibondr)
              drad=bondrulewidth(ibondr)
              call set_bondr1(0,bonds-1,ir)
              call set_bondg1(0,bonds-1,ig)
              call set_bondb1(0,bonds-1,ib)
              call set_bondn1(0,bonds-1,in)
              call set_bondnslice(0,bonds-1,inslice)
              call set_bondrsv1(0,bonds-1,drsv)
              call set_bondrad1(0,bonds-1,drad)
            endif
            goto 130
 120        continue
c     do not create a bond, test for more bond rules
            ibondr=ibondr+1
            if (ibondr.le.nbondrules) then
              goto 100
            endif
 130        continue
            
          endif
        enddo
      endif
      if (natomcryst.eq.8) then
c     add cell:
        do iadd=1,12
          call add_temporary_bond
          bonds=bonds+1
          call set_drawbond(0,bonds-1,1)
          ibond=natoms-8+connect1(iadd)
          jbond=natoms-8+connect2(iadd)
          iid=1000000000+iadd
          jid=1000000000+iadd+12
          call set_bondp(0,bonds-1,ibond,jbond,iid,jid)
          call set_bond1(0,bonds-1,ibond)
          call set_bond2(0,bonds-1,jbond)
          call set_defbcol(0,bonds-1,0)
          call set_bondr1(0,bonds-1,0)
          call set_bondg1(0,bonds-1,0)
          call set_bondb1(0,bonds-1,0)
          call set_bondn1(0,bonds-1,20)
          call set_bondnslice(0,bonds-1,0)
          call set_bondrsv1(0,bonds-1,0.7d0)
          call set_bondrad1(0,bonds-1,0.1d0)
        enddo
      endif
c     frametext
      call get_hasframetext(iframe,iframetext)
      call set_hasframetext(0,iframetext)
      if (iframetext.ne.0) then
        call get_frametext(iframe,ftext)
        call set_frametext(0,ftext)
        call get_frametextxy(iframe,xmy,ymy)
        call set_frametextxy(0,xmy,ymy)
      endif

      call copy_temporary_to_frame(iframe)
      call deinitialize_temporary

      return
      end

c     Modify Apply Bond Rules
      subroutine mabrx
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      if (ishowprogress.eq.1) iobj=ixcopw('Computing bondrules...')
      call gframe(iframe,nframes)
      do i=1,nframes
         if (ishowprogress.eq.1) call xcopws(iobj,dble(i)/nframes)
         call mabrf(i)
      enddo
      if (ishowprogress.eq.1) call xcodel(iobj)
      return
      end

c     Modify Apply Polygon Rules
      subroutine maprx
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      if (ishowprogress.eq.1) iobj=ixcopw('Computing polygon rules...')
      call gframe(iframe,nframes)
      do i=1,nframes
         if (ishowprogress.eq.1) call xcopws(iobj,dble(i)/nframes)
         call maprf(i)
      enddo
      if (ishowprogress.eq.1) call xcodel(iobj)
      return
      end

      subroutine mabr
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      ishowprogress=1
      call mabrx
      ishowprogress=0
      return
      end

      subroutine mapr
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      ishowprogress=1
      call maprx
      ishowprogress=0
      return
      end

      subroutine mabrns
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      ishowprogress=0
      call mabrx
      return
      end

      subroutine maprns
      implicit double precision (a-h,o-z)
#include "import.commonblock"
      ishowprogress=0
      call maprx
      return
      end


c     Modify CREate Bonds
      subroutine mcreb(iframe,creatomnr)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer creatomnr

      call get_nframes(nframes)
      nworld=nframes+1
      
c     Copy atoms (anything but bonds really) to temporary frame
      call copy_frameatoms_to_temporary(iframe)
c     Copy bonds to temporary frame
      call copy_framebonds_to_temporary(iframe)

      call get_atoms(nworld,natomstmp)
      do iatom=1,natomstmp
         call get_atomid(nworld,iatom-1,id)
         if (id.eq.creatomnr) mynumber=iatom
      enddo
c     Create bonds
      call get_atoms(nworld,natoms)
      do isearch=1,natoms
         call get_atomselected(nworld,isearch-1,isel)
         if (isel.ne.0) then
            do isearch2=1,natomstmp
               call get_atomid(nworld,isearch-1,id1)
               call get_atomid(0,isearch2-1,id2)
               if (id2.eq.
     x              id1) then
                  if (id2.ne.
     x                 creatomnr) then
                     call add_temporary_bond
                     call get_bonds(0,iwbond)
                     call set_drawbond(0,iwbond-1,1)
                     call set_bondp(0,iwbond-1,isearch2,mynumber,
     x                    id2,creatomnr)
                     call set_bond1(0,iwbond-1,isearch2)
                     call set_bond2(0,iwbond-1,mynumber)
                     call set_defbcol(0,iwbond-1,1)
                  endif
               endif
            enddo
         endif
      enddo
      call copy_temporary_to_frame(iframe)
      call deinitialize_temporary
      return
      end

c     Modify DELete Bonds
      subroutine mdelb(iframe,delatomids1,delatomids2,ndelatomids)
      implicit double precision (a-h,o-z)

#include "world.commonblock"
#include "table.commonblock"
      integer delatomids1(*),delatomids2(*),ndelatomids

      call get_nframes(nframes)
      nworld=nframes+1
      
c     Copy atoms (anything but bonds really) to temporary frame
      call copy_frameatoms_to_temporary(iframe)

      call get_bonds(nworld,nbonds)

      do ibond=1,nbonds

         iwritebond=1
         call get_bondp(nworld,ibond-1,ino1,ino2,id1,id2)
         do idelid=1,ndelatomids
            if ((delatomids1(idelid).eq.id1).and.
     x           (delatomids2(idelid).eq.id2)) iwritebond=0
            if ((delatomids1(idelid).eq.id2).and.
     x           (delatomids2(idelid).eq.id1)) iwritebond=0
         enddo
         if (iwritebond.eq.1) then
            call add_temporary_bond
            call get_bonds(0,iwbond)
            call get_drawbond(nworld,ibond-1,idraw)
            call set_drawbond(0,iwbond-1,idraw)
            call set_bondp(0,iwbond-1,ino1,ino2,id1,id2)
            call set_bond1(0,iwbond-1,ino1)
            call set_bond2(0,iwbond-1,ino2)
            call get_defbcol(nworld,ibond-1,idef)
            call set_defbcol(0,iwbond-1,idef)
            if (idef.ne.1) then
               call get_bondr1(nworld,ibond-1,ir)
               call get_bondg1(nworld,ibond-1,ig)
               call get_bondb1(nworld,ibond-1,ib)
               call set_bondr1(0,iwbond-1,ir)
               call set_bondg1(0,iwbond-1,ig)
               call set_bondb1(0,iwbond-1,ib)
               call get_bondn1(nworld,ibond-1,ib)
               call set_bondn1(0,iwbond-1,ib)
               call get_bondnslice(nworld,ibond-1,ib)
               call set_bondnslice(0,iwbond-1,ib)
               call get_bondrsv1(nworld,ibond-1,xr)
               call set_bondrsv1(0,iwbond-1,xr)
               call get_bondrad1(nworld,ibond-1,xr)
               call set_bondrad1(0,iwbond-1,xr)
            endif
         endif
      enddo

      call copy_temporary_to_frame(iframe)
      call deinitialize_temporary

      return
      end

c     Modify Bond PROperties
      subroutine mbpro(iframe,delatomids1,delatomids2,ndelatomids,
     x     color_r,color_g,color_b,rad,islice)
      implicit double precision (a-h,o-z)

#include "world.commonblock"
#include "table.commonblock"
      integer delatomids1(*),delatomids2(*),ndelatomids,
     x     color_r,color_g,color_b
      double precision rad
      call get_bonds(iframe,nbonds)
      do ibond=1,nbonds
         imodifybond=0
         call get_bondp(iframe,ibond-1,ino1,ino2,id1,id2)
         do idelid=1,ndelatomids
            if ((delatomids1(idelid).eq.id1).and.
     x           (delatomids2(idelid).eq.id2)) imodifybond=1
            if ((delatomids1(idelid).eq.id2).and.
     x           (delatomids2(idelid).eq.id1)) imodifybond=1
         enddo
         if (imodifybond.ne.0) then
            call set_defbcol(iframe,ibond-1,0)
            call set_bondr1(iframe,ibond-1,color_r)
            call set_bondg1(iframe,ibond-1,color_g)
            call set_bondb1(iframe,ibond-1,color_b)
            call set_bondrad1(iframe,ibond-1,rad)
            call set_bondrsv1(iframe,ibond-1,BOND_DEFAULT_RSV)
            call set_bondn1(iframe,ibond-1,BOND_DEFAULT_N)
            call set_bondnslice(iframe,ibond-1,islice)
         endif
      enddo
      return
      end


c     Modify Atom Color
      subroutine macol(iframe,modatomids1,nmodatomids,
     x     color_r,color_g,color_b)
      implicit double precision (a-h,o-z)

#include "world.commonblock"
#include "table.commonblock"
      integer modatomids1(*),nmodatomids,
     x     color_r,color_g,color_b

      call get_atoms(iframe,natoms)
      do iatom=1,natoms
         imodatom=0
         call get_atomid(iframe,iatom-1,id)
         do isrch=1,nmodatomids
            if (modatomids1(isrch).eq.id) imodatom=1
         enddo
         if (imodatom.ne.0) then
            call get_atomnr(iframe,iatom-1,inr)
            xrsv=rsv(atom_color(inr))
            n=nfactor(atom_color(inr))
            call get_defcol(iframe,iatom-1,idef)
            if (idef.ne.0) then
               call set_atomrsv(iframe,iatom-1,xrsv)
               call set_atomn(iframe,iatom-1,n)
            endif
            call set_defcol(iframe,iatom-1,0)
            call set_atomr(iframe,iatom-1,color_r)
            call set_atomg(iframe,iatom-1,color_g)
            call set_atomb(iframe,iatom-1,color_b)
         endif
      enddo
      return
      end

c     Modify Atom drawstyle
      subroutine madst(iframe,modatomids1,nmodatomids,
     x     style)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer modatomids1(*),nmodatomids,
     x     style

      call get_atoms(iframe,natoms)
      do iatom=1,natoms
         imodatom=0
         call get_atomid(iframe,iatom-1,id)
         do isrch=1,nmodatomids
            if (modatomids1(isrch).eq.id) imodatom=1
         enddo
         if (imodatom.ne.0) then
            call set_atomdrawstyle(iframe,iatom-1,style)
         endif
      enddo
      return
      end

c     Modify Atom rsv
      subroutine madrsv(iframe,modatomids1,nmodatomids,
     x     xrsv)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer modatomids1(*),nmodatomids

      call get_atoms(iframe,natoms)
      do iatom=1,natoms
         imodatom=0
         call get_atomid(iframe,iatom-1,id)
         do isrch=1,nmodatomids
            if (modatomids1(isrch).eq.id) imodatom=1
         enddo
         if (imodatom.ne.0) then
            call get_atomnr(iframe,iatom-1,inr)
            n=nfactor(atom_color(inr))
            icolor_r=rgb(atom_color(inr),1)
            icolor_g=rgb(atom_color(inr),2)
            icolor_b=rgb(atom_color(inr),3)
            call get_defcol(iframe,iatom-1,idef)
            if (idef.ne.0) then
               call set_atomn(iframe,iatom-1,n)
               call set_atomr(iframe,iatom-1,icolor_r)
               call set_atomg(iframe,iatom-1,icolor_g)
               call set_atomb(iframe,iatom-1,icolor_b)
            endif
            call set_defcol(iframe,iatom-1,0)
            call set_atomrsv(iframe,iatom-1,xrsv)
         endif
      enddo
      return
      end

c     Modify Atom phong n
      subroutine madpn(iframe,modatomids1,nmodatomids,
     x     n)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer modatomids1(*),nmodatomids

      call get_atoms(iframe,natoms)
      do iatom=1,natoms
         imodatom=0
         call get_atomid(iframe,iatom-1,id)
         do isrch=1,nmodatomids
            if (modatomids1(isrch).eq.id) imodatom=1
         enddo
         if (imodatom.ne.0) then
            call get_atomnr(iframe,iatom-1,inr)
            xrsv=rsv(atom_color(inr))
            icolor_r=rgb(atom_color(inr),1)
            icolor_g=rgb(atom_color(inr),2)
            icolor_b=rgb(atom_color(inr),3)
            call get_defcol(iframe,iatom-1,idef)
            if (idef.ne.0) then
               call set_atomrsv(iframe,iatom-1,xrsv)
               call set_atomr(iframe,iatom-1,icolor_r)
               call set_atomg(iframe,iatom-1,icolor_g)
               call set_atomb(iframe,iatom-1,icolor_b)
            endif
            call set_defcol(iframe,iatom-1,0)
            call set_atomn(iframe,iatom-1,n)
         endif
      enddo
      return
      end

c     Modify Atom label
      subroutine madlbl(iframe,modatomids1,nmodatomids,
     x     idflt,label)
      implicit double precision (a-h,o-z)
#include "world.commonblock"
#include "table.commonblock"
      integer modatomids1(*),nmodatomids
      character*(*) label

      call get_atoms(iframe,natoms)
      do iatom=1,natoms
         imodatom=0
         call get_atomid(iframe,iatom-1,id)
         do isrch=1,nmodatomids
            if (modatomids1(isrch).eq.id) imodatom=1
         enddo
         if (imodatom.ne.0) then
            if (idflt.ne.0) then
               call set_deflabel(iframe,iatom-1,0)
            else
               call set_deflabel(iframe,iatom-1,1)
               call set_atomlabel(iframe,iatom-1,label)
            endif
         endif
      enddo
      return
      end
