/* This is measure.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>

#include "ccinterface.h"
#include "fstring.h"
#include "measure.h"
#include "errorhandler.h"
#include "worldmemory.h"

typedef struct selectorder
{
  int id;
  struct selectorder *next;
} selectorder;

static selectorder *selectorder_hook=NULL;

#if defined(USCORE2)
void add_to_selectorder__(int *id)
#else
void add_to_selectorder_(int *id)
#endif
{
  selectorder *new=malloc(sizeof(selectorder));
  new->id=*id;
  new->next=selectorder_hook;
  selectorder_hook=new;
}

static selectorder *sel_ll;
#if defined(USCORE2)
void get_first_selectorder__(int *id)
#else
void get_first_selectorder_(int *id)
#endif
{
    sel_ll=selectorder_hook;
    if (sel_ll)
	*id=sel_ll->id;
    else
	*id=-1;
}

#if defined(USCORE2)
void get_next_selectorder__(int *id)
#else
void get_next_selectorder_(int *id)
#endif
{
    sel_ll=sel_ll->next;
    if (sel_ll)
	*id=sel_ll->id;
    else
	*id=-1;
}

#if defined(USCORE2)
void remove_from_selectorder__(int *id)
#else
void remove_from_selectorder_(int *id)
#endif
{
  selectorder *ptr=selectorder_hook,*tmp=NULL;
  while(ptr && (ptr->id!=*id))
    {
      tmp=ptr;
      ptr=ptr->next;
    }
  if (ptr)
  {
      if (tmp==NULL)
	  selectorder_hook=ptr->next;
      else
	  tmp->next=ptr->next;
      free(ptr);
  }
}

#if defined(USCORE2)
void clear_selectorder__()
#else
void clear_selectorder_()
#endif
{
  selectorder *ptr=selectorder_hook,*tmp;
  while(ptr!=NULL)
    {
      tmp=ptr;
      ptr=ptr->next;
      free(tmp);
    }
  selectorder_hook=NULL;
}


void measure_distance(int x,int y)
{
  int i,natoms,nsel,atom[2],frame,nframes;;
  gframe_(&frame,&nframes);
  /* Count number of selected atoms */
  qna_(&natoms);
  nsel=0;
  for (i=0; i<natoms; i++)
    {
      int isel,j=i+1;
      qasel_(&j,&isel);
      if (isel)
	{
	  nsel++;
	  if (nsel<=2)
	    atom[nsel-1]=i+1;
	}
    }
  if (nsel!=2)
    {
      show_error_message("You must select exactly two atoms");
      update_error_message_box();
    }
  else
    {
      int atomid[2],p[4];
      for (i=0; i<2; i++)
	aid_(&atom[i],&atomid[i]);
      p[2]=atomid[0];
      p[3]=atomid[1];


      for (i=1; i<=nframes; i++)
	{
	  int j;
#if defined(USCORE2)
	  get_atoms__(&i,&natoms);
#else
	  get_atoms_(&i,&natoms);
#endif
	  nsel=0;
	  for (j=0; j<natoms; j++)
	    {
	      int k;
#if defined(USCORE2)
	      get_atomid__(&i,&j,&k);
#else
	      get_atomid_(&i,&j,&k);
#endif
	      if (k==atomid[0])
		{
		  p[0]=j+1;
		  nsel++;
		}
	      if (k==atomid[1])
		{
		  p[1]=j+1;
		  nsel++;
		}
	    }
	  if (nsel==2)
	    add_measure(i,MEASURE_DISTANCE,p,x,y);
	}
      wupd_();
    }
}



void measure_angle(int x,int y)
{
  int i,natoms,nsel,atom[3],frame,nframes;;
  gframe_(&frame,&nframes);
  /* Count number of selected atoms */
  qna_(&natoms);
  nsel=0;
  for (i=0; i<natoms; i++)
    {
      int isel,j=i+1;
      qasel_(&j,&isel);
      if (isel)
	{
	  nsel++;
	  if (nsel<=3)
	    atom[nsel-1]=i+1;
	}
    }
  if (nsel!=3)
    {
      show_error_message("You must select exactly three atoms");
      update_error_message_box();
    }
  else
    {
      int atomid[3],p[6];
      selectorder *ptr=selectorder_hook;
      for (i=0; i<3; i++)
	{
	  atomid[i]=ptr->id;
	  ptr=ptr->next;
	}
      p[3]=atomid[0];
      p[4]=atomid[1];
      p[5]=atomid[2];

      for (i=1; i<=nframes; i++)
	{
	  int j;
#if defined(USCORE2)
	  get_atoms__(&i,&natoms);
#else
	  get_atoms_(&i,&natoms);
#endif
	  nsel=0;
	  for (j=0; j<natoms; j++)
	    {
	      int k;
#if defined(USCORE2)
	      get_atomid__(&i,&j,&k);
#else
	      get_atomid_(&i,&j,&k);
#endif
	      if (k==atomid[0])
		{
		  p[0]=j+1;
		  nsel++;
		}
	      if (k==atomid[1])
		{
		  p[1]=j+1;
		  nsel++;
		}
	      if (k==atomid[2])
		{
		  p[2]=j+1;
		  nsel++;
		}
	    }
	  if (nsel==3)
	    add_measure(i,MEASURE_ANGLE,p,x,y);
	}
      wupd_();
    }
}

void measure_dihedral(int x,int y)
{
  int i,natoms,nsel,atom[3],frame,nframes;;
  gframe_(&frame,&nframes);
  /* Count number of selected atoms */
  qna_(&natoms);
  nsel=0;
  for (i=0; i<natoms; i++)
    {
      int isel,j=i+1;
      qasel_(&j,&isel);
      if (isel)
	{
	  nsel++;
	  if (nsel<=3)
	    atom[nsel-1]=i+1;
	}
    }
  if (nsel!=4)
    {
      show_error_message("You must select exactly four atoms");
      update_error_message_box();
    }
  else
    {
      int atomid[4],p[8];
      selectorder *ptr=selectorder_hook;
      for (i=0; i<4; i++)
	{
	  atomid[i]=ptr->id;
	  ptr=ptr->next;
	}
      p[4]=atomid[0];
      p[5]=atomid[1];
      p[6]=atomid[2];

      for (i=1; i<=nframes; i++)
	{
	  int j;
#if defined(USCORE2)
	  get_atoms__(&i,&natoms);
#else
	  get_atoms_(&i,&natoms);
#endif
	  nsel=0;
	  for (j=0; j<natoms; j++)
	    {
	      int k;
#if defined(USCORE2)
	      get_atomid__(&i,&j,&k);
#else
	      get_atomid_(&i,&j,&k);
#endif
	      if (k==atomid[0])
		{
		  p[0]=j+1;
		  nsel++;
		}
	      if (k==atomid[1])
		{
		  p[1]=j+1;
		  nsel++;
		}
	      if (k==atomid[2])
		{
		  p[2]=j+1;
		  nsel++;
		}
	      if (k==atomid[3])
		{
		  p[3]=j+1;
		  nsel++;
		}
	    }
	  if (nsel==4)
	    add_measure(i,MEASURE_DIHEDRAL,p,x,y);
	}
      wupd_();
    }
}

void measure_clear_all()
{
  int i,frame,nframes;;
  gframe_(&frame,&nframes);
  for (i=1; i<=nframes; i++)
    remove_measure(i);
  wupd_();
}
