/* This is main.c
   A part of the Ymol program
   Copyright (C) 1997-2001 Daniel Spangberg
   */

static char rcsid[]="$Id: main.c 66 2007-08-12 15:08:49Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <Xco.h>
#include <y4vm.h>

#include "userinterface.h"
#include "importinterface.h"
#include "xinterface.h"
#include "ccinterface.h"
#include "periodic_table.h"
#include "vmconsole.h"
#include "ymolrc.h"
#include "ymolsignal.h"
#include "fstring.h"
#include "sockimport.h"

void test_triangles(unsigned int *,int *,int,int);

static char *load_filename=NULL;

int load_file_function()
{
    int load_ymol=0;
    int load_y4=0;
    int len=strlen(load_filename);
    if (len>=3)
    {
	if ((load_filename[len-1]=='4') &&
	    (load_filename[len-2]=='y') &&
	    (load_filename[len-3]=='.'))
	{
	    load_y4=1;
	}
    }
    if (len>=5)
    {
	if ((load_filename[len-1]=='l') &&
	    (load_filename[len-2]=='o') &&
	    (load_filename[len-3]=='m') &&
	    (load_filename[len-4]=='y') &&
	    (load_filename[len-5]=='.'))
	{
	    load_ymol=1;
	}
    }
    if (load_ymol)
    {
	    int ok=0;
	    fload_file(load_filename,&ok);
    }
    else if (load_y4)
    {
	char *b=malloc(len+5);
	load_filename[len-3]=0;
	sprintf(b,"'%s' load",load_filename);
	restore_vm_state();
	vm_run();
	vm_parse_and_compile(b);
	vm_parse_and_compile("stop");
	save_vm_state();
	free(b);
    }
    else
    {
	import_dialog(load_filename);
	really_import_file();
    }

    return 1;
}

static char startuppath[1000];

static void cleanup()
{
  char tmp[1000];
  sprintf(tmp,"%s/ymolpid",startuppath);
  remove(tmp);
  sprintf(tmp,"%s/ymol_sockimport",startuppath);
  remove(tmp);
}

int main(int argc, char **argv)
{
  uint32 *buf;
  int32 *zbuffer;
  int xsize,ysize;

  printf("Ymol %s\n%s\n",
	 PROGRAMVERSION,COMPILEINFO);
  
#ifdef USEOPENGL
  XcoSetQueryVisual(query_visual_gl,postprocess_visual_gl);
#endif

  if (XcoInit())
    {
	printf("Could not initialize Xco.\n");
#ifdef USEOPENGL
	if (XcoGetInitError()==XcoInitNoOtherVisuals)
	{
	    /* Try without OpenGL */
	    XcoSetQueryVisual(NULL,NULL);
	    printf("Trying without OpenGL.\n");
	    if (XcoInit())
	    {
		printf("Could not initialize Xco without OpenGL support.\n");
		return 1;
	    }
	    else
		printf("Xco works without OpenGL!\n");
	}
	else
#endif
	    return 1;
    }

  if (init_userinterface(&argc,&argv))
    {
      printf("If this error is unexpected, please contact the support.\n");
      return(1); 
    }

  buf=get_buffer_ptr();
  zbuffer=get_zbuffer_ptr();

  getcwd(startuppath,1000);
  atexit(cleanup);

  get_buffer_size(&xsize,&ysize);
  initf_((int*)buf,(int*) zbuffer,&xsize,&ysize);

#ifdef MULTIBUFFER
  query_multibuffer();
#endif
#ifdef DOUBLEBUFFER
  query_doublebuffer();
#endif
  steini_();

  vmconsoleinit();

  load_ymolrc();

  install_signal_handler();

  if (argc==2)
  {
      /* Load a file...
      Setup callback to do that.
      */
      load_filename=malloc(strlen(argv[1])+1);
      strcpy(load_filename,argv[1]);
      XcoAddWorkProc(load_file_function);
  }

  sockimport_init();
  process_events();

  return(0);
}


