/* This is lights.c
   A part of the Ymol program
   Copyright (C) 1997-2001 Daniel Spangberg
   */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "Xco.h"
#include "ccinterface.h"
#include "xinterface.h"
#include "defaults.h"
#include "register_update.h"
#include "triangleworld.h"

static int virgin=1;
static int temp_color;
static int current_light=0;

#define WINDOW_WIDTH 250
#define WINDOW_HEIGHT 220

static int edit_open=0;
static XcoObject ewindow,colorhole,xdialog,ydialog,zdialog,whichlight_label;
static XcoObject colsel,nextlight_button,addlight_button;

static void e_delete_window(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      XcoDeleteObject(ewindow);
      edit_open=0;
    }
}

static void set_colorpixmap(unsigned int pixel)
{
  int i;
  Pixmap colorpixmap;
  unsigned int image[16];
  for (i=0; i<16; i++)
    image[i]=pixel;
  colorpixmap=XcoCreatePixmapFromImage(colorhole,image,4,4);
  XcoSetBackgroundPixmap(colorhole,colorpixmap,True);
  XFreePixmap(XcoGetDisplay(),colorpixmap);
}

static void use_color(int r,int g,int b,int ok)
{
  if (edit_open)
    if (ok)
      {
	temp_color=PIXEL(r,g,b);
	set_colorpixmap(temp_color);
      }
}

static int open_bcolor=0;

static void dcolsel(XcoObject dummy,XEvent event)
{
  if (event.type==DestroyNotify)
    {
      open_bcolor=0;
    }
}


static void browse_colors(XcoObject dummy,XEvent event)
{
  if (edit_open)
    {
      if (event.type==ButtonPress)
	{
	  if (!open_bcolor)
	    {
	      colsel=XcoColorselector(R_OF_PIXEL(temp_color),
						G_OF_PIXEL(temp_color),
						B_OF_PIXEL(temp_color),
						use_color);
	      XcoAddCallback(colsel,dcolsel);
	      open_bcolor=1;
	    }
	}
    }
}

static void update_lightview()
{
    char tmps[100];
    int maxlights=get_nlamps();
    lamp *thelamp;
    if (current_light>=maxlights)
	current_light=0;
    sprintf(tmps,"Light %d/%d",current_light+1,get_nlamps());
    XcoSetLabelString(whichlight_label,tmps);
    
    thelamp=get_lamp(current_light);
    temp_color=PIXEL(thelamp->r,thelamp->g,thelamp->b);
    set_colorpixmap(temp_color);
    
    sprintf(tmps,"%6.4f",thelamp->x);
    XcoSetDialogValue(xdialog,tmps);
    sprintf(tmps,"%6.4f",thelamp->y);
    XcoSetDialogValue(ydialog,tmps);
    sprintf(tmps,"%6.4f",thelamp->z);
    XcoSetDialogValue(zdialog,tmps);
}

static void save_this_light()
{
    int maxlights=get_nlamps();
    if (current_light<maxlights)
    {
	double l;
	lamp *thelamp=get_lamp(current_light);
	thelamp->r=R_OF_PIXEL(temp_color);
	thelamp->g=G_OF_PIXEL(temp_color);
	thelamp->b=B_OF_PIXEL(temp_color);

	thelamp->x=atof(XcoGetDialogValue(xdialog));
	thelamp->y=atof(XcoGetDialogValue(ydialog));
	thelamp->z=atof(XcoGetDialogValue(zdialog));

	l=1./sqrt(thelamp->x*thelamp->x+
		  thelamp->y*thelamp->y+
		  thelamp->z*thelamp->z);
	thelamp->x*=l;
	thelamp->y*=l;
	thelamp->z*=l;
	
	update_lightview();
	sylamp_();
    }
}

static void dialog_callback(XcoObject dummy,XEvent event)
{
    if (XcoDialogEnter(dummy,event))
	save_this_light();
}

static void nextlight_callback(XcoObject dummy,XEvent event)
{
    if (event.type==ButtonPress)
    {
	save_this_light();
	current_light++;
	update_lightview();
    }
}

static void addlight_callback(XcoObject dummy,XEvent event)
{
    if (event.type==ButtonPress)
    {
	lamp l;
	save_this_light();
	l.x=l.y=-(l.z=1./sqrt(3.));
	l.r=l.g=l.b=70;
	add_lamp(l);
	current_light=get_nlamps()-1;
	update_lightview();
    }
}


static void apply_changes(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      save_this_light();
      fupd_();
    }
}

static void update_em()
{
  if (open_bcolor)
    {
      XcoDeleteObject(colsel);
      open_bcolor=0;
    }
  if (edit_open)
    {
	update_lightview();
    }
}

void edit_lights()
{
  if (!edit_open)
    {
      int ypos;
      char whichlight[100];
      XcoObject hole,hole2,label,hole3,bcmd,colorbox,acmd,decorbox;
      if (virgin)
	{
	  register_update_function(update_em);
	  virgin=0;
	}

      ewindow=XcoCreateNamedDialogParent(-1,0,0,WINDOW_WIDTH,WINDOW_HEIGHT,"Lights");

      XcoAddCallback(ewindow,e_delete_window);

      decorbox=XcoCreateBox3D(ewindow,5,5,WINDOW_WIDTH-10,WINDOW_HEIGHT-45,2,1);

      sprintf(whichlight,"Light %d/%d",current_light+1,get_nlamps());
      whichlight_label=XcoCreateLabel(decorbox,10,14,whichlight,90,16);
      XcoSetResizeMethod(whichlight_label,XcoUpLeft);

      hole=XcoCreateHole(decorbox,5,40,WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole,XcoUpLeft);
      hole2=XcoCreateHole(hole,0,0,WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Lamp color",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      hole3=XcoCreateHole(hole2,0,ypos,WINDOW_WIDTH-20,50-ypos);
      XcoSetResizeMethod(hole3,XcoUpResize);
      bcmd=XcoCreateCommand(hole3,60,0,"Browse",0,0);
      colorbox=XcoCreateBox3D(hole3,0,0,50,XcoGetObjectHeight(bcmd),0,1);
      colorhole=XcoCreateHole(colorbox,2,2,46,XcoGetObjectHeight(bcmd)-4);
      XcoAddCallback(bcmd,browse_colors);
      XcoSetResizeMethod(colorbox,XcoUpLeftDownRight);
      XcoSetResizeMethod(colorhole,XcoUpLeftDownRight);
      XcoSetResizeMethod(bcmd,XcoUpRight);

      
      label=XcoCreateLabel(decorbox,5,100,"X:",0,0);
      xdialog=XcoCreateDialog(decorbox,35,
			      100,ewindow,"",8,80,0);
      XcoAddCallback(xdialog,dialog_callback);
      XcoSetResizeMethod(label,XcoDownLeft);
      XcoSetResizeMethod(xdialog,XcoDownLeft);

      label=XcoCreateLabel(decorbox,5,125,"Y:",0,0);
      ydialog=XcoCreateDialog(decorbox,35,
			      125,ewindow,"",8,80,0);
      XcoAddCallback(ydialog,dialog_callback);
      XcoSetResizeMethod(label,XcoDownLeft);
      XcoSetResizeMethod(ydialog,XcoDownLeft);
      
      label=XcoCreateLabel(decorbox,5,150,"Z:",0,0);
      zdialog=XcoCreateDialog(decorbox,35,
			      150,ewindow,"",8,80,0);
      XcoAddCallback(zdialog,dialog_callback);
      XcoSetResizeMethod(label,XcoDownLeft);
      XcoSetResizeMethod(zdialog,XcoDownLeft);

      update_lightview();

      acmd=XcoCreateCommand(ewindow,10,WINDOW_HEIGHT-30,"Update",0,0);
      XcoAddCallback(acmd,apply_changes);
      XcoSetResizeMethod(acmd,XcoDownLeft);

      nextlight_button=XcoCreateCommand(ewindow,20+XcoGetObjectWidth(acmd),WINDOW_HEIGHT-30,"Next light",0,0);
      XcoSetResizeMethod(nextlight_button,XcoDownLeft);
      XcoAddCallback(nextlight_button,nextlight_callback);

      addlight_button=XcoCreateCommand(ewindow,
				       10+XcoGetObjectX(nextlight_button)+XcoGetObjectWidth(nextlight_button),
				       WINDOW_HEIGHT-30,"Add light",0,0);
      XcoSetResizeMethod(addlight_button,XcoDownLeft);
      XcoAddCallback(addlight_button,addlight_callback);


      edit_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(ewindow));
    }
}

