/* This is labeldraw.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: labeldraw.c 106 2011-06-08 15:19:24Z daniels $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "Xco.h"
#include "xinterface.h"
#include "ccinterface.h"

static char *FACES[]={"charter","luxi sans","helvetica","arial","hershey",NULL};

static char *EFACE=NULL;

#define NFONTS 500
#define MINSIZE 6
#define MAXSIZE 500
/* Max number of fonts to be loaded at the same time */
#define MAXFONTS 100

static XFontStruct *myfont[NFONTS];
static int font_loaded=0;
static int this_font_loaded[NFONTS];
static int font_height[NFONTS];
static int current_loaded_fonts=0;
static int last_access[NFONTS];

void labeldraw_set_eface(char *fontname)
{
    if (EFACE)
	free(EFACE);
    EFACE=malloc(strlen(fontname)+1);
    strcpy(EFACE,fontname);
}

static void misc_init_font()
{
  int i;
  for (i=0; i<NFONTS; i++)
    {
      this_font_loaded[i]=0;
      last_access[i]=0;
    }
  font_loaded=1;
}

static int size2index(int size)
{
  if (size<MINSIZE)
    size=MINSIZE;
  if (size>MAXSIZE)
    size=MAXSIZE;
  return (((NFONTS-1)*(size-MINSIZE))/(MAXSIZE-MINSIZE));
}

static void load_the_font(int fsize)
{
  char fontstring[100];
  int i=0,j;
  char **FACE;
  int fontdebug=0;
  if (getenv("YMOLFONTDEBUG"))
    fontdebug=1;
  
  if (!font_loaded)
    misc_init_font();
  i=size2index(fsize);
  if (!this_font_loaded[i])
    {
      int size;
      if (current_loaded_fonts>=MAXFONTS)
	{
	  /* Unload last accessed font */
	  int last,lastval=0;
	  for (j=0; j<NFONTS; j++)
	    {
	      if (this_font_loaded[j])
		if (last_access[j]>lastval)
		  {
		    lastval=last_access[j];
		    last=j;
		  }
	    }
	  /* printf("Unloading font %d: %d\n",last,last_access[last]); */
	  XFreeFont(XcoGetDisplay(),myfont[last]);
	  this_font_loaded[last]=0;
	  current_loaded_fonts--;
	}
      size=MINSIZE+((MAXSIZE-MINSIZE)*i)/(NFONTS-1);
      /* printf("Loading font %d: %d\n",i,size); */
      myfont[i]=NULL;
      if (EFACE!=NULL)
      {
	  sprintf(fontstring,"-*-%s-*-r-*-*-%d-*-*-*-*-*-*-*",EFACE,size);
	  myfont[i]=XcoLoadFont(fontstring);
	  if ((!myfont[i]) && (fontdebug))
	    fprintf(stderr,"Failed loading font %s\n",fontstring);
      }
      if (myfont[i]==NULL)
      {
	  FACE=FACES;
	  do {
	      sprintf(fontstring,"-*-%s-*-r-*-*-%d-*-*-*-*-*-*-*",*FACE,size);
	      myfont[i]=XcoLoadFont(fontstring);
	      if ((!myfont[i]) && (fontdebug))
		fprintf(stderr,"Failed loading font %s\n",fontstring);
	      if (myfont[i]==NULL)
		FACE++;
	  } while (*FACE && myfont[i]==NULL);
      }
      if (myfont[i]==NULL)
      {
	  printf("Can't load font %s trying fixed\n",fontstring);
	  myfont[i]=XcoLoadFont("fixed");
	  if (myfont[i]==NULL)
	  {
	      printf("Can't load font fixed\n");
	      exit(1);
	  }
      }
      font_height[i]=XcoTextHeight(myfont[i]);
      this_font_loaded[i]=1;
      current_loaded_fonts++;
    }
  for (j=0; j<NFONTS; j++)
    if (j!=i)
      last_access[j]++;
  last_access[i]=0;
}

void draw_centered_text(int x,int y,char *text,int r,int g,int b,int position,int size)
{
  int i=0;
  int h,w;

  load_the_font(size);
  i=size2index(size);
  h=font_height[i];
  w=XcoTextWidth(myfont[i],text);

  /* left: -1; centered: 0; right: 1 */
  if (position==0)
    x-=w>>1;
  else if (position==1)
    x-=w;
  y-=h>>1;
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XSetFont(XcoGetDisplay(),XcoGC(get_drawbox()),myfont[i]->fid);
  XDrawString(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),x,y+myfont[i]->ascent,text,strlen(text));
}

void draw_centered_image_text(int x,int y,char *text,int r,int g,int b,int r2,int g2,int b2,int position,int size)
{
  int i=0;
  int h,w;

  load_the_font(size);
  i=size2index(size);
  h=font_height[i];
  w=XcoTextWidth(myfont[i],text);

  /* left: -1; centered: 0; right: 1 */
  if (position==0)
    x-=w>>1;
  else if (position==1)
    x-=w;
  y-=h>>1;
  XSetForeground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r,g,b)));
  XSetBackground(XcoGetDisplay(),XcoGC(get_drawbox()),XcoGetPixel32(0,0,PIXEL(r2,g2,b2)));
  XSetFont(XcoGetDisplay(),XcoGC(get_drawbox()),myfont[i]->fid);
  XDrawImageString(XcoGetDisplay(),get_current_draw_pixmap(),XcoGC(get_drawbox()),x,y+myfont[i]->ascent,text,strlen(text));
}

static int pixmap_created=0;
static Pixmap mypixmap;
static GC mygc;
static int pixmap_width,pixmap_height;

void draw_centered_text3d(uint32 *framebuffer,int32 *zbuffer,
			  int xsize,int ysize,
			  int x,int y,int z,char *text,
			  int r1,int g1,int b1,
			  int r2,int g2,int b2,
			  int position,
			  int size,int ybankstart,int ybankend)
{
  int i=0;
  int h,w,time;
  int forepixel,backpixel;
  int nlabel=1;
  XImage *myimage;

  if ((r1==r2) &&
      (g1==g2) &&
      (b1==b2))
      nlabel=0;

  load_the_font(size);
  i=size2index(size);
  h=font_height[i];
  w=XcoTextWidth(myfont[i],text);
  if ((w>0) && (h>0))
    {
      /* left: -1; centered: 0; right: 1 */
      if (position==0)
	x-=w>>1;
      else if (position==1)
	x-=w;
      y-=h>>1;
      if (!pixmap_created)
	{
	  unsigned long valuemask=0;
	  XGCValues xgcvalues;
#if 0
	  printf("Creating pixmap: %d,%d, '%s'\n",w,h,text);
#endif
	  mypixmap=XCreatePixmap(XcoGetDisplay(),XcoWindow(get_drawbox()),w,h,
				 XcoGetDepth());
	  pixmap_width=w;
	  pixmap_height=h;
	  mygc=XCreateGC(XcoGetDisplay(),XcoWindow(get_drawbox()),valuemask,&xgcvalues);
	  pixmap_created=1;
	}
      else
	{
	  if ((w>pixmap_width)||(h>pixmap_height))
	    {
#if 0
	      printf("Freeing pixmap %d,%d\n",pixmap_width,pixmap_height);
#endif
	      XFreePixmap(XcoGetDisplay(),mypixmap);
	      if (w>pixmap_width)
		pixmap_width=w;
	      if (h>pixmap_height)
		pixmap_height=h;
#if 0
	      printf("Creating pixmap %d,%d\n",pixmap_width,pixmap_height);
#endif
	      mypixmap=XCreatePixmap(XcoGetDisplay(),XcoWindow(get_drawbox()),
				     pixmap_width,pixmap_height,
				     XcoGetDepth());
	    }
	}

      forepixel=XcoGetPixel32(0,0,PIXEL(0,0,0));
      backpixel=XcoGetPixel32(0,0,PIXEL(255,255,255));
      XSetForeground(XcoGetDisplay(),mygc,forepixel);
      XSetBackground(XcoGetDisplay(),mygc,backpixel);
      XSetFont(XcoGetDisplay(),mygc,myfont[i]->fid);
      XDrawImageString(XcoGetDisplay(),mypixmap,mygc,0,myfont[i]->ascent,text,strlen(text));
      myimage=XGetImage(XcoGetDisplay(),mypixmap,0,0,w,h,0xffffffff,ZPixmap);
      for (time=0; time<=nlabel; time++)
	{
	  int col; 
	  int ydiff=-2*time;
	  int xdiff=-2*time;
	  int yl,ydraw,ypos,xl,xdraw,p;
	  if (time==0)
	    col=PIXEL(r1,g1,b1);
	  else
	    col=PIXEL(r2,g2,b2);
	  for (yl=0; yl<h; yl++)
	    {    
	      ydraw=yl+y-ybankstart+ydiff;
	      if ((ydraw>=0) && (ydraw<=(ybankend-ybankstart)))
		{
		  ypos=ydraw*xsize;
		  for (xl=0; xl<w; xl++)
		    {
		      xdraw=xl+x+xdiff;
		      if ((xdraw>=0) && (xdraw<xsize))
			{
			  p=XGetPixel(myimage,xl,yl);
			  if (p==forepixel)
			    {
			      int pixpos=ypos+xdraw;
			      if (z>=zbuffer[pixpos])
				{
				  zbuffer[pixpos]=z;
				  framebuffer[pixpos]=(uint32) col;
				}
			    }
			}
		    }
		}
	    }
	}
      XDestroyImage(myimage);
    }
}


void draw_pin3d(uint32 *framebuffer,int32 *zbuffer,int xsize,int ysize,
		int x,int y,int z,char *text,
		int position,
		int size, int ybankstart,int ybankend)
{
  int forepixel,backpixel,colorbase,nshine;
  double vecx,vecy,vecz;
  double lightbase;
  XImage *myimage;
  int i=0;
  int h,w;
  int basecolor,topcolor,leftcolor,bottomcolor,rightcolor,fullwidth,fullheight;
  int yl,ydraw,ypos,xl,xdraw,pixpos;

  load_the_font(size);
  i=size2index(size);
  h=font_height[i];
  w=XcoTextWidth(myfont[i],text);
  /* left: -1; centered: 0; right: 1 */
  if (position==0)
    x-=w>>1;
  else if (position==1)
    x-=w;
  y-=h>>1;
  if (!pixmap_created)
    {
      unsigned long valuemask=0;
      XGCValues xgcvalues;
      /* printf("Creating pixmap\n"); */
      mypixmap=XCreatePixmap(XcoGetDisplay(),XcoWindow(get_drawbox()),w,h,
			     XcoGetDepth());
      pixmap_width=w;
      pixmap_height=h;
      mygc=XCreateGC(XcoGetDisplay(),XcoWindow(get_drawbox()),valuemask,&xgcvalues);
      pixmap_created=1;
    }
  else
    {
      if ((w>pixmap_width)||(h>pixmap_height))
	{
	  /* printf("Freeing pixmap %d,%d\n",pixmap_width,pixmap_height); */
	  XFreePixmap(XcoGetDisplay(),mypixmap);

	  if (w>pixmap_width)
	    pixmap_width=w;
	  if (h>pixmap_height)
	    pixmap_height=h;
	  /* printf("Creating pixmap %d,%d\n",pixmap_width,pixmap_height); */
	  mypixmap=XCreatePixmap(XcoGetDisplay(),XcoWindow(get_drawbox()),
				 pixmap_width,pixmap_height,
				 XcoGetDepth());
	}
    }

  forepixel=XcoGetPixel32(0,0,PIXEL(0,0,0));
  backpixel=XcoGetPixel32(0,0,PIXEL(255,255,255));
  XSetForeground(XcoGetDisplay(),mygc,forepixel);
  XSetBackground(XcoGetDisplay(),mygc,backpixel);
  XSetFont(XcoGetDisplay(),mygc,myfont[i]->fid);
  XDrawImageString(XcoGetDisplay(),mypixmap,mygc,0,myfont[i]->ascent,text,strlen(text));
  myimage=XGetImage(XcoGetDisplay(),mypixmap,0,0,w,h,0xffffffff,ZPixmap);
  colorbase=200;
  lightbase=0.7;
  nshine=20;

  vecx=0.; vecy=0.; vecz=1.;

  basecolor=pcolor_(&colorbase,&colorbase,&colorbase,
			&lightbase,&lightbase,&lightbase,&nshine,
			&vecx,&vecy,&vecz);
  vecx=0.; vecy=-1.; vecz=1.;
  topcolor=pcolor_(&colorbase,&colorbase,&colorbase,
		       &lightbase,&lightbase,&lightbase,&nshine,
		       &vecx,&vecy,&vecz);
  vecx=-1.; vecy=0.; vecz=1.;
  leftcolor=pcolor_(&colorbase,&colorbase,&colorbase,
			&lightbase,&lightbase,&lightbase,&nshine,
			&vecx,&vecy,&vecz);
  vecx=0.; vecy=1.; vecz=1.;
  bottomcolor=pcolor_(&colorbase,&colorbase,&colorbase,
			  &lightbase,&lightbase,&lightbase,&nshine,
			  &vecx,&vecy,&vecz);
  vecx=1.; vecy=0.; vecz=1.;
  rightcolor=pcolor_(&colorbase,&colorbase,&colorbase,
			 &lightbase,&lightbase,&lightbase,&nshine,
			 &vecx,&vecy,&vecz);
  fullwidth=w+4;
  fullheight=h+4;


  for (yl=0; yl<fullheight; yl++)
    {    
      ydraw=yl+y-ybankstart;
      if ((ydraw>=0) && (ydraw<=(ybankend-ybankstart)))
	{
	  ypos=ydraw*xsize;
	  for (xl=0; xl<fullwidth; xl++)
	    {
	      xdraw=xl+x;
	      if ((xdraw>=0) && (xdraw<xsize))
		{
		  pixpos=ypos+xdraw;
		  if (z>=zbuffer[pixpos])
		    {
		      int ucolor=basecolor;
		      zbuffer[pixpos]=z;
		      if ((xl<2) && ((yl>1) || (yl<(fullheight-1))))
			{
			  /* left */
			  ucolor=leftcolor;
			}
		      else if ((xl>(fullwidth-3)) && ((yl>1) || (yl<(fullheight-1))))
			{
			  /* right */
			  ucolor=rightcolor;
			}
		      else if (yl<2)
			{
			  /* top */
			  ucolor=topcolor;
			}
		      else if (yl>(fullheight-3))
			{
			  /* bottom */
			  ucolor=bottomcolor;
			}
		      else
			{
			  /* test for text */
			  int p=XGetPixel(myimage,xl-2,yl-2);
			  if (p==forepixel)
			    ucolor=0;
			}
		      framebuffer[pixpos]=(uint32) ucolor;
		    }
		}
	    }
	}
    }
  XDestroyImage(myimage);
}
