/* This is fstring.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: fstring.c 128 2013-12-18 07:03:36Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "Xco.h"
#include "atomlabel.h"
#include "draw_primitives.h"
#include "labeldraw.h"
#include "userinterface.h"
#include "povraywrite.h"
#include "errorhandler.h"

/* this file contains all functions that call fortran subroutines passing
   strings, since this may differ between platforms */

#ifdef FSTRINGPASS1
void fload_(char *filename,int *ok,int len);
void floads_(char *filename,int *ok,int len);
void fsave_(char *filename,int len);
void fsaves_(char *filename,int len);
void fimp_(char *filename,int len);
void sfimp_(char *filename,int len);
void psave_(char *filename,double *cshift,int len);
void fsorif_(char *filename,int len);
void florif_(char *filename,int *ok,int len);
#endif

void fload_orientation_file(char *filename,int *ok)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  florif_(filename,ok,flen);
#endif
}

void fsave_orientation_file(char *filename)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  fsorif_(filename,flen);
#endif
}

void fload_file(char *filename,int *ok)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  fload_(filename,ok,flen);
#endif
}

void fload_file_style(char *filename,int *ok)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  floads_(filename,ok,flen);
#endif
}

void fsave_file(char *filename)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  fsave_(filename,flen);
#endif
}

void fsave_style_file(char *filename)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  fsaves_(filename,flen);
#endif
}

void fimport_file(char *filename)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  fimp_(filename,flen);
#endif
}

void sfimport_file(char *filename)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  sfimp_(filename,flen);
#endif
}

/* string passing */

static char *strptr;
static int strl;

#ifdef FSTRINGPASS1
void fpstr_(char *str,int len)
{
  strptr=str;
  strl=len;
  *(strptr+strl)='\0';
}
#endif

char *getfstr()
{
  return strptr;
}

#ifdef FSTRINGPASS1
int ixcopw_(char *str,int len)
{
  int i;
  char *s=malloc((len+1));
  memcpy(s,str,len);
  *(s+len)='\0';
  i= XcoCreateProgressWindow(s);
  free( s);
  return i;
}
#endif

#ifdef FSTRINGPASS1
void galbl_(int *i,char *str,int len)
{
  get_atomlabel(*i,str);
}
#endif

#ifdef FSTRINGPASS1
void fscs_(char *s, int len)
{
  int i=len-1;
  while ((i>0) && ((s[i-1]==' ') || (s[i-1]==0)))
    i--;
  s[i]='\0';
}
#endif

#ifdef FSTRINGPASS1
void dtxt_(int *x,int *y,char *str,int *r,int *g,int *b,int *position,int *size,int len)
{
  char *s=malloc((len+1));
  memcpy(s,str,len);
  fscs_(s,len+1);
  draw_centered_text(*x,*y,s,*r,*g,*b,*position,*size);
  free( s);
}
#endif

#ifdef FSTRINGPASS1
void ditxt_(int *x,int *y,char *str,int *r,int *g,int *b,int *r2,int *g2,int *b2,int *position,int *size,int len)
{
  char *s=malloc((len+1));
  memcpy(s,str,len);
  fscs_(s,len+1);
  draw_centered_image_text(*x,*y,s,*r,*g,*b,*r2,*g2,*b2,*position,*size);
  free( s);
}
#endif

#ifdef FSTRINGPASS1
void dtxt3d_(uint32 *framebuffer,int *zbuffer,int *xsize,int *ysize,
	     int *x,int *y,int *z,char *str,
	     int *r1,int *g1,int *b1,
	     int *r2,int *g2,int *b2,
	     int *position,
	     int *size,int *ybankstart,int *ybankend,int len)
{
  char *s=malloc((len+1));
  memcpy(s,str,len);
  fscs_(s,len+1);
  draw_centered_text3d(framebuffer,zbuffer,*xsize,*ysize,
		       *x,*y,*z,s,
		       *r1,*g1,*b1,
		       *r2,*g2,*b2,
		       *position,
		       *size,*ybankstart,*ybankend);
  free( s);
}
#endif

#ifdef FSTRINGPASS1
void dpin3d_(uint32 *framebuffer,int *zbuffer,int *xsize,int *ysize,
	     int *x,int *y,int *z,char *str,
	     int *position,
	     int *size,int *ybankstart,int *ybankend,int len)
{
  char *s=malloc((len+1));
  memcpy(s,str,len);
  fscs_(s,len+1);
  draw_pin3d(framebuffer,zbuffer,*xsize,*ysize,
	     *x,*y,*z,s,
	     *position,
	     *size,*ybankstart,*ybankend);
  free( s);
}
#endif

void mdela_(int *frame,int *atomid, int *natoms);

void modify_delete_atoms(int frame,int *atomid, int natoms)
{
  mdela_(&frame,atomid,&natoms);
}

#ifdef FSTRINGPASS1
void esela_(int *frame,int *frame2, int *atomid, int *natoms,char *filename, int len);

void export_selected_atoms(int frame, int frame2, int *atomid, int natoms, char *filename)
{
  esela_(&frame,&frame2,atomid,&natoms,filename,strlen(filename));
}
#endif

void mdelb_(int *frame,int *atomid1,int *atomid2, int *nbonds);

void modify_delete_bonds(int frame,int *atomid1,int *atomid2, int nbonds)
{
  mdelb_(&frame,atomid1,atomid2,&nbonds);
}

void mbpro_(int *frame,int *atomid1,int *atomid2, int *nbonds,int *color_r,int *color_g,int *color_b,double *rad, int *islice);

void modify_bond_properties(int frame,int *atomid1,int *atomid2, int nbonds,int color_r,int color_g,int color_b, double rad, int slice)
{
  mbpro_(&frame,atomid1,atomid2,&nbonds,&color_r,&color_g,&color_b,&rad,&slice);
}

void macol_(int *frame,int *atomid,int *natoms,int *color_r,int *color_g,int *color_b);

void modify_atom_color(int frame,int *atomid, int natoms,int color_r,int color_g,int color_b)
{
  macol_(&frame,atomid,&natoms,&color_r,&color_g,&color_b);
}

void madst_(int *frame,int *atomid,int *natoms,int *style);

void modify_atom_drawstyle(int frame,int *atomid, int natoms,int style)
{
  madst_(&frame,atomid,&natoms,&style);
}

void madrsv_(int *frame,int *atomid,int *natoms,double *rsv);

void modify_atom_rsv(int frame,int *atomid, int natoms,double rsv)
{
    madrsv_(&frame,atomid,&natoms,&rsv);
}

void madpn_(int *frame,int *atomid,int *natoms,int *n);

void modify_atom_n(int frame,int *atomid, int natoms,int n)
{
    madpn_(&frame,atomid,&natoms,&n);
}

#ifdef FSTRINGPASS1
void madlbl_(int *frame,int *atomid,int *natoms,int *idflt,char *label,int length);

void modify_atom_label(int frame,int *atomid, int natoms,char *label)
{
    int idflt=0,ilen=strlen(label);
    if (ilen==0)
    {
	idflt=1;
	ilen=1; /* Don't know if fortran really likes strings with length 0 */
    }
    madlbl_(&frame,atomid,&natoms,&idflt,label,ilen);
}
#endif

void mcreb_(int *frame,int *atomnr);

void modify_create_bonds(int frame,int atomnr)
{
  mcreb_(&frame,&atomnr);
}

#ifdef FSTRINGPASS1
void bname_(int *item,char *s,int len);
#endif

void bondrulename(int item,char *s)
{
#ifdef FSTRINGPASS1  
  bname_(&item,s,64);
#endif
  fscs_(s,64);
}

#ifdef FSTRINGPASS1
void sbname_(int *item,char *s,int len);
#endif

void set_bondrulename(int item,char *s)
{
#ifdef FSTRINGPASS1  
  sbname_(&item,s,64);
#endif
}

#ifdef FSTRINGPASS1
int islen_(char *str,int len)
{
  int i;
  char *strn=malloc((len+1));
  memcpy(strn,str,len);
  fscs_(strn,len+1);
  i=strlen(strn);
  free( strn);
  return i;
}
#endif

#ifdef FSTRINGPASS1
void errmsg_(char *str,int len)
{
  char *strn=malloc((len+1));
  memcpy(strn,str,len);
  strn[len]='\0';
  show_error_message(strn);
  free( strn);
}
#endif

void upderr_()
{
  update_error_message_box();
}

void povray_save(char *filename, double cshift)
{
#ifdef FSTRINGPASS1
  int flen=strlen(filename);
  psave_(filename,&cshift,flen);
#endif
}

#ifdef FSTRINGPASS1
void povini_(char *filename,int *pass,double *xc,double *yc,double *zc,double *cshift,int len)
{
  char *strn=malloc((len+1));
  memcpy(strn,filename,len);
  fscs_(strn,len+1);
  povray_init_scene(strn,*pass,*xc,*yc,*zc,*cshift);  
  free( strn);
}
#endif

void povwb_(const double *x1,const double *y1,const double *z1,
	   const double *x2,const double *y2,const double *z2,
	   const double *radius,const int *r,const int *g,const int *b)
{
  povray_write_bond(*x1,*y1,*z1,*x2,*y2,*z2,*radius,*r,*g,*b);
}

void povwtr_(const double *x1,const double *y1,const double *z1,
	     const double *x2,const double *y2,const double *z2,
	     const double *x3,const double *y3,const double *z3,
	     const double *nx1,const double *ny1,const double *nz1,
	     const double *nx2,const double *ny2,const double *nz2,
	     const double *nx3,const double *ny3,const double *nz3,
	     const int *r,const int *g,const int *b,const double *opacity)
{
  povray_write_triangle(*x1,*y1,*z1,*x2,*y2,*z2,*x3,*y3,*z3,
			*nx1,*ny1,*nz1,*nx2,*ny2,*nz2,*nx3,*ny3,*nz3,
			*r,*g,*b,*opacity);
}

void povwa_(const double *x1,const double *y1,const double *z1,
	    const double *radius,const int *r,const int *g,const int *b)
{
  povray_write_atom(*x1,*y1,*z1,*radius,*r,*g,*b);
}

void povwt_(const double *x1,const double *y1,const double *z1,
	    const double *radius,const int *r,const int *g,const int *b,const char *text,int len)
{
  char *strn=malloc((len+1));
  memcpy(strn,text,len);
  fscs_(strn,len+1);
  povray_write_text(*x1,*y1,*z1,*radius,*r,*g,*b,strn);
  free( strn);
}

void povwls_(const double *x1,const double *y1,const double *z1,
			       const int *r,const int *g,const int *b)
{
  povray_write_light_source(*x1,*y1,*z1,*r,*g,*b);
}

void povwbg_(const int *r,const int *g,const int *b)
{
  povray_write_background_light(*r,*g,*b);
}

void povfin_()
{
  povray_finish_scene();
}


/* UNIX File management */
#ifdef FSTRINGPASS1
int ifren_(char *str1,char *str2,int len1,int len2)
{
  int i;
  char *s1=malloc((len1+1));
  char *s2=malloc((len2+1));
  memcpy(s1,str1,len1);
  *(s1+len1)='\0';
  memcpy(s2,str2,len2);
  *(s2+len2)='\0';
#if 0
  printf("ifren finds oldfile to be %s and newfile to be %s\n",
	 s1,s2);
  printf("with length: %d,%d\n",len1,len2);
#endif
  i=rename(s1,s2);
  free( s1);
  free( s2);
  return i;
}
/* Get global style filename */
void ggstf_(char *str1,int len)
{
  char *home=getenv("HOME");
  char *gname;
  int i;
  int mylen=strlen(home)+17;
  gname=malloc(mylen+1);
  strcpy(gname,home);
  strcat(gname,"/.ymol/style.ymol");
  memcpy(str1,gname,mylen);
  for (i=mylen; i<len; i++)
    str1[i]=' ';
  free(gname);
}
#endif
