/* This is bondrules.c
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: bondrules.c 121 2013-09-22 19:16:33Z daniels $";


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "Xco.h"

#include "defaults.h"
#include "ccinterface.h"
#include "fstring.h"
#include "atomlabel.h"
#include "periodic_table.h"
#include "register_update.h"

#define WINDOW_WIDTH 330
#define WINDOW_HEIGHT 250

static int bond_rules_open=0;
static XcoObject top_window,decorbox;
static XcoObject list;

static char **list_items;
static int list_no;

#define ADD_WINDOW_WIDTH 400
#define ADD_WINDOW_HEIGHT 300

static int add_rule_open=0;
static XcoObject add_window,namedialog,add_decorbox,
  donordialog,acceptordialog,flexdialog,colorhole,bradiusdialog,vdwtoggle,slicetoggle;

static Pixmap colorpixmap;
static int colorpixmap_exist=0;
static int use_default_color;
static int current_item;
static int delete_if_cancel;

static int open_bcolor=0;
static int browse_pixel; 
static XcoObject colsel;
static int virgin=1;

static void close_add_rule_window()
{
  XcoDeleteObject(add_window);
  add_rule_open=0;
  if (open_bcolor)
    {
      XcoDeleteObject(colsel);
      open_bcolor=0;
    }
}

/* Create donor/acceptor string */
static void donoracceptorstring(int item,int donor,char *s)
{
  int sptr=0;
  int istr=0;
  if (donor)
    istr=ndon_(&item);
  else
    istr=nacc_(&item);
  if (istr==0)
    {
      sprintf(s,"All");
    }
  else
    {
      int i;
      for (i=1; i<=istr; i++)
	{
	  int inum;
	  int lblp=0;
	  char lbl[4];
	  if (donor)
	    inum=donor_(&item,&i);
	  else
	    inum=accept_(&item,&i);

	  get_atomlabel(inum,lbl);

	  while (lbl[lblp]!='\0')
	    s[sptr++]=lbl[lblp++];
	  if (i!=istr)
	    s[sptr++]=' ';
	}
      s[sptr++]='\0';
    }
}      

/* Analyze and set donor/acceptor string */
static void set_donoracceptor(int item,int donor,char *s)
{
  int sptr=0;
  int istr=0;
  int ilen=strlen(s);
  int anum=1;

  char aname[4];
  int wptr=0;
  while (sptr<ilen)
    {
      char lbl[4];
      /* remove spaces */
      while ((sptr<ilen) && (s[sptr]==' '))
	sptr++;
      
      while ((sptr<ilen) && (wptr<3) && (s[sptr]!=' '))
        {
	  aname[wptr++]=s[sptr++];
	}
      aname[wptr]='\0';
      /*  printf("Found: '%s'\n",aname); */


      get_atomlabel(anum,lbl);
      while ((anum<N_ATOMS) && (strcmp(lbl,aname)!=0))
	{
	  anum++;
	  get_atomlabel(anum,lbl);
	}
      if (strcmp(lbl,aname)==0)
	{
	  istr++;
	  if (donor)
	    sdonor_(&item,&istr,&anum);
	  else
	    sacc_(&item,&istr,&anum);
	}
      else
	{
	  /* printf("Error\n"); */
	}
      wptr=0;
    }
  if (donor)
    sndon_(&item,&istr);
  else
    snacc_(&item,&istr);
}      

static void dbrowse(int *alist)
{
  int i;
  int n=alist[0];
  sndon_(&current_item,&n);
  
  for (i=1; i<=n; i++)
    {
      sdonor_(&current_item,&i,&alist[i]);
    }
  if (add_rule_open)
    {
      char dnr[40];
      donoracceptorstring(current_item,1,dnr);
      XcoSetDialogValue(donordialog,dnr);
    }
}

static void abrowse(int *alist)
{
  int i;
  int n=alist[0];
  snacc_(&current_item,&n);
  for (i=1; i<=n; i++)
    {
      sacc_(&current_item,&i,&alist[i]);
    }
  if (add_rule_open)
    {
      char dnr[40];
      donoracceptorstring(current_item,0,dnr);
      XcoSetDialogValue(acceptordialog,dnr);
    }
}

static void browse_donors(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int istr;
      int *ilist;
      set_donoracceptor(current_item,1,XcoGetDialogValue(donordialog));

      istr=ndon_(&current_item);

      if (istr==0)
	{
	  ilist=NULL;
	}
      else
	{
	  int i;
	  ilist=malloc(sizeof( int)*(istr));
	  for (i=1; i<=istr; i++)
	    ilist[i-1]=donor_(&current_item,&i);
	}

      open_periodic_table("Select donor atoms",dbrowse,10,ilist,istr);
      if (ilist!=NULL)
	free( ilist);
    }
}

static void browse_acceptors(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int istr;
      int *ilist;
      set_donoracceptor(current_item,0,XcoGetDialogValue(acceptordialog));
      istr=nacc_(&current_item);

      if (istr==0)
	{
	  ilist=NULL;
	}
      else
	{
	  int i;
	  ilist=malloc(sizeof( int)*(istr));
	  for (i=1; i<=istr; i++)
	      ilist[i-1]=accept_(&current_item,&i);
	}

      open_periodic_table("Select acceptor atoms",abrowse,10,ilist,istr);
      if (ilist!=NULL)
	free( ilist);
    }
}

static void set_colorpixmap(unsigned int pixel)
{
  int i;
  unsigned int image[16];
  browse_pixel=pixel;
  if (colorpixmap_exist)
    XFreePixmap(XcoGetDisplay(),colorpixmap);

  for (i=0; i<16; i++)
    image[i]=pixel;
  colorpixmap=XcoCreatePixmapFromImage(colorhole,image,4,4);
  XcoSetBackgroundPixmap(colorhole,colorpixmap,True);
}

static void use_color(int r,int g,int b,int ok)
{
  if (add_rule_open)
    if (ok)
      {
	set_colorpixmap(PIXEL(r,g,b));
      }
}

static void dcolsel(XcoObject dummy,XEvent event)
{
  if (event.type==DestroyNotify)
    {
      printf("The color selector object was destroyed\n");
      open_bcolor=0;
    }
}

static void browse_colors(XcoObject dummy,XEvent event)
{
  if (add_rule_open)
    {
      if (event.type==ButtonPress)
	{
	  if (!open_bcolor)
	    {
	      colsel=XcoColorselector(R_OF_PIXEL(browse_pixel),
				      G_OF_PIXEL(browse_pixel),
				      B_OF_PIXEL(browse_pixel),
				      use_color);
	      XcoAddCallback(colsel,dcolsel);
	      open_bcolor=1;
	    }
	}
    }
}

static void make_list()
{
  list_no=nbrule_();
  if (list_no>0)
    {
      int i;
      list_items=malloc(sizeof( char*)*(list_no));
      for (i=1; i<=list_no;i++)
	{
	  list_items[i-1]=malloc(sizeof( char)*(64));
	  bondrulename(i,list_items[i-1]);
	}
    }
  else
    list_items=NULL;
}

static void delete_list()
{
  if (list_no>0)
    {
      int i;
      for (i=1; i<=list_no; i++)
	{
	  free( list_items[i-1]);
	}
      free( list_items);
      list_no=0;
      list_items=NULL;
    }
}


static void okbutton_callback(XcoObject dummy, XEvent event)
{
  if (event.type==ButtonPress)
    {
      double dv;
      int iv;
      char dval[64];
      strcpy(dval,XcoGetDialogValue(namedialog));
      set_bondrulename(current_item,dval);
      set_donoracceptor(current_item,1,XcoGetDialogValue(donordialog));
      set_donoracceptor(current_item,0,XcoGetDialogValue(acceptordialog));
      dv=strtod(XcoGetDialogValue(flexdialog),NULL);
      sfuzzb_(&current_item,&dv);
      scol_(&current_item,&browse_pixel);
      dv=strtod(XcoGetDialogValue(bradiusdialog),NULL);
      sbrrad_(&current_item,&dv);
      iv=XcoGetToggleSelected(vdwtoggle);
      sivdw_(&current_item,&iv);
      iv=XcoGetToggleSelected(slicetoggle);
      sbrns_(&current_item,&iv);
      
      delete_list();
      make_list();
      XcoSetListData(list,list_items,list_no);
      close_add_rule_window();
    }
}

static void cancelbutton_callback(XcoObject dummy, XEvent event)
{
  if (event.type==ButtonPress)
    {
      if (delete_if_cancel)
	delbr_(&current_item);
      delete_list();
      make_list();
      XcoSetListData(list,list_items,list_no);
      close_add_rule_window();
    }
}

static void add_delete_window(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      if (delete_if_cancel)
	delbr_(&current_item);
      delete_list();
      make_list();
      XcoSetListData(list,list_items,list_no);
      close_add_rule_window();
    }
}

void modify_bondrule(int item,char *wname,char *okbuttonname)
{
  if (!add_rule_open)
    {
      XcoObject hole,hole2,hole3,label,bcmd,colorbox,icol,cancelbutton,okbutton;
      int xpos,ypos;
      char name[64];
      char dnr[40];
      char acptr[40];
      char flexs[5];
      char rads[5];
      current_item=item;
      use_default_color=1;
      add_window=XcoCreateNamedDialogParent(-1,0,0,ADD_WINDOW_WIDTH,ADD_WINDOW_HEIGHT,wname);

      XcoAddCallback(add_window,add_delete_window);

      add_decorbox=XcoCreateBox3D(add_window,5,5,ADD_WINDOW_WIDTH-10,ADD_WINDOW_HEIGHT-45,2,1);

      hole=XcoCreateHole(add_decorbox,5,5,ADD_WINDOW_WIDTH-20,40);
      hole2=XcoCreateHole(hole,0,0,ADD_WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Name",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);

      bondrulename(item,name);
      namedialog=XcoCreateDialog(hole2,0,ypos,add_window,name,63,ADD_WINDOW_WIDTH-20,0);

      hole=XcoCreateHole(add_decorbox,5,45,ADD_WINDOW_WIDTH-20,40);
      hole2=XcoCreateHole(hole,0,0,ADD_WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Donors",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      hole3=XcoCreateHole(hole2,0,ypos,ADD_WINDOW_WIDTH-20,50-ypos);
      XcoSetResizeMethod(hole3,XcoUpResize);

      donoracceptorstring(item,1,dnr);
      donordialog=XcoCreateDialog(hole3,0,0,add_window,dnr,30,ADD_WINDOW_WIDTH-100,0);
      bcmd=XcoCreateCommand(hole3,ADD_WINDOW_WIDTH-90,0,"Browse",0,0);
      XcoAddCallback(bcmd,browse_donors);
      XcoSetResizeMethod(donordialog,XcoUpLeftDownRight);
      XcoSetResizeMethod(bcmd,XcoUpRight);

      hole=XcoCreateHole(add_decorbox,5,85,ADD_WINDOW_WIDTH-20,40);
      hole2=XcoCreateHole(hole,0,0,ADD_WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Acceptors",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      hole3=XcoCreateHole(hole2,0,ypos,ADD_WINDOW_WIDTH-20,50-ypos);
      XcoSetResizeMethod(hole3,XcoUpResize);

      donoracceptorstring(item,0,acptr);
      acceptordialog=XcoCreateDialog(hole3,0,0,add_window,acptr,30,ADD_WINDOW_WIDTH-100,0);
      bcmd=XcoCreateCommand(hole3,ADD_WINDOW_WIDTH-90,0,"Browse",0,0);
      XcoAddCallback(bcmd,browse_acceptors);
      XcoSetResizeMethod(acceptordialog,XcoUpLeftDownRight);
      XcoSetResizeMethod(bcmd,XcoUpRight);

      hole=XcoCreateHole(add_decorbox,5,125,ADD_WINDOW_WIDTH-20,40);
      hole2=XcoCreateHole(hole,0,0,ADD_WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Distance criterion",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      sprintf(flexs,"%4.2f",fuzzb_(&item));
      flexdialog=XcoCreateDialog(hole2,0,ypos,add_window,flexs,4,80,0);
      xpos=XcoGetObjectWidth(label)+30;
      vdwtoggle=XcoCreateToggle(hole2,xpos,ypos,10,10,PIXEL(255,0,0),1,ivdw_(&item));
      XcoCreateLabel(hole2,xpos+20,ypos,"Distance between \"electrons\"",0,0);


      hole=XcoCreateHole(add_decorbox,5,165,ADD_WINDOW_WIDTH-20,40);
      hole2=XcoCreateHole(hole,0,0,ADD_WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Bond color",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      hole3=XcoCreateHole(hole2,0,ypos,ADD_WINDOW_WIDTH-20,50-ypos);
      XcoSetResizeMethod(hole3,XcoUpResize);
      bcmd=XcoCreateCommand(hole3,60,0,"Browse",0,0);
      colorbox=XcoCreateBox3D(hole3,0,0,50,XcoGetObjectHeight(bcmd),0,1);
      colorhole=XcoCreateHole(colorbox,2,2,46,XcoGetObjectHeight(bcmd)-4);
      XcoAddCallback(bcmd,browse_colors);
      XcoSetResizeMethod(colorbox,XcoUpLeftDownRight);
      XcoSetResizeMethod(colorhole,XcoUpLeftDownRight);
      XcoSetResizeMethod(bcmd,XcoUpRight);
      
      icol=col_(&item);
      if (icol==-1)
	set_colorpixmap(PIXEL(BOND_DEFAULT_R,BOND_DEFAULT_G,BOND_DEFAULT_B));
      else
	set_colorpixmap(icol);

      hole=XcoCreateHole(add_decorbox,5,205,ADD_WINDOW_WIDTH-20,40);
      hole2=XcoCreateHole(hole,0,0,ADD_WINDOW_WIDTH-20,50);
      XcoSetResizeMethod(hole2,XcoUpResize);
      label=XcoCreateLabel(hole2,0,0,"Bond radius",0,0);
      XcoSetResizeMethod(label,XcoUpLeft);
      ypos=XcoGetObjectHeight(label);
      sprintf(rads,"%4.2f",brrad_(&item));
      bradiusdialog=XcoCreateDialog(hole2,0,ypos,add_window,rads,4,80,0);
      slicetoggle=XcoCreateToggle(hole2,30+XcoGetObjectWidth(label),0,10,10,PIXEL(255,0,0),1,brns_(&item));
      XcoCreateLabel(hole2,50+XcoGetObjectWidth(label),0,"Slice bond",0,0);

      okbutton=XcoCreateCommand(add_window,10,
				ADD_WINDOW_HEIGHT-30,okbuttonname,0,0);
      XcoSetResizeMethod(okbutton,XcoDownLeft);
      XcoAddCallback(okbutton,okbutton_callback);

      xpos=20+XcoGetObjectWidth(okbutton);
      cancelbutton=XcoCreateCommand(add_window,xpos,
					      ADD_WINDOW_HEIGHT-30,
					      "Cancel",0,0);
      XcoSetResizeMethod(cancelbutton,XcoDownLeft);
      XcoAddCallback(cancelbutton,cancelbutton_callback);



      add_rule_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(add_window));
    }
}

static void add_bondrule()
{
  if (!add_rule_open)
    {
      delete_if_cancel=1;
      modify_bondrule(addbr_(),"Add bondrule","Add");
      delete_list();
      make_list();
      XcoSetListData(list,list_items,list_no);
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(add_window));
    }
}

static void bond_delete_window(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      if (!add_rule_open)
	{
	  XcoDeleteObject(top_window);
	  delete_list();
	  bond_rules_open=0;
	}
    }
}

static void bond_add(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      add_bondrule();
    }
}

static void bond_modify(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int status=XcoGetListStatus(list);
      if (status!=-1)
	{
	  if (!add_rule_open)
	    {
	      delete_if_cancel=0;
	      modify_bondrule(status+1,"Modify bondrule","Modify");
	    }
	}
    }
}

static void bond_apply(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      mabr_();
      wupd_();
    }
}

static void bond_apply_frame(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int frame,nframes;
      gframe_(&frame,&nframes);
      mabrf_(&frame);
      wupd_();
    }
}

static void bond_delete(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int status=XcoGetListStatus(list);
      if (status!=-1)
	{
	  if (!add_rule_open)
	    {
	      int item=status+1;
	      delbr_(&item);
	      delete_list();
	      make_list();
	      XcoSetListData(list,list_items,list_no);
	    }
	}
    }
}

static void bond_up(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int status=XcoGetListStatus(list);
      if (status!=-1)
	{
	  if (!add_rule_open)
	    {
	      int item=status+1;
	      brup_(&item);
	      delete_list();
	      make_list();
	      XcoSetListData(list,list_items,list_no);
	    }
	}
    }
}

static void bond_down(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int status=XcoGetListStatus(list);
      if (status!=-1)
	{
	  if (!add_rule_open)
	    {
	      int item=status+1;
	      brdown_(&item);
	      delete_list();
	      make_list();
	      XcoSetListData(list,list_items,list_no);
	    }
	}
    }
}

static void update_em()
{
  if (add_rule_open)
    close_add_rule_window();    
  if (bond_rules_open)
    {
      delete_list();
      make_list();
      XcoSetListData(list,list_items,list_no);
    }
}

void bond_rules()
{
  if (!bond_rules_open)
    {
      XcoObject apply,apply2,add,modify,del,up,down;
      int xpos;
      if (virgin)
	{
	  register_update_function(update_em);
	  virgin=0;
	}
      make_list();
  
      top_window=XcoCreateNamedWindow(0,0,WINDOW_WIDTH,WINDOW_HEIGHT,DEFAULT_BACKGROUND,1,-1,"Bond rules");
      XcoAddCallback(top_window,bond_delete_window);
      decorbox=XcoCreateBox3D(top_window,5,5,WINDOW_WIDTH-10,WINDOW_HEIGHT-75,2,1);
      list=XcoCreateList(decorbox,5,5,WINDOW_WIDTH-20,WINDOW_HEIGHT-90,
			 20,list_items,list_no);
      XcoSetResizeMethod(list,XcoUpLeftDownRight);
      
      apply=XcoCreateCommand(top_window,10,WINDOW_HEIGHT-60,"Apply rules",0,0);
      XcoSetResizeMethod(apply,XcoDownLeft);
      XcoAddCallback(apply,bond_apply);

      apply2=XcoCreateCommand(top_window,15+XcoGetObjectWidth(apply),WINDOW_HEIGHT-60,"Apply rules to current frame",0,0);
      XcoSetResizeMethod(apply2,XcoDownLeft);
      XcoAddCallback(apply2,bond_apply_frame);

      add=XcoCreateCommand(top_window,10,WINDOW_HEIGHT-30,"Add",0,0);
      XcoSetResizeMethod(add,XcoDownLeft);
      XcoAddCallback(add,bond_add);
      
      xpos=10+XcoGetObjectWidth(add)+XcoGetObjectX(add);
      modify=XcoCreateCommand(top_window,xpos,WINDOW_HEIGHT-30,"Modify",0,0);
      XcoSetResizeMethod(modify,XcoDownLeft);
      XcoAddCallback(modify,bond_modify);

      xpos=10+XcoGetObjectWidth(modify)+XcoGetObjectX(modify);
      del=XcoCreateCommand(top_window,xpos,WINDOW_HEIGHT-30,"Delete",0,0);
      XcoSetResizeMethod(del,XcoDownLeft);
      XcoAddCallback(del,bond_delete);

      xpos=10+XcoGetObjectWidth(del)+XcoGetObjectX(del);
      up=XcoCreateCommand(top_window,xpos,WINDOW_HEIGHT-30,"Up",0,0);
      XcoSetResizeMethod(up,XcoDownLeft);
      XcoAddCallback(up,bond_up);

      xpos=10+XcoGetObjectWidth(up)+XcoGetObjectX(up);
      down=XcoCreateCommand(top_window,xpos,WINDOW_HEIGHT-30,"Down",0,0);
      XcoSetResizeMethod(down,XcoDownLeft);
      XcoAddCallback(down,bond_down);

      bond_rules_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(top_window));
    }
}
