/* This is atomprop.cc
   A part of the Ymol program
   Copyright (C) 1997-2001 Daniel Spangberg

   */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include "Xco.h"

#include "ccinterface.h"
#include "fstring.h"
#include "register_update.h"
#include "maxs.h"
#include "worldmemory.h"

static int open_atomprop=0;
static XcoObject awindow;
static int browse_pixel;
static XcoObject colorhole;
static int open_bcolor=0;
static XcoObject colsel;
static XcoObject spacefilltoggle,rsvdialog,ndialog,labeldialog;
static int virgin=1;

#define MODIFY_COLOR 0
#define MODIFY_SPACEFILLED 1
#define MODIFY_RSV 2
#define MODIFY_N 3
#define MODIFY_LABEL 4
#define NMODIFY 5

static XcoObject modifysel[NMODIFY];

#define MODIFYHEIGHT 30
#define WINHEIGHT (MODIFYHEIGHT*NMODIFY+90)
#define WINWIDTH (300)

#define MODIFYPOS (200)

static void apply_atomprop(int from_frame,int to_frame)
{
  XcoObject progress;
  int natoms;
  int nselatoms=0;
  int i,istyle;
  int *anr;
  int nsb=0;
  int color_r,color_g,color_b;
  int frame;
  qna_(&natoms);
  for (i=0; i<natoms; i++)
    {
      int j=i+1;
      int sel;
      qasel_(&j,&sel);
      if (sel)
	nselatoms++;
    }
  anr=malloc(sizeof( int)*(nselatoms));

  for (i=0; i<natoms; i++)
  {
      int j=i+1;
      int sel;
      qasel_(&j,&sel);
      if (sel)
      {
	  aid_(&j,&anr[nsb]);
	  nsb++;
      }
  }

  color_r=R_OF_PIXEL(browse_pixel);
  color_g=G_OF_PIXEL(browse_pixel);
  color_b=B_OF_PIXEL(browse_pixel);
  istyle=1-XcoGetToggleSelected(spacefilltoggle);

  progress=XcoCreateProgressWindow("Modifying atom properties...");
  for (frame=from_frame; frame<=to_frame; frame++)
    {
      XcoSetProgressWindowHandleSize(progress,((float)(frame-from_frame+1))/((float)(to_frame-from_frame+1)));

      if (XcoGetToggleSelected(modifysel[MODIFY_COLOR]))
	  modify_atom_color(frame,anr,nselatoms,
			    color_r,color_g,color_b);
      
      if (XcoGetToggleSelected(modifysel[MODIFY_SPACEFILLED]))
	  modify_atom_drawstyle(frame,anr,nselatoms,istyle);
      if (XcoGetToggleSelected(modifysel[MODIFY_RSV]))
	  modify_atom_rsv(frame,anr,nselatoms,atof(XcoGetDialogValue(rsvdialog)));
      if (XcoGetToggleSelected(modifysel[MODIFY_N]))
	  modify_atom_n(frame,anr,nselatoms,atoi(XcoGetDialogValue(ndialog)));
      if (XcoGetToggleSelected(modifysel[MODIFY_LABEL]))
      	  modify_atom_label(frame,anr,nselatoms,XcoGetDialogValue(labeldialog));

    }
  XcoDeleteObject(progress);
  free(anr);
  wupds_(); /* Soft update */
}

static void apclose()
{
  XcoDeleteObject(awindow);
  open_atomprop=0;
  if (open_bcolor)
    {
      XcoDeleteObject(colsel);
      open_bcolor=0;
    }
}

static void adelete(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      apclose();
    }
}

static void set_colorpixmap(unsigned int pixel)
{
  int i;
  unsigned int image[16];
  Pixmap colorpixmap;
  browse_pixel=pixel;

  for (i=0; i<16; i++)
    image[i]=pixel;
  colorpixmap=XcoCreatePixmapFromImage(colorhole,image,4,4);
  XcoSetBackgroundPixmap(colorhole,colorpixmap,True);
  XFreePixmap(XcoGetDisplay(),colorpixmap);
}

static void use_color(int r,int g,int b,int ok)
{
  if (open_atomprop)
    if (ok)
      {
	set_colorpixmap(PIXEL(r,g,b));
      }
}

static void dcolsel(XcoObject dummy,XEvent event)
{
  if (event.type==DestroyNotify)
    {
      printf("The color selector object was destroyed\n");
      open_bcolor=0;
    }
}

static void browse_colors(XcoObject dummy,XEvent event)
{
  if (open_atomprop)
    {
      if (event.type==ButtonPress)
	{
	  if (!open_bcolor)
	    {
	      colsel=XcoColorselector(R_OF_PIXEL(browse_pixel),
						G_OF_PIXEL(browse_pixel),
						B_OF_PIXEL(browse_pixel),
						use_color);
	      XcoAddCallback(colsel,dcolsel);

	      open_bcolor=1;
	    }
	}
    }
}

static void apply_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int frame,nframes;
      gframe_(&frame,&nframes);
      apply_atomprop(frame,frame);
    }
}

static void applyall_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int frame,nframes;
      gframe_(&frame,&nframes);
      apply_atomprop(1,nframes);
    }
}

static void cancel_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
      apclose();
}

static void virginize()
{
  if (open_atomprop)
    apclose();
}

void apropwindow()
{
  if (!open_atomprop)
    {
      int i;
      int icol=0;
      int natoms,nworld;
      int sel,spacefill,itmp,npow=20;
      double rsv=0.7;
      int imodify=0;
      char atomlabel[MAXCHARSPERLABEL];
      char ctmp[100];

      XcoObject bcmd,colorbox,apply,decorbox,otmp,togglepos,dialogparent;
      getany_(&i);
      if (i)
	{
	  if (virgin)
	    {
	      register_update_function(virginize);
	      virgin=0;
	    }

	  /* Get the defaults... */

	  spacefill=1;
	  qna_(&natoms);
	  
	  get_nframes(&nworld);
	  nworld++;

	  for (i=0; i<natoms; i++)
	    {
	      int j=i+1;
	      qasel_(&j,&sel);
	      if (sel)
		{
		  icol=qargb_(&j);
		  qsfill_(&j,&spacefill);
#if defined(USCORE2)
		  get_atomrsv__(&nworld,&i,&rsv);
#else
		  get_atomrsv_(&nworld,&i,&rsv);
#endif
#if defined(USCORE2)
		  get_atomn__(&nworld,&i,&npow);
#else
		  get_atomn_(&nworld,&i,&npow);
#endif
#if defined(USCORE2)
		  get_deflabel__(&nworld,&i,&itmp);
#else
		  get_deflabel_(&nworld,&i,&itmp);
#endif
		  if (itmp)
		  {
#if defined(USCORE2)
		      get_atomlabel__(&nworld,&i,atomlabel,MAXCHARSPERLABEL);
#else  
		      get_atomlabel_(&nworld,&i,atomlabel,MAXCHARSPERLABEL);
#endif
		  }
		  else
		      *atomlabel=0;
		}
	    }

	  awindow=XcoCreateNamedWindow(0,0,WINWIDTH,WINHEIGHT,DEFAULT_BACKGROUND,1,-1,"Properties of selected atoms");
	  XcoAddCallback(awindow,adelete);
	  decorbox=XcoCreateBox3D(awindow,5,5,WINWIDTH-10,WINHEIGHT-50,2,1);
	  XcoSetResizeMethod(decorbox,XcoUpLeftDownRight);
	  dialogparent=XcoCreateDialogParent(decorbox,2,2,WINWIDTH-14,WINHEIGHT-54);
	  XcoSetResizeMethod(dialogparent,XcoUpLeftDownRight);

	  XcoSetResizeMethod(XcoCreateLabel(dialogparent,10+MODIFYPOS/2-30,10,"Property",0,0),XcoUpLeft);

	  XcoSetResizeMethod((otmp=XcoCreateLabel(dialogparent,MODIFYPOS,10,"Modify",0,0)),XcoUpRight);
	  togglepos=XcoGetObjectWidth(otmp)/2+MODIFYPOS-5;


	  /* Color */
	  imodify++;

	  otmp=XcoCreateLabel(dialogparent,10,10+imodify*MODIFYHEIGHT,"Color",0,0);
	  XcoSetResizeMethod(otmp,XcoUpLeft);
	  bcmd=XcoCreateCommand(dialogparent,80+XcoGetObjectWidth(otmp),10+imodify*MODIFYHEIGHT,"Browse",0,0);
	  colorbox=XcoCreateBox3D(dialogparent,20+XcoGetObjectWidth(otmp),10+imodify*MODIFYHEIGHT,50,XcoGetObjectHeight(bcmd),0,1);
	  colorhole=XcoCreateHole(colorbox,2,2,46,XcoGetObjectHeight(bcmd)-4);
	  XcoAddCallback(bcmd,browse_colors);
	  XcoSetResizeMethod(colorbox,XcoUpLeft);
	  XcoSetResizeMethod(colorhole,XcoUpLeft);
	  XcoSetResizeMethod(bcmd,XcoUpLeft);

	  /* Spacefilled */
	  imodify++;

	  XcoSetResizeMethod(XcoCreateLabel(dialogparent,10,10+imodify*MODIFYHEIGHT,"Spacefilled",0,0),XcoUpLeft);
	  spacefilltoggle=XcoCreateToggle(dialogparent,100,10+5+imodify*MODIFYHEIGHT,10,10,PIXEL(255,0,0),1,!spacefill);
	  XcoSetResizeMethod(spacefilltoggle,XcoUpLeft);

	  /* rsv */
	  imodify++;

	  sprintf(ctmp,"%5.3f",rsv);
	  XcoSetResizeMethod((otmp=XcoCreateLabel(dialogparent,10,10+imodify*MODIFYHEIGHT,"Phong rsv",0,0)),XcoUpLeft);
	  rsvdialog=XcoCreateDialog(dialogparent,80,10+imodify*MODIFYHEIGHT,dialogparent,
				    ctmp,5,
				    80,0);
	  XcoSetResizeMethod(rsvdialog,XcoUpLeft);


	  /* n */
	  imodify++;

	  sprintf(ctmp,"%d",npow);
	  XcoSetResizeMethod((otmp=XcoCreateLabel(dialogparent,10,10+imodify*MODIFYHEIGHT,"Phong n",0,0)),XcoUpLeft);
	  ndialog=XcoCreateDialog(dialogparent,80,10+imodify*MODIFYHEIGHT,dialogparent,
				    ctmp,4,
				    80,0);
	  XcoSetResizeMethod(ndialog,XcoUpLeft);

	  /* label */
	  imodify++;

	  XcoSetResizeMethod((otmp=XcoCreateLabel(dialogparent,10,10+imodify*MODIFYHEIGHT,"Label",0,0)),XcoUpLeft);
	  labeldialog=XcoCreateDialog(dialogparent,80,10+imodify*MODIFYHEIGHT,dialogparent,
				      atomlabel,MAXCHARSPERLABEL,
				      80,0);
	  XcoSetResizeMethod(labeldialog,XcoUpLeft);





	  for (imodify=1; imodify<=NMODIFY; imodify++)
	      modifysel[imodify-1]=XcoCreateToggle(dialogparent,togglepos,10+5+imodify*MODIFYHEIGHT,10,10,PIXEL(255,0,0),1,0);

	  apply=XcoCreateCommand(awindow,10,WINHEIGHT-30,"Apply",0,0);
	  XcoAddCallback(apply,apply_callback);
	  XcoSetResizeMethod(apply,XcoDownLeft);
	  apply=XcoCreateCommand(awindow,15+XcoGetObjectWidth(apply),WINHEIGHT-30,"Apply to all frames",0,0);
	  XcoAddCallback(apply,applyall_callback);
	  XcoSetResizeMethod(apply,XcoDownLeft);
	  apply=XcoCreateCommand(awindow,5+XcoGetObjectX(apply)+XcoGetObjectWidth(apply),WINHEIGHT-30,"Cancel",0,0);
	  XcoAddCallback(apply,cancel_callback);
	  XcoSetResizeMethod(apply,XcoDownLeft);

	  if (sel)
	    set_colorpixmap(icol);
	  else
	    set_colorpixmap(0);

	  open_atomprop=1;
	}
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(awindow));
    }
}
