/* This is atomparams.c
   A part of the Ymol program
   Copyright (C) 1997-2006 Daniel Spangberg
   */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <X11/Xlib.h>
#include <Xco.h>
#include "atomlabel.h"
#include "ccinterface.h"

typedef struct myopen
{
  int anr;
  XcoObject mywin,bcmd,colorhole,raddialog,weightdialog,rsvdialog,ndialog;
  struct myopen *next;
} myopen;

static int bcopen;
static int bcanr;
static XcoObject colsel;
static XcoObject chole;

static myopen *openhook=NULL;

static int isopen(int anr)
{
  int is=0;
  myopen *ptr=openhook;
  while ((ptr!=NULL) && (!is))
    {
      if (ptr->anr==anr)
	is=1;
      ptr=ptr->next;
    }
  return is;
}




static void delete_callback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      myopen *ptr=openhook;
      myopen *oldptr=NULL;
      while (ptr->mywin!=id)
	{
	  oldptr=ptr;
	  ptr=ptr->next;
	}
      if (oldptr==NULL)
	openhook=ptr->next;
      else
	oldptr->next=ptr->next;
      free(ptr);
      XcoDeleteObject(id);
    }
}

#define WSIZE_X 200
#define WSIZE_Y 280

static void set_colorpixmap(XcoObject colorhole,unsigned int pixel)
{
  unsigned int image[16];
  int i;
  Pixmap colorpixmap;

  for (i=0; i<16; i++)
    image[i]=pixel;
  colorpixmap=XcoCreatePixmapFromImage(colorhole,image,4,4);
  XcoSetBackgroundPixmap(colorhole,colorpixmap,True);
  XFreePixmap(XcoGetDisplay(),colorpixmap);
}

static void use_color(int r,int g,int b,int ok)
{
  if (ok)
    {
      set_colorpixmap(chole,PIXEL(r,g,b));
      sdargb_(&bcanr,&r,&g,&b);      
    }
}


static void dcolsel(XcoObject dummy,XEvent event)
{
  if (event.type==DestroyNotify)
    {
      printf("The color selector object was destroyed\n");
      bcopen=0;
    }
}

static void browse_colors(XcoObject id, XEvent event)
{
  if (event.type==ButtonPress)
    {
      if (!bcopen)
	{
	  int is=0;
	  int ir,ig,ib;
	  myopen *ptr=openhook;
	  while ((ptr!=NULL) && (!is))
	    {
	      if (ptr->bcmd==id)
		is=1;
	      else
		ptr=ptr->next;
	    }


	  bcanr=ptr->anr;
	  chole=ptr->colorhole;
	  qdargb_(&ptr->anr,&ir,&ig,&ib);
	  colsel=XcoColorselector(ir,ig,ib,
				  use_color);
	  XcoAddCallback(colsel,dcolsel);
	  bcopen=1;
	}
    }
}

static void updatethings(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      myopen *ptr=openhook;
      while (ptr!=NULL)
	{
	  double x;
	  x=strtod(XcoGetDialogValue(ptr->raddialog),NULL);
	  sdarad_(&ptr->anr,&x);
	  x=strtod(XcoGetDialogValue(ptr->weightdialog),NULL);
	  sdawgh_(&ptr->anr,&x);
	  x=strtod(XcoGetDialogValue(ptr->rsvdialog),NULL);
	  sdarsv_(&ptr->anr,&x);
	  x=strtod(XcoGetDialogValue(ptr->ndialog),NULL);
	  sdanpo_(&ptr->anr,&x);
	  ptr=ptr->next;
	}
      wupd_();
    }
}

void p_atomparams(int *alist)
{
  if (!isopen(*alist))
    {
      XcoObject decorbox,colorbox,updatebutton,lbl;
      double xb;
      int ir,ig,ib;
      char myname[100],label[100],rads[100];
      myopen *new=malloc(sizeof(myopen));
      get_atomlabel(*alist,label);
      sprintf(myname,"Properties of %s",label);
      new->anr=*alist;
      new->mywin=XcoCreateNamedDialogParent(-1,0,0,WSIZE_X,WSIZE_Y,myname);
      new->next=openhook;
      openhook=new;
      XcoAddCallback(new->mywin,delete_callback);
      decorbox=XcoCreateBox3D(new->mywin,5,5,WSIZE_X-10,WSIZE_Y-55,2,1);
      XcoSetResizeMethod(decorbox,XcoUpLeftDownRight);

      new->bcmd=XcoCreateCommand(decorbox,80,10,"Browse",0,0);
      colorbox=XcoCreateBox3D(decorbox,20,10,50,XcoGetObjectHeight(new->bcmd),0,1);
      new->colorhole=XcoCreateHole(colorbox,2,2,46,XcoGetObjectHeight(new->bcmd)-4);
      XcoAddCallback(new->bcmd,browse_colors);
      XcoSetResizeMethod(colorbox,XcoUpLeftDownRight);
      XcoSetResizeMethod(new->colorhole,XcoUpLeftDownRight);
      XcoSetResizeMethod(new->bcmd,XcoUpRight);
      qdargb_(alist,&ir,&ig,&ib);
      set_colorpixmap(new->colorhole,PIXEL(ir,ig,ib));
      updatebutton=XcoCreateCommand(new->mywin,10,WSIZE_Y-30,"Update",0,0);
      XcoSetResizeMethod(updatebutton,XcoDownLeft);
      XcoAddCallback(updatebutton,updatethings);

      lbl=XcoCreateLabel(new->mywin,20,50,"Radius:",0,0);
      qdarad_(alist,&xb);
      sprintf(rads,"%6.4f",xb);
      new->raddialog=XcoCreateDialog(new->mywin,30+XcoGetObjectWidth(lbl),50,new->mywin,rads,6,80,0);

      lbl=XcoCreateLabel(new->mywin,20,90,"Atom weight:",0,0);
      qdawgh_(alist,&xb);
      sprintf(rads,"%6.4f",xb);
      new->weightdialog=XcoCreateDialog(new->mywin,30+XcoGetObjectWidth(lbl),90,new->mywin,rads,6,80,0);

      lbl=XcoCreateLabel(new->mywin,20,130,"Phong rsv:",0,0);
      qdarsv_(alist,&xb);
      sprintf(rads,"%6.4f",xb);
      new->rsvdialog=XcoCreateDialog(new->mywin,30+XcoGetObjectWidth(lbl),130,new->mywin,rads,6,80,0);

      lbl=XcoCreateLabel(new->mywin,20,170,"Phong n:",0,0);
      qdanpo_(alist,&xb);
      sprintf(rads,"%6.0f",xb);
      new->ndialog=XcoCreateDialog(new->mywin,30+XcoGetObjectWidth(lbl),170,new->mywin,rads,6,80,0);

    }
  else
    {
      
    }
}
