/* This is atomlabel.cc
   A part of the Ymol program
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: atomlabel.c 2 2001-10-30 14:54:51Z daniels $";

#include <string.h>
#include "atomlabel.h"

static char atom_label[N_ATOMS][4]=
{
  "H","He",
  "Li","Be","B","C","N","O","F","Ne",
  "Na","Mg","Al","Si","P","S","Cl","Ar",
  "K","Ca","Sc","Ti","V","Cr","Mn","Fe","Co","Ni","Cu","Zn","Ga","Ge","As","Se","Br","Kr",
  "Rb","Sr","Y","Zr","Nb","Mo","Tc","Ru","Rh","Pd","Ag","Cd","In","Sn","Sb","Te","I","Xe",
  "Cs","Ba",
  "La","Ce","Pr","Nd","Pm","Sm","Eu","Gd","Tb","Dy","Ho","Er","Tm","Yb","Lu",
  "Hf","Ta","W","Re","Os","Ir","Pt","Au","Hg","Tl","Pb","Bi","Po","At","Rn",
  "Fr","Ra",
  "Ac","Th","Pa","U","Np","Pu","Am","Cm","Bk","Cf","Es","Fm","Md","No","Lr",
  "Rf","Db","Sg","Bh","Hs","Mt"
};
static char *empty="";

void get_atomlabel(int i,char *label)
{
  if (i<=N_ATOMS)
    strcpy(label,atom_label[i-1]);
  else
    strcpy(label,empty);
}
