/* This is aboutymol.c
   A part of the Ymol program
   (C) 1997-1998 Daniel Spangberg
   */

#include <stdio.h>
#include <X11/Xlib.h>
#include <Xco.h>
#include "aboutymol.h"

static int about_ymol_open=0;
static XcoObject mywin;

static void close_window()
{
  about_ymol_open=0;
  XcoDeleteObject(mywin);
}

static void del_window(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    {
      close_window();
    }
}

static void closebutton(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    close_window();
}

void show_about_ymol_message()
{
  if (!about_ymol_open)
    {
      int listitems=0;
      XcoObject close,decorbox,list;
      /* List must be null-terminated! */
      static char *mylist[]=
      {
	"Ymol " PROGRAMVERSION,
	COMPILEINFO,
	"",
	"Ymol is Copyright (C) 1997-2014 Daniel Spaangberg",
	"daniel@spaangberg.se",
	"Ymol comes with ABSOLUTELY NO WARRANTY.",
	"",
	"For latest updates go to",
        "http://www.spaangberg.se/daniels/ymol.html",
	NULL
      };
      while (mylist[listitems]!=NULL)
	listitems++;
      mywin=XcoCreateNamedWindow(0,0,400,300,DEFAULT_BACKGROUND,1,-1,"About Ymol");
      XcoAddCallback(mywin,del_window);

      decorbox=XcoCreateBox3D(mywin,5,5,390,245,2,1);
      XcoSetResizeMethod(decorbox,XcoUpLeftDownRight);
      list=XcoCreateList(decorbox,5,5,380,235,20,mylist,listitems);
      XcoSetResizeMethod(list,XcoUpLeftDownRight);
      close=XcoCreateCommand(mywin,20,270,"Close",0,0);
      XcoAddCallback(close,closebutton);
      XcoSetResizeMethod(close,XcoDownLeft);

      about_ymol_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(mywin));

    }
}
