/* This is toggle.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: toggle.c 2 2001-10-30 13:35:39Z daniels $";

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"

typedef struct
{
  int autosel;
  int selected;
  int selected_pixel;
} toggledata ;


void __expose_toggle(XcoObject id)
{
  if (((toggledata*)(__objects[id]->data))->selected)
    {
      XPoint my[4];
      int size=__objects[id]->height;
      if (__objects[id]->width<size)
	size=__objects[id]->width;
      size-=(size+1)%2;

      my[0].x=0;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=size-1;
      my[2].x=size-1;
      my[2].y=size/2;
      my[3].x=size/2;
      my[3].y=0;
      XSetForeground(XcoGetDisplay(),XcoGC(id),
		     XcoGetPixel32(0,0,((toggledata*)(__objects[id]->data))->selected_pixel));
      XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,4,
		   Complex,CoordModeOrigin);

      my[0].x=0;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=0;
      my[2].x=size-1;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(0,0,0));
      my[0].x=1;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=1;
      my[2].x=size-2;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(0,0,0));
      my[0].x=0;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=size-1;
      my[2].x=size-1;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(255,255,255));
      my[0].x=1;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=size-2;
      my[2].x=size-2;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(255,255,255));
    }
  else
    {
      XPoint my[4];
      int size=__objects[id]->height;
      if (__objects[id]->width<size)
	size=__objects[id]->width;
      size-=(size+1)%2;

      my[0].x=0;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=size-1;
      my[2].x=size-1;
      my[2].y=size/2;
      my[3].x=size/2;
      my[3].y=0;
      XSetForeground(XcoGetDisplay(),XcoGC(id),
		     XcoGetPixel32(0,0,__objects[id]->background));
      XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,4,
		   Complex,CoordModeOrigin);

      my[0].x=0;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=0;
      my[2].x=size-1;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(255,255,255));
      my[0].x=1;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=1;
      my[2].x=size-2;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(255,255,255));
      my[0].x=0;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=size-1;
      my[2].x=size-1;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(0,0,0));
      my[0].x=1;
      my[0].y=size/2;
      my[1].x=size/2;
      my[1].y=size-2;
      my[2].x=size-2;
      my[2].y=size/2;
      XcoDrawPolyLine(id,my,3,PIXEL(0,0,0));
    }
}

void __toggle_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_toggle(id);
      break;
    case ButtonPress:
      if (((toggledata*)(__objects[id]->data))->autosel)
	{
	  ((toggledata*)(__objects[id]->data))->selected=1-
	    ((toggledata*)(__objects[id]->data))->selected;
	  __expose_toggle(id);
	}
      break;
    }
}

void XcoSetToggleSelected(XcoObject id,int selected)
{
  ((toggledata*)(__objects[id]->data))->selected=selected;
  __expose_toggle(id);
}

int XcoGetToggleSelected(XcoObject id)
{
  return (((toggledata*)(__objects[id]->data))->selected);
}



XcoObject XcoCreateToggle(XcoObject parent,
			  int x,int y,int width,int height,
			  int selected_pixel,int autosel,int selected)
{
  toggledata *mytoggledata;
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
	       ExposureMask|ButtonPressMask);

  mytoggledata=malloc(sizeof(toggledata));
  mytoggledata->selected=selected;
  mytoggledata->selected_pixel=selected_pixel;
  mytoggledata->autosel=autosel;

  __objects[myobject]->data=(void*) mytoggledata;
  __objects[myobject]->type=XcoTToggle;
  
  __expose_toggle(myobject);

  XcoAddCallback(myobject,__toggle_callback);

  return (myobject);
}

