/* This is pulldownlist.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: pulldownlist.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "Xco.h"

static XFontStruct *pulldownlistfont;

void XcoPulldownListFont(XFontStruct *fstruct)
{
  pulldownlistfont=fstruct;
}

typedef struct
{
  char **str;
  int items;
  int active_item;
  XcoMenu menu;
  XcoObject box3d;
  XcoObject label;
  int pressed;
  int status;
} pulldownlistdata;

typedef struct
{
  XcoObject object;
} parentdata;

void __expose_buttonimage(XcoObject id)
{
  XPoint my[3];
  XSetForeground(XcoGetDisplay(),XcoGC(id),XcoGetPixel32(0,0,__objects[id]->foreground));
  my[0].x=3*__objects[id]->width/4;
  my[0].y=__objects[id]->height/4;
  my[1].x=__objects[id]->width/2;
  my[1].y=3*__objects[id]->height/4;
  my[2].x=__objects[id]->width/4;
  my[2].y=__objects[id]->height/4;
  XFillPolygon(XcoGetDisplay(),XcoWindow(id),XcoGC(id),my,3,
	       Complex,CoordModeOrigin);
}

void __pulldownlist_buttonimage_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_buttonimage(id);
      break;
    }
}

typedef struct
{
  XcoObject object;
} menuparentdata;

void __pulldownlist_menu_callback(XcoMenu id,int position)
{
  XEvent event;
  /* Which pulldown list??? */
  menuparentdata *pdata=(menuparentdata*) XcoGetMenuParentdata(id);
  ((pulldownlistdata*)(__objects[pdata->object]->data))->pressed=0;
  XcoSetBox3DInverted(((pulldownlistdata*)(__objects[pdata->object]->data))->box3d,0);
  if (position!=-1)
    {
      /* New label */
      XcoSetLabelString(((pulldownlistdata*)(__objects[pdata->object]->data))->label,((pulldownlistdata*)(__objects[pdata->object]->data))->str[position]);
      ((pulldownlistdata*)(__objects[pdata->object]->data))->status=position;
      XcoExecuteCallbacks(pdata->object,event);
    }
  free( pdata);
}

static int mouse_xpress,mouse_ypress;

void __pulldownlist_callback(XcoObject id,XEvent event)
{
  XcoObject object=((parentdata*)(__objects[id]->parentdata))->object;
  ((pulldownlistdata*)(__objects[object]->data))->status=-1;
  switch (event.type)
    {
      /* case MotionNotify: */
    case ButtonRelease:
      {
	int x,y;
	int rx,ry;
	Window wr,wc;
	unsigned int mask;
	XQueryPointer(XcoGetDisplay(),XcoWindow(object),&wr,&wc,&rx,&ry,&x,&y,&mask);
	if (((rx)==mouse_xpress) && ((ry)==mouse_ypress))
	  {
	    printf("I'll keep your little menu\n");
	  }
	else
	  {
	    XcoRemoveAnyMenu(-1,0);
	  }
      }
    break;
    case ButtonPress:
      if (!((pulldownlistdata*)(__objects[object]->data))->pressed)
	{
	  int x,y;
	  int rx,ry;
	  Window wr,wc;
	  unsigned int mask;
	  menuparentdata *pdata;
	  ((pulldownlistdata*)(__objects[object]->data))->pressed=1;
	  XcoSetBox3DInverted(((pulldownlistdata*)(__objects[object]->data))->box3d,1);
	  XQueryPointer(XcoGetDisplay(),XcoWindow(object),&wr,&wc,&rx,&ry,&x,&y,&mask);
	  mouse_xpress=rx;
	  mouse_ypress=ry;
	  pdata=malloc(sizeof( menuparentdata));
	  pdata->object=object;
	  XcoOpenMenu(-1,
		      ((pulldownlistdata*)(__objects[object]->data))->menu,
		      rx-x,ry-y+__objects[object]->height,__pulldownlist_menu_callback,pdata);
	}
      break;
    }
}

int XcoGetPulldownListStatus(XcoObject id)
{
  return(((pulldownlistdata*)(__objects[id]->data))->status);
}

XcoObject XcoCreatePulldownList(XcoObject parent,
				int x,int y,char **str,int items,int active_item,int width,int height)
{
  pulldownlistdata *mydata;
  XcoObject myobject,box3d,hole2,ibox3d,label;
  parentdata *p1,*p2,*p3,*p4;

  XcoLabelFont(pulldownlistfont);
  if (height==0)
    height=XcoTextHeight(pulldownlistfont)+4;
  if (width==0)
    {
      int i;
      for (i=0; i<items; i++)
	{
	  int w=XcoTextWidth(pulldownlistfont,str[i]);
	  if (w>width)
	    width=w;
	}
    }
  width+=4;
  width+=height;

  mydata=malloc(sizeof( pulldownlistdata));
  
  mydata->str=str;
  mydata->items=items;
  mydata->active_item=active_item;
  mydata->pressed=0;
  mydata->menu=XcoCreateMenu(MENU_TOPLEVEL,0,str,items);
  mydata->status=-1;



  myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  __objects[myobject]->menuwidget=1;

  box3d=XcoCreateBox3D(myobject,0,0,height,height,0,1);
  mydata->box3d=box3d;

  hole2=XcoCreateHole(box3d,2,2,height-4,height-4);
  XcoAddCallback(hole2,__pulldownlist_buttonimage_callback);

  ibox3d=XcoCreateBox3D(myobject,height,0,width-height,height,1,1);

  label=XcoCreateLabel(ibox3d,2,2,str[active_item],width-height-4,height-4);
  XcoSetBackground(label,PIXEL(255,255,255));
  mydata->label=label;

  XSelectInput(XcoGetDisplay(),XcoWindow(box3d),
	       ExposureMask|PointerMotionMask);
  XcoAddCallback(box3d,__pulldownlist_callback);
  p1=malloc(sizeof( parentdata));
  p1->object=myobject;
  __objects[box3d]->parentdata=(void*)p1;

  XSelectInput(XcoGetDisplay(),XcoWindow(hole2),
	       ExposureMask|ButtonPressMask|OwnerGrabButtonMask|ButtonReleaseMask);
  XcoAddCallback(hole2,__pulldownlist_callback);
  p2=malloc(sizeof( parentdata));
  p2->object=myobject;
  __objects[hole2]->parentdata=(void*)p2;

  XSelectInput(XcoGetDisplay(),XcoWindow(ibox3d),
	       ExposureMask|PointerMotionMask);
  XcoAddCallback(ibox3d,__pulldownlist_callback);
  p3=malloc(sizeof( parentdata));
  p3->object=myobject;
  __objects[ibox3d]->parentdata=(void*)p3;

  XSelectInput(XcoGetDisplay(),XcoWindow(label),
	       ExposureMask|PointerMotionMask);
  XcoAddCallback(label,__pulldownlist_callback);
  p4=malloc(sizeof( parentdata));
  p4->object=myobject;
  __objects[label]->parentdata=(void*)p4;

  __objects[myobject]->data=(void*) mydata;
  __objects[myobject]->type=XcoTPulldownList;
  
  __expose_buttonimage(hole2);



  return (myobject);
}

/* Remove all local data */
void __remove_pulldownlist(XcoObject id)
{
  XcoDeleteMenu(((pulldownlistdata*)(__objects[id]->data))->menu);
}
