/* This is progresswindow.c
   A part of the Xco library
   Copyright (c) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: progresswindow.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "Xco.h"

#define MIN_WIDTH 120

static XFontStruct *pwfont;

void XcoProgressWindowFont(XFontStruct *fstruct)
{
  pwfont=fstruct;
}

typedef struct
{
  XcoObject progressbar;
} pwindow;

XcoObject XcoCreateProgressWindow(char *title)
{
  int height;
  int x,y;
  int rx,ry;
  Window wr,wc;
  unsigned int mask;
  XcoObject id,box;
  pwindow *mydata;

  int width=XcoTextWidth(pwfont,title)+50+4;
  if (width<MIN_WIDTH)
    width=MIN_WIDTH;
  height=0;  /* XcoTextHeight(pwfont); */
  height+=20+10+4;
  

  XQueryPointer(XcoGetDisplay(),
		RootWindow(XcoGetDisplay(),DefaultScreen(XcoGetDisplay())),
		&wr,&wc,&rx,&ry,&x,&y,&mask);
  
  id=XcoCreateWindow(x,y,width,height,DEFAULT_BACKGROUND,1,-1);
  XStoreName(XcoGetDisplay(),XcoWindow(id),title);
  box=XcoCreateBox3D(id,0,0,width,height,0,1);
#if 0

  XcoLabelFont(pwfont);

  XcoCreateLabel(box,5,5,title,0,0);
#endif
  mydata=malloc(sizeof( pwindow));
  mydata->progressbar=XcoCreateProgressbar(box,5,height-25,width-10,20,0);
  __objects[id]->data=(void*)mydata;
  __objects[id]->type=XcoTProgressWindow;

  return(id);
}

void XcoSetProgressWindowHandleSize(XcoObject id,float size)
{
  XcoSetProgressbarSize(((pwindow*)(__objects[id]->data))->progressbar,size);
}

