/* This is progressbar.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: progressbar.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>

#include "Xco.h"

typedef struct
{
  float handle_size;
} progressbardata;

void __expose_progressbar(XcoObject id)
{
  int barwidth=__objects[id]->width-4;
  int handlewidth=(int)(barwidth*((progressbardata*)(__objects[id]->data))->handle_size);
  
  if ((barwidth-handlewidth)>0)
    XcoFillBox(id,2+handlewidth,2,
	       barwidth-handlewidth,
	       __objects[id]->height-4,	 
	       __objects[id]->background);
  

  XcoDrawInverted3DBox(id,0,0,
		       __objects[id]->width,
		       __objects[id]->height);
  
  XcoDraw3DBox(id,2,2,	       
	       handlewidth,
	       __objects[id]->height-4);

  if (handlewidth>4)
    XcoFillBox(id,4,4,
	       handlewidth-4,
	       __objects[id]->height-8,
	       __objects[id]->background);
  XcoFlush();
}


float XcoGetProgressbarSize(XcoObject id)
{
  return ((progressbardata*)(__objects[id]->data))->handle_size; 
}

void XcoSetProgressbarSize(XcoObject id,float handle_size)
{
  if (handle_size<0.)
    handle_size=0.;
  if (handle_size>1.)
    handle_size=1.;
  ((progressbardata*)(__objects[id]->data))->handle_size=handle_size;
  __expose_progressbar(id);
}

static void __progressbar_callback(XcoObject id,XEvent event)
{
  if (event.type==Expose)
    {
      __expose_progressbar(id);
    }
}


XcoObject XcoCreateProgressbar(XcoObject parent,
			     int x,int y,int width,int height,
			     float handle_size)
{
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  progressbardata *mydata=malloc(sizeof( progressbardata));
  mydata->handle_size=handle_size;

  __objects[myobject]->data=(void*) mydata;
  __objects[myobject]->type=XcoTProgressbar;

  __expose_progressbar(myobject);

  XcoAddCallback(myobject,__progressbar_callback);

  return (myobject);
}


