/* This is object.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: object.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#define __object__

#include "Xco.h"

int *__used_objects;
_XcoObject **__objects;
int MAX_OBJECTS;

#define DEFAULT_MAX_OBJECTS 2


void __XcoInitObjects()
{
  int i;
  MAX_OBJECTS=DEFAULT_MAX_OBJECTS;
  __used_objects=malloc(sizeof(int)*MAX_OBJECTS);
  __objects=malloc(sizeof(_XcoObject*)*MAX_OBJECTS);

  for (i=0; i<MAX_OBJECTS; i++)
    __used_objects[i]=0;
}

void __XcoReallocObjects()
{
  int new_max=MAX_OBJECTS*2;
  int *old_used;
  _XcoObject **old_objects;
  int i;


  /*  printf("__XcoReallocObjects: New max=%d\n",new_max); */
  old_used=__used_objects;
  old_objects=__objects;
  __used_objects=malloc(sizeof(int)*new_max);
  __objects=malloc(sizeof(_XcoObject*)*new_max);
  for (i=0; i<new_max; i++)
    {
      if (i<MAX_OBJECTS)
	{
	  __used_objects[i]=old_used[i];
	  __objects[i]=old_objects[i];
	}
      else
	{
	  __used_objects[i]=0;
	}
    }
  free(old_used);
  free(old_objects);
  MAX_OBJECTS=new_max;
}



Window XcoWindow(XcoObject id)
{
  return(__objects[id]->window);
}

GC XcoGC(XcoObject id)
{
  return(__objects[id]->gc);
}

XcoObject XcoCreateObject(XcoObject parent,XcoType type,
			  int x,int y,int width,int height)
{
  /* find first unused id */
  XcoObject id=0;
  while ((id<MAX_OBJECTS) && (__used_objects[id]!=0))
    id++;
  if (id>=MAX_OBJECTS)
    {
      __XcoReallocObjects();
    }
  __used_objects[id]=1;
  __objects[id]=malloc(sizeof(_XcoObject));

  __objects[id]->id=id;
  __objects[id]->parent=parent;
  __objects[id]->type=type;
  __objects[id]->x=x;
  __objects[id]->y=y;
  __objects[id]->width=width;
  __objects[id]->height=height;
  __objects[id]->orig_x=x;
  __objects[id]->orig_y=y;
  __objects[id]->orig_width=width;
  __objects[id]->orig_height=height;
  __objects[id]->resize=XcoResize;
  __objects[id]->callbacklist=NULL;
  __objects[id]->data=NULL;
  __objects[id]->parentdata=NULL;
  __objects[id]->background=DEFAULT_BACKGROUND;
  __objects[id]->foreground=DEFAULT_FOREGROUND;
  if (parent==-1)
    __objects[id]->menuwidget=0;
  else
    __objects[id]->menuwidget=__objects[parent]->menuwidget;

 
  return(id);
}

void XcoSetResizeMethod(XcoObject id,int resizemethod)
{
  __objects[id]->resize=resizemethod;
}



void __XcoDeleteObject(XcoObject id)
{
  int i;
  _XcoCallback *cb;

  /* Find all objects that have this object as parent. */
  for (i=0; i<MAX_OBJECTS; i++)
    {
      if (__used_objects[i])
	if (__objects[i]->parent==id)
	  __XcoDeleteObject(i);
    }

  cb=__objects[id]->callbacklist;
  while (cb!=NULL)
    {
      _XcoCallback *next=cb->next;
      free(cb);
      cb=next;
    }

  switch(__objects[id]->type)
    {
    case XcoTLabel:
      __remove_label(id);
      break;
    case XcoTCommand:
      __remove_command(id);
      break;
    case XcoTDialog:
      __remove_dialog(id);
      break;
    case XcoTDialogParent:
      __remove_dialogparent(id);
      break;
    case XcoTPulldownList:
      __remove_pulldownlist(id);
      break;
    }

  if (__objects[id]->data!=NULL)
    free(__objects[id]->data);

  if (__objects[id]->parentdata!=NULL)
    free(__objects[id]->parentdata);

  if (id==__XcoGetCurrentProcess())
    __XcoSetCurrentProcess(-1);
  
  __used_objects[id]=0;
  free(__objects[id]);
}

void XcoDeleteObject(XcoObject id)
{
  XDestroyWindow(XcoGetDisplay(),__objects[id]->window);
  if (__objects[id]->parent==-1)
    {
      /* printf("Executing the callbacks\n"); */
      XEvent event;
      event.type=DestroyNotify;
      XcoExecuteCallbacks(id,event);
    }
  __XcoDeleteObject(id);
}

void XcoAddCallback(XcoObject id,void (*callback)(XcoObject id,XEvent event))
{
  _XcoCallback *newcb;
  _XcoCallback *next;
  newcb=malloc(sizeof(_XcoCallback));

  newcb->callback=callback;
  newcb->next=NULL;


  next=__objects[id]->callbacklist;
  if (next==NULL)
    {
      __objects[id]->callbacklist=newcb;
    }
  else
    {
      _XcoCallback *cb;
      while (next!=NULL)
	{
	  cb=next;
	  next=cb->next;
	}
      cb->next=newcb;
    }
}


static XcoObject current_process;

XcoObject __XcoGetCurrentProcess()
{
  return (current_process);
}

void __XcoSetCurrentProcess(XcoObject process)
{
  current_process=process;
}

void XcoExecuteCallbacks(XcoObject id,XEvent event)
{
  _XcoCallback *cb=__objects[id]->callbacklist;
  /* printf("At callbacks\n"); */
  current_process=id;
  while ((current_process==id) && (cb!=NULL))
    {
      cb->callback(id,event);
      if (current_process==id)
	cb=cb->next;
    }
}

void XcoExposeObject(XcoObject id)
{
  switch(__objects[id]->type)
    {
      case XcoTCommand:
	__expose_command(id);
	break;
      case XcoTLabel:
	__expose_label(id);
	break;
      case XcoTDialog:
	__expose_dialog(id);
	break;
    }
}

int XcoGetObjectX(XcoObject id)
{
  return __objects[id]->x;
}

int XcoGetObjectY(XcoObject id)
{
  return __objects[id]->y;
}

int XcoGetObjectWidth(XcoObject id)
{
  return __objects[id]->width;
}

int XcoGetObjectHeight(XcoObject id)
{
  return __objects[id]->height;
}

