/* This is menus.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: menus.c 9 2004-05-12 15:02:05Z daniels $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/cursorfont.h>

#include "Xco.h"

#if 0
void *mymalloc(size_t mysize)
{
  void *m=malloc(mysize);
  printf("Mallocing: %x\n",m); fflush(NULL);
  return (m);
}

void myfree(void *m)
{
  printf("Freeing: %x\n",m); fflush(NULL);
  free(m);
}

#define malloc mymalloc
#define free myfree

#endif



#define MAX_LEVELS MAX_MENUS

static char **menu_text[MAX_MENUS];
static int *menuitem_toggleable[MAX_MENUS];
static int *menuitem_activated[MAX_MENUS];
static int menu_occupied[MAX_MENUS];
static XcoMenu menu_connection[MAX_MENUS][2];
static int menu_items[MAX_MENUS];
static int *menu_p_connection[MAX_MENUS];

static XcoObject menu_object[MAX_MENUS];
static XcoObject *menu_item_object[MAX_MENUS];
static void *menu_parentdata[MAX_MENUS];

static int first_id;

static int current_active_id_i[MAX_LEVELS];
static int active_x[MAX_LEVELS];
static int active_y[MAX_LEVELS];

static int current_active_level;
static int active_levels;
static int old_active;

static int currently_active_menu=0;

static void (*mycallback)(int,int);

static int first_call=1;

typedef struct
{
  int d;
  XcoObject box,triangle;
} parentdata;

void __SimpleOpenMenu(XcoObject parent,XcoMenu id,int x,int y,int top,void *pdata);
void __SimpleCloseMenu(XcoMenu id);

void XcoRemoveAnyMenu(XcoMenu id,int position)
{
  int i;
  if (currently_active_menu)
    {
      if (id==-1)
	{
	  id=current_active_id_i[0]%MAX_MENUS;
	  position=-1;
	}
      for (i=0; i<=active_levels; i++)
	{
	  int idrm=current_active_id_i[i]%MAX_MENUS;
	  __SimpleCloseMenu(idrm);
	}
      currently_active_menu=0;
      mycallback(id,position);
    }
}


static void initialize_menus()
{
  int i;
  for (i=0; i<MAX_MENUS; i++)
    menu_occupied[i]=0;
}



XcoMenu XcoCreateMenuWithID(XcoMenu id,XcoMenu parent,int position,char *mstring[],int no_items)
{
  int i,maxlen,k;
  if (first_call)
    {
      initialize_menus();
      first_call=0;
    }
  menu_occupied[id]=1;
  menu_text[id]=malloc (sizeof( char*)*no_items);
  menu_item_object[id]=malloc(sizeof( XcoObject)*no_items);
  menu_items[id]=no_items;
  maxlen=0;
  for (i=0; i<no_items; i++)
    {
      int slen=strlen(mstring[i]);
      if (maxlen<slen)
	maxlen=slen;
    }
  maxlen+=2;

  for (i=0; i<no_items; i++)
    {
      menu_text[id][i]=malloc((strlen(mstring[i])+1));
      /* printf("Allocated address for string %d:%x\n",i,menu_text[id][i]); fflush(NULL); */
      strcpy(menu_text[id][i],mstring[i]);
    }
  menu_connection[id][0]=parent;
  menu_connection[id][1]=position;
  menu_p_connection[id]=malloc(sizeof(int)*no_items);
  menuitem_toggleable[id]=malloc(sizeof(int)*no_items);
  menuitem_activated[id]=malloc(sizeof(int)*no_items);
  for (k=0; k<no_items; k++)
    {
      menu_p_connection[id][k]=-1;
      menuitem_toggleable[id][k]=0;
    }
  if (parent!=MENU_TOPLEVEL)
    {
      menu_p_connection[parent][position]=id;
    }
  return(id);
}

XcoMenu XcoCreateMenu(XcoMenu parent,int position,char *mstring[],int no_items)
{
  XcoMenu id=0;
  while (menu_occupied[id])
    id++;
  return (XcoCreateMenuWithID(id,parent,position,mstring,no_items));
}

void XcoAttachSubMenu(XcoMenu parent,int position,XcoMenu menu)
{
  menu_p_connection[parent][position]=menu;
}


void XcoSetMenuItemToggleable(XcoMenu id,int item,int toggleable,int activated)
{
  menuitem_toggleable[id][item]=toggleable;
  menuitem_activated[id][item]=activated;
}

void XcoSetMenuItemActivated(XcoMenu id,int item,int activated)
{
  menuitem_activated[id][item]=activated;
}

int XcoGetMenuItemActivated(XcoMenu id,int item)
{
  return menuitem_activated[id][item];
}

static void XcoDeleteMenuNoRecursive(XcoMenu id)
{
  XcoMenu i;
  /*  printf("Free0. id=%d\n",id); fflush(NULL); */
  free(menu_item_object[id]);
  /*  printf("Deleting %d items\n",menu_items[id]); */
  for (i=0; i<menu_items[id]; i++)
    {
      free(menu_text[id][i]);
    }
  free (menu_text[id]);
  free (menu_p_connection[id]);
  free (menuitem_toggleable[id]);
  free (menuitem_activated[id]);
  menu_occupied[id]=0;
}

void XcoDeleteMenu(XcoMenu id)
{
  XcoMenu i;
  for (i=0; i<MAX_MENUS; i++)
    {
      if (menu_occupied[i])
	{
	  if (menu_connection[i][0]==id)
	    XcoDeleteMenu(i);
	}
    }
  XcoDeleteMenuNoRecursive(id);
}

void XcoChangeMenu(XcoMenu id,XcoMenu parent,int position,char *mstring[],int no_items)
{
  /* printf("Deleting menu...\n"); */
  XcoDeleteMenuNoRecursive(id);
  /* printf("Creating the same menu...\n"); */
  XcoCreateMenuWithID(id,parent,position,mstring,no_items);
  /* printf("Created the same menu...\n"); */
}

void print_menu(int id)
{
  int i;
  printf("id: %d, items: %d\n",id,menu_items[id]); 
  for(i=0; i<menu_items[id]; i++)
    {
      printf("Item %d: '%s'\n",i,menu_text[id][i]);
      if (menu_p_connection[id][i]!=-1)
	{
	  printf("Submenu...\n");
	  print_menu(menu_p_connection[id][i]);
	  printf("End submenu\n");
	}
    }
}

static void event_menu(XcoObject object,XEvent event)
{
  int d=((parentdata*)__objects[object]->parentdata)->d;
  int data=d;
  int id=data%MAX_MENUS;
  int i=data/MAX_MENUS;
  switch(event.type)
    {
    case ButtonPress:
      /* printf("Uuuh. Even more pressure on me ;-)\n"); */
      break;
    case ButtonRelease:
      /* printf("Oh. Ah. You just released the pressure on me ;-)\n"); */
      XcoRemoveAnyMenu(id,i);
      break;
    case MotionNotify:
      /* printf("MotionNotify: %d\n",event.xmotion.window); */
      if ((current_active_id_i[current_active_level]!=d)|| (!old_active))
	{
	  if (old_active)
	    {
	      int oldid=current_active_id_i[current_active_level]%MAX_MENUS;
	      int oldi=current_active_id_i[current_active_level]/MAX_MENUS;
	      XcoSetBox3DStatus(((parentdata*)(__objects[menu_item_object[oldid][oldi]]->parentdata))->box,0);
	      if (menu_p_connection[oldid][oldi]!=-1)
		{
		  XcoSetTriangleStatus(((parentdata*)(__objects[menu_item_object[oldid][oldi]]->parentdata))->triangle,0);
		}

	      if (id==oldid)
		{
		  /* on same menu, but other item. */
		  if (active_levels>current_active_level)
		    {
		      /* remove old popup */
		      int idrm=current_active_id_i[active_levels]%MAX_MENUS;
		      __SimpleCloseMenu(idrm);
		      active_levels--;
		    }
		}
	      else
		{
		  int new_level=0;
		  int oldid=current_active_id_i[new_level]%MAX_MENUS;
		  while ((oldid!=id)&&(new_level<active_levels))
		    {
		      new_level++;
		      oldid=current_active_id_i[new_level]%MAX_MENUS;
		    }
		  if (oldid==id)
		    {
		      /* we are on a new but existing menu
			 remove old popups with higher level than 
			 new_level */
		      if (active_levels>new_level)
			{
			  int j;
			  for ( j=new_level+1; j<=active_levels; j++)
			    {
			      int idrm=current_active_id_i[j]%MAX_MENUS;
			      __SimpleCloseMenu(idrm);
			    }
			  active_levels=new_level;
			}
		      current_active_level=new_level;
		    }
		  else
		    {
		      /* printf("Error!!!\n"); */
		    }
		}
	    }	  
	  if (menu_p_connection[id][i]!=-1)
	    {

	      /* create new popups
		 compute x and y for new popup:
		 x is the old x + the width of old popup
		 y is the old y + the y position of the label */
	      int newx,newy;
	      newx=__objects[menu_object[id]]->width;
	      newy=__objects[
((parentdata*)(__objects[menu_item_object[id][i]]->parentdata))->box
]->y;
	      newx+=active_x[current_active_level];
	      newy+=active_y[current_active_level];
	      active_levels++;
	      active_x[active_levels]=newx;
	      active_y[active_levels]=newy;
	      __SimpleOpenMenu(-1,
			       menu_p_connection[id][i],
			       newx,newy,0,0);
	      current_active_id_i[active_levels]=menu_p_connection[id][i];

	    }

	  XcoSetBox3DStatus(((parentdata*)(__objects[menu_item_object[id][i]]->parentdata))->box,1);
	  if (menu_p_connection[id][i]!=-1)
	    {
	      XcoSetTriangleStatus(((parentdata*)(__objects[menu_item_object[id][i]]->parentdata))->triangle,1);
	    }

	  current_active_id_i[current_active_level]=d;
	  old_active=1;

	}
      break;
    }
}



static XFontStruct *menufont;

void XcoMenuFont(XFontStruct *fstruct)
{
  menufont=fstruct;
}

void *XcoGetMenuParentdata(XcoMenu id)
{
  return menu_parentdata[id];
}


void __SimpleOpenMenu(XcoObject parent,XcoMenu id,int x,int y,int top,void *pdata)
{
  int width,height,text_height,anytoggle,anyconnection,i;
  unsigned long valuemask;
  XSetWindowAttributes myattributes;
  XcoObject box3d;
  XcoObject hole;
  int ypos;

  XcoLabelFont(menufont);
  menu_parentdata[id]=pdata;

  width=0;
  height=0;
  text_height=XcoTextHeight(menufont);
  anytoggle=0;
  anyconnection=0;
  for (i=0; i<menu_items[id]; i++)
    {
      int w;
      if (menuitem_toggleable[id][i])
	anytoggle=1;
      if (menu_p_connection[id][i]!=-1)
	anyconnection=1;
      w=XcoTextWidth(menufont,menu_text[id][i]);
      if (w>width)
	width=w;
      if (strlen(menu_text[id][i])==0)
	height+=5;
      else
	height+=text_height+4;
    }    
  /* make room for little triangle, the toggle and a 3d looking frame. */

  width+=text_height*(2*anyconnection+anytoggle)+8;
  height+=4;

  menu_object[id]=XcoCreateWindow(x,y,width,height,DEFAULT_BACKGROUND,0,parent);
  __objects[menu_object[id]]->menuwidget=1;

  valuemask=CWCursor;
  myattributes.cursor=XCreateFontCursor(XcoGetDisplay(),XC_arrow);
  XChangeWindowAttributes(XcoGetDisplay(),XcoWindow(menu_object[id]),
			  valuemask,&myattributes);


  box3d=XcoCreateBox3D(menu_object[id],0,0,width,height,0,1);
  hole=XcoCreateHole(box3d,2,2,width-4,height-4);

  ypos=0;
  for (i=0; i<menu_items[id]; i++)
    {
      XcoObject m;
      XcoObject box=0,triangle=0,toggle=0;
      if (strlen(menu_text[id][i])==0)
	{
	  m=XcoCreateHorizLine(hole,0,ypos,width-4,5);
	  ypos+=5;
	}
      else
	{
	  parentdata *myparent,*myparent2;
	  box=XcoCreateBox3D(hole,0,ypos,width-4,text_height+4,0,0);
	  m=XcoCreateLabel(box,2+anytoggle*text_height,2,menu_text[id][i],width-8-(2*anyconnection+anytoggle)*text_height,text_height);
	  XcoAddCallback(m,event_menu);
	  XSelectInput(XcoGetDisplay(),XcoWindow(m),
		       ExposureMask|PointerMotionMask|ButtonMotionMask|ButtonPressMask|ButtonReleaseMask|OwnerGrabButtonMask|ButtonMotionMask);
	  XcoAddCallback(box,event_menu);
	  XSelectInput(XcoGetDisplay(),XcoWindow(box),
		       ExposureMask|PointerMotionMask|ButtonMotionMask|ButtonPressMask|ButtonReleaseMask|OwnerGrabButtonMask|ButtonMotionMask);

	  ypos+=text_height+4;
	  if (menu_p_connection[id][i]!=-1)
	    {
	      parentdata *myparent3;
	      triangle=XcoCreateTriangle(box,width-text_height-4,2,text_height-1,text_height-1);
	      XcoAddCallback(triangle,event_menu);
	      XSelectInput(XcoGetDisplay(),XcoWindow(triangle),
			   ExposureMask|PointerMotionMask|ButtonPressMask|ButtonReleaseMask|OwnerGrabButtonMask|ButtonMotionMask);

	      myparent3=malloc(sizeof(parentdata));
	      myparent3->d=id+MAX_MENUS*i;
	      myparent3->box=box;
	      myparent3->triangle=triangle;
	      __objects[triangle]->parentdata=(void*) myparent3;
	    }
	  if (menuitem_toggleable[id][i])
	    {
	      parentdata *myparent4;
	      toggle=XcoCreateToggle(box,2+text_height/4,2+text_height/4,
				     text_height/2,text_height/2,
				     PIXEL(255,0,0),0,menuitem_activated[id][i]);
	      XcoAddCallback(toggle,event_menu);
	      XSelectInput(XcoGetDisplay(),XcoWindow(toggle),
			   ExposureMask|PointerMotionMask|ButtonPressMask|ButtonReleaseMask|OwnerGrabButtonMask|ButtonMotionMask);

	      myparent4=malloc(sizeof( parentdata));
	      myparent4->d=id+MAX_MENUS*i;
	      myparent4->box=box;
	      myparent4->triangle=triangle;
	      __objects[toggle]->parentdata=(void*) myparent4;
	    }
	  
	  myparent=malloc(sizeof( parentdata));
	  myparent->d=id+MAX_MENUS*i;
	  myparent->box=box;
	  myparent->triangle=triangle;
	  myparent2=malloc( sizeof(parentdata));
	  myparent2->d=id+MAX_MENUS*i;
	  myparent2->box=box;
	  myparent2->triangle=triangle;
	  __objects[m]->parentdata=(void*) myparent;
	  __objects[box]->parentdata=(void*) myparent2;

	}
      menu_item_object[id][i]=m;

    }
  if (top==1)
    {
      first_id=id;
      current_active_level=0;
      active_levels=0;
      current_active_id_i[active_levels]=id;
      old_active=0;
      active_x[active_levels]=x;
      active_y[active_levels]=y;

    }
}



void __SimpleCloseMenu(XcoMenu id)
{
  XcoDeleteObject(menu_object[id]);
}

static int active_menubar=-1;

void XcoOpenMenu(XcoObject parent,XcoMenu id,int x,int y,void(*callback)(int,int),void *parentdata)
{
  if (currently_active_menu)
    {
      XcoRemoveAnyMenu(-1,0);
    }
  currently_active_menu=1;
  mycallback=callback;
  __SimpleOpenMenu(parent,id,x,y,1,parentdata);
}


static int menubaritems;
static char **menubarnames;
static int *menubarids;
static XcoObject *menubar_object;


static void (*menubarcallback)(int,int,int);

void menuinternalcallback(int id,int i)
{
  if (active_menubar!=-1)
    XcoSetBox3DStatus(((parentdata*)(__objects[menubar_object[active_menubar]]->parentdata))->box,0);
  
  if (i!=-1)
    {
      menubarcallback(active_menubar,id,i);
    }
  active_menubar=-1;
}

static int mouse_xpress,mouse_ypress;

void event_menubar(XcoObject object,XEvent event)
{
  int d=((parentdata*)__objects[object]->parentdata)->d;  
  /* printf("Event menubar: %d\n",event.type); */
  switch(event.type)
    {
    case ButtonRelease:
      if ((event.xbutton.x==mouse_xpress) && (event.xbutton.y==mouse_ypress))
	{
	  /* printf("I will indeed keep your little menu\n"); */
	}
      else
	{
	  XcoRemoveAnyMenu(-1,0);
	}
      break;
    case ButtonPress:
      mouse_xpress=event.xbutton.x;
      mouse_ypress=event.xbutton.y;
    case MotionNotify:

      if (active_menubar!=d)
	{
	  int newx=0,newy=0;
	  int x,y;
	  int rx,ry;
	  Window wr,wc;
	  unsigned int mask;
	  XQueryPointer(XcoGetDisplay(),XcoWindow(object),&wr,&wc,&rx,&ry,&x,&y,&mask);
	  newx=rx-x;
	  newy=ry-y+__objects[object]->height+4;
	  
	  if (active_menubar!=-1)
	    XcoSetBox3DStatus(((parentdata*)(__objects[menubar_object[active_menubar]]->parentdata))->box,0);

	  XcoSetBox3DStatus(((parentdata*)(__objects[menubar_object[d]]->parentdata))->box,1);

      	  XcoOpenMenu(-1,
		      menubarids[d],newx,newy,menuinternalcallback,0);
	  /* open menu calls the remove callback if another menu is active
	   so we need to set active_menubar here... (took me a while to figure
	   out :-( ) */
	  active_menubar=d;
	}
      break;
    }
}


void XcoCreateMenubar(XcoObject parent,int x,int y,int width,int nr,char *names[],XcoMenu ids[],void(*callback)(int,int,int),int right_justify_last_item)
{
  int i;
  int text_height,height;
  int pos;
  int assign;
  XcoObject menuobj;
  
  XcoLabelFont(menufont);
  menubaritems=nr;
  menubarnames=malloc(sizeof( char*)*nr);
  menubarids=malloc(sizeof(int)*nr);
  menubar_object=malloc(sizeof(XcoObject)*nr);

  for (i=0; i<nr; i++)
    {
      int slen=strlen(names[i]);
      menubarnames[i]=malloc((slen+1));
      strcpy(menubarnames[i],names[i]);
      menubarids[i]=ids[i];
    }
  menubarcallback=callback;

  text_height=XcoTextHeight(menufont);
  height=text_height+8;
  menuobj=XcoCreateBox3D(parent,x,y,width,height,0,1);
  __objects[menuobj]->menuwidget=1;
  XcoSetResizeMethod(menuobj,XcoUpResize);
  pos=2;
  assign=menubaritems;
  if (right_justify_last_item)
    assign--;
  for (i=0; i<assign; i++)
    {
      XcoObject label;
      parentdata *myparent;
      int w=XcoTextWidth(menufont,menubarnames[i]);
      XcoObject box=XcoCreateBox3D(menuobj,pos,2,w+4,text_height+4,0,0);
      XcoSetResizeMethod(box,XcoUpLeft);
      label=XcoCreateLabel(box,2,2,menubarnames[i],w,text_height);
      pos+=w+4;
      myparent=malloc(sizeof( parentdata));
      myparent->d=i;
      myparent->box=box;
      __objects[label]->parentdata=(void*) myparent;
      menubar_object[i]=label;
      XcoAddCallback(label,event_menubar);
      XSelectInput(XcoGetDisplay(),XcoWindow(label),
		   ExposureMask|ButtonPressMask|ButtonMotionMask|OwnerGrabButtonMask|ButtonReleaseMask);
    }
  if (right_justify_last_item)
    {
      parentdata *myparent;
      XcoObject label;
      int w=XcoTextWidth(menufont,menubarnames[menubaritems-1]);
      XcoObject box=XcoCreateBox3D(menuobj,width-w-6,2,w+4,text_height+4,0,0);
      XcoSetResizeMethod(box,XcoUpRight);
      label=XcoCreateLabel(box,2,2,menubarnames[menubaritems-1],w,text_height);
      myparent=malloc(sizeof( parentdata));
      myparent->d=menubaritems-1;
      myparent->box=box;
      __objects[label]->parentdata=(void*) myparent;
      menubar_object[menubaritems-1]=label;
      XcoAddCallback(label,event_menubar);
      XSelectInput(XcoGetDisplay(),XcoWindow(label),
		   ExposureMask|ButtonPressMask|ButtonMotionMask|OwnerGrabButtonMask|ButtonReleaseMask);
    }
}
