/* This is label.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: label.c 2 2001-10-30 13:35:39Z daniels $";

#include <string.h>

#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"



static XFontStruct *labelfont;

void XcoLabelFont(XFontStruct *fstruct)
{
  labelfont=fstruct;
}

typedef struct
{
  char *str;
  XFontStruct *font;
} labeldata ;


void __expose_label(XcoObject id)
{
  XcoUseFont(id,((labeldata*)(__objects[id]->data))->font);
  XcoDrawFont(id,0,0,
	      ((labeldata*)(__objects[id]->data))->str,
	      __objects[id]->foreground);
}

void __label_callback(XcoObject id,XEvent event)
{
  if (event.type==Expose)
    __expose_label(id);

}

void XcoSetLabelString(XcoObject id,char *str)
{
  free ( ((labeldata*)(__objects[id]->data))->str );
  ((labeldata*)(__objects[id]->data))->str=malloc((strlen(str)+1));
  strcpy(((labeldata*)(__objects[id]->data))->str,str);
  XClearWindow(XcoGetDisplay(),XcoWindow(id));
  __expose_label(id);
}

XcoObject XcoCreateLabel(XcoObject parent,
			 int x,int y,char *str,int width,int height)
{
  labeldata *mylabeldata;
  XcoObject myobject;

  if ((width==0) && (height==0))
    {
      width=XcoTextWidth(labelfont,str);
      height=XcoTextHeight(labelfont);
    }

  myobject=XcoCreateWindow(x,y,width,height,
			   DEFAULT_BACKGROUND,
			   1,
			   parent);

  mylabeldata=malloc (sizeof(labeldata));
  mylabeldata->str=malloc((strlen(str)+1));
  strcpy(mylabeldata->str,str);
  mylabeldata->font=labelfont;

  __objects[myobject]->data=(void*) mylabeldata;
  __objects[myobject]->type=XcoTLabel;
  
  __expose_label(myobject);

  XcoAddCallback(myobject,__label_callback);

  return (myobject);
}

/* Remove all local data */
void __remove_label(XcoObject id)
{
  free( ((labeldata*)(__objects[id]->data))->str);
}
