/* This is filedialog.c
   A part of the Xco library
   Copyright (c) 1997-1998 Daniel Spangberg
    */

/*  
    POSIX dirent required!
    */

static char rcsid[]="$Id: filedialog.c 2 2001-10-30 13:35:39Z daniels $";


#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

#include <X11/Xlib.h>

#include "Xco.h"

#define COMMAND_HEIGHT 20
#define FILEDIALOG_SPACE 10
#define DIALOG_SPACE 50
#define FULLDIRDIALOG_XPOS FILEDIALOG_SPACE
#define FULLDIRDIALOG_YPOS FILEDIALOG_SPACE
#define DIRBOX_XPOS FULLDIRDIALOG_XPOS
#define DIRBOX_YPOS (FULLDIRDIALOG_YPOS+DIALOG_SPACE+2*FILEDIALOG_SPACE+COMMAND_HEIGHT)
#define DIRBOX_WIDTH 180
#define DIRBOX_HEIGHT 180
#define FILEBOX_XPOS 200
#define FILEBOX_YPOS DIRBOX_YPOS
#define FILEBOX_WIDTH 180
#define FILEBOX_HEIGHT DIRBOX_HEIGHT
#define DIALOG_XPOS DIRBOX_XPOS
#define DIALOG_WIDTH ((FILEBOX_XPOS+FILEBOX_WIDTH)-DIALOG_XPOS)
#define DIALOG_YPOS ((DIRBOX_YPOS+DIRBOX_HEIGHT+FILEDIALOG_SPACE))
#define DIALOG_HEIGHT 40
#define FILEDIALOG_WIDTH (FILEBOX_XPOS+FILEBOX_WIDTH+FILEDIALOG_SPACE*2)
#define FILEDIALOG_HEIGHT (DIALOG_YPOS+DIALOG_HEIGHT+COMMAND_HEIGHT+FILEDIALOG_SPACE+10)
#define COMMAND_YPOS (FILEDIALOG_HEIGHT-COMMAND_HEIGHT)
#define FILTER_YPOS (FULLDIRDIALOG_YPOS+DIALOG_SPACE+FILEDIALOG_SPACE)


static XcoObject filedialog_object,decorbox;
static XcoObject dialog;
static XcoObject fulldirdialog;
static XcoObject filebox,dirbox;

static int filedialog_open=0;
static int (*fd_callback)(char *filename);
static char *currentdir=NULL;
static int currentdiractive=0;
static char **dirs=NULL;
static char **files=NULL;
static int dirs_number,files_number;
static char *currentfilter;
static char **filterparam;
static char **filternames;
static int nfilters;

static void update_currentdir()
{
  if (currentdiractive==1)
    {
      free( currentdir);
      currentdir=NULL;
      currentdiractive=0;
    }
  if (currentdiractive==0)
    {
      int bufsize=256;
      while (currentdir==NULL)
	{
	  char *buf=malloc(bufsize);
	  currentdir=getcwd(buf,bufsize);
	  if (currentdir==NULL)
	    {
	      /* buffer too small or current directory not readable */
	      if (errno==ERANGE)
		{
		  free( buf);
		  bufsize+=256;
		  buf=malloc(bufsize);
		}
	      else
		{
		  currentdir=buf;
		  strcpy(currentdir,"/");
		}
	    }
	}
      currentdiractive=1;
    }
}

static int acceptfile(char *file,char *filter,int filterlen)
{
  if (filterlen!=0)
    {
      int filelen=strlen(file);
      if (filelen>=filterlen)
	{
	  char *cmp=file+filelen-filterlen;
	  if (strcmp(cmp,filter)==0)
	    return(1);
	  else
	    return(0);
	}
      else
	return(0);
    }
  else
    return (1);
}

typedef struct dirclist_t
{
  char *name;
  int isdir;
  struct dirclist_t *next;
} dirclist_t;

static void get_currentdir_contents(void)
{
  int filterlen=strlen(currentfilter);
  DIR *mydir;
  struct dirent *mydirent;
  /* printf("CURRENT FILTER: '%s'\n",currentfilter); */

  if (files!=NULL)
    {
      /* remove the old filedata */
      int ptr=0;
      while(files[ptr]!=NULL)
	{
	  free( files[ptr]);
	  ptr++;
	}
      free( files);
      files=NULL;
    }
  if (dirs!=NULL)
    {
      /* remove the old dirdata */
      int ptr=0;
      while(dirs[ptr]!=NULL)
	{
	  free( dirs[ptr]);
	  ptr++;
	}
      free( dirs);
      dirs=NULL;
    }
  mydir=opendir(currentdir);
  if (mydir!=NULL)
    {
      int filecnt=0,dircnt=0;
      int i;
      dirclist_t *dirclist=NULL,*tmp;
      do {
	mydirent=readdir(mydir);
	if (mydirent!=NULL)
	  {
	    struct stat buf;
	    stat(mydirent->d_name,&buf);
	    if (S_ISDIR(buf.st_mode))
	      {
		dirclist_t *new=malloc(sizeof(dirclist_t));
		new->next=dirclist;
		dirclist=new;
		new->name=malloc(strlen(mydirent->d_name)+1);
		strcpy(new->name,mydirent->d_name);
		new->isdir=1;
		dircnt++;
	      }
	    else if (acceptfile(mydirent->d_name,currentfilter,filterlen))
	      {
		dirclist_t *new=malloc(sizeof(dirclist_t));
		new->next=dirclist;
		dirclist=new;
		new->name=malloc(strlen(mydirent->d_name)+1);
		strcpy(new->name,mydirent->d_name);
		new->isdir=0;
		filecnt++;
	      }
	  }
      } while (mydirent!=NULL);
      closedir(mydir);
      files=malloc(sizeof( char*)*(filecnt+1));
      dirs=malloc(sizeof(char*)*(dircnt+1));
      tmp=NULL;
      files_number=0;
      dirs_number=0;
      while(dirclist!=NULL)
	{
	  tmp=dirclist;
	  dirclist=dirclist->next;
	  if (tmp->isdir)
	    {
	      dirs[dirs_number]=malloc(strlen(tmp->name)+1);
	      strcpy(dirs[dirs_number],tmp->name);
	      dirs_number++;
	    }
	  else
	    {
	      files[files_number]=malloc(strlen(tmp->name)+1);
	      strcpy(files[files_number],tmp->name);
	      files_number++;
	    }
	  free(tmp->name);
	  free(tmp);
	}
      files[files_number]=NULL;
      dirs[dirs_number]=NULL;
    }
  else
    {
      /* printf("Permission denied\n"); */
      /* should return null... */
      dirs_number=1;
      files_number=1;
      dirs=malloc(sizeof( char*)*2);
      files=malloc(sizeof(char*)*2);
      files[0]=malloc(20);
      files[1]=NULL;
      strcpy(files[0],"Permisson denied");
      dirs[0]=malloc(3);
      strcpy(dirs[0],"..");
      dirs[1]=NULL;
    }
  /*  printf("Dirs: %d, Files: %d\n",dirs_number,files_number); */
}

int mystrcmp(const void *p1, const void *p2)
{
  return strcmp(*(char **)p1, *(char **)p2);
}


static void update_dirloc()
{
  update_currentdir();
  get_currentdir_contents();
  qsort(dirs,dirs_number,sizeof(char*),mystrcmp);
  qsort(files,files_number,sizeof(char*),mystrcmp);
  XcoSetListData(dirbox,dirs,dirs_number);  
  XcoSetListData(filebox,files,files_number);  
  XcoSetDialogValue(fulldirdialog,currentdir);
}

static void filefulldirdialogenter(XcoObject id,XEvent event)
{
  if (XcoDialogEnter(id,event))
    {
      if (chdir(XcoGetDialogValue(id))==0)
	{
	  update_dirloc();
	}
    }
}

static void dir_fd_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int pos;
      if ((pos=XcoGetListStatus(id))!=-1)
	{
	  /* printf("filedialog call dir select\n"); */
	  /* descend and update dir and file lists */
	  
	  if (chdir(dirs[pos])==0)
	    {
	      update_dirloc();
	    }
	}
    }
}



static void file_fd_callback(XcoObject id,XEvent event)
{
  if (event.type==ButtonPress)
    {
      int pos;
      if ((pos=XcoGetListStatus(id))!=-1)
	{
	  /* printf("filedialog call file select\n"); */
	  XcoSetDialogValue(dialog,files[pos]);
	}
    }
}


static void filedialog_delete()
{
  int i;
  /* printf("deleted...\n"); */
  
  for (i=0; i<nfilters; i++)
    {
      free( filternames[i]);
      free (filterparam[i] );
    }
  free( filternames);
  free(filterparam);
  XcoDeleteObject(filedialog_object);
  filedialog_open=0;
}

static void fd_cancel_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      filedialog_delete();
    }
}

static void fd_ok_callback(XcoObject dummy,XEvent event)
{
  if (event.type==ButtonPress)
    {
      char *fname=XcoGetDialogValue(dialog);
      if (fd_callback(fname))
	{
	  /* accepted. close... */
	  filedialog_delete();
	}
    }
}

static void fd_dw_callback(XcoObject id,XEvent event)
{
  if (XcoDeleteWindow(id,event))
    filedialog_delete();
}


static void filedialogenter(XcoObject id, XEvent event)
{
  if (XcoDialogEnter(id,event))
    if (fd_callback(XcoGetDialogValue(id)))
      {
	/* accepted. close... */
	filedialog_delete();
      }
}




static void plist_callback(XcoObject id,XEvent dummy)
{
  int action=XcoGetPulldownListStatus(id);
  if (action!=-1)
    {
      currentfilter=filterparam[action];
      update_dirloc();
    }
}

void XcoFileDialog(char *windowname,char *okbuttonname,char **filters,int no_filters,int (*callback)(char *filename))
{
  if (filedialog_open==0)
    {
      int i,k,xpos,ypos;
      XcoObject hole,flabel,dlabel,okbutton,cancelbutton,filterlabel,plist;
      nfilters=no_filters;
      fd_callback=callback;
      filterparam=malloc(sizeof( char*)*nfilters);

      for (i=0; i<nfilters;i++)
	{
	  filterparam[i]=malloc((strlen(filters[i])+1));
	  strcpy(filterparam[i],filters[i]);
	}

      currentfilter=filterparam[0];
      update_currentdir();
      get_currentdir_contents();

      filedialog_object=XcoCreateDialogParent(-1,0,0,FILEDIALOG_WIDTH,FILEDIALOG_HEIGHT);

      XStoreName(XcoGetDisplay(),XcoWindow(filedialog_object),windowname);

      XcoAddCallback(filedialog_object,fd_dw_callback);

      decorbox=XcoCreateBox3D(filedialog_object,5,5,FILEDIALOG_WIDTH-10,COMMAND_YPOS-10,2,1);

      hole=XcoCreateHole(decorbox,DIRBOX_XPOS,DIRBOX_YPOS,
				   FILEBOX_WIDTH+FILEBOX_XPOS-DIRBOX_XPOS,
				   FILEBOX_HEIGHT);

      qsort(dirs,dirs_number,sizeof(char*),mystrcmp);
      dirbox=XcoCreateList(hole,0,0,
			   DIRBOX_WIDTH,DIRBOX_HEIGHT,20,dirs,dirs_number);

      qsort(files,files_number,sizeof(char*),mystrcmp);
      filebox=XcoCreateList(hole,
			    FILEBOX_XPOS-DIRBOX_XPOS,
			    FILEBOX_YPOS-DIRBOX_YPOS,
			    FILEBOX_WIDTH,FILEBOX_HEIGHT,
			    20,files,files_number);
      

      XcoSetResizeMethod(hole,XcoUpLeftDownRight);

      XcoAddCallback(dirbox,dir_fd_callback);

      flabel=XcoCreateLabel(decorbox,
				      DIALOG_XPOS,DIALOG_YPOS,
				      "Filename",0,0);

      XcoSetResizeMethod(flabel,XcoDownLeft);

      XcoAddCallback(filebox,file_fd_callback);

      ypos=XcoGetObjectHeight(flabel);
      dialog=XcoCreateDialog(decorbox,
			     DIALOG_XPOS,DIALOG_YPOS+ypos,filedialog_object,
			     "",512,DIALOG_WIDTH,0);
      
      XcoSetResizeMethod(dialog,XcoDownResize);

      XcoAddCallback(dialog,filedialogenter);

      dlabel=XcoCreateLabel(decorbox,
				      FULLDIRDIALOG_XPOS,FULLDIRDIALOG_YPOS,
				      "Directory",0,0);

      XcoSetResizeMethod(dlabel,XcoUpLeft);

      ypos=XcoGetObjectHeight(dlabel);
      fulldirdialog=XcoCreateDialog(decorbox,
				    FULLDIRDIALOG_XPOS,
				    FULLDIRDIALOG_YPOS+ypos,filedialog_object,
				    currentdir,512,DIALOG_WIDTH,0);

      XcoSetResizeMethod(fulldirdialog,XcoUpResize);

      XcoAddCallback(fulldirdialog,filefulldirdialogenter);      

      okbutton=XcoCreateCommand(filedialog_object,
					  FILEDIALOG_SPACE,
					  COMMAND_YPOS,
					  okbuttonname,0,0);
      
      XcoSetResizeMethod(okbutton,XcoDownLeft);

      XcoAddCallback(okbutton,fd_ok_callback);


      xpos=XcoGetObjectWidth(okbutton);

      cancelbutton=XcoCreateCommand(filedialog_object,
					      FILEDIALOG_SPACE*2+xpos,
					      COMMAND_YPOS,
					      "Cancel",0,0);

      XcoSetResizeMethod(cancelbutton,XcoDownLeft);

      XcoAddCallback(cancelbutton,fd_cancel_callback);

      filterlabel=XcoCreateLabel(decorbox,FILEDIALOG_SPACE,FILTER_YPOS,"Filter:",0,0);

      XcoSetResizeMethod(filterlabel,XcoUpLeft);

      xpos=XcoGetObjectWidth(filterlabel)+XcoGetObjectX(filterlabel)+FILEDIALOG_SPACE;
      filternames=malloc(sizeof( char*)*nfilters);
      
      for (k=0; k<nfilters; k++)
	{
	  int l=strlen(filters[k]);
	  filternames[k]=malloc((l+2));
	  filternames[k][0]='*';
	  strcpy(filternames[k]+1,filters[k]);
	}


      plist=XcoCreatePulldownList(decorbox,xpos,FILTER_YPOS,filternames,no_filters,0,0,0);
      
      XcoSetResizeMethod(plist,XcoUpLeft);

      XcoAddCallback(plist,plist_callback);

      filedialog_open=1;
    }
  else
    {
      XRaiseWindow(XcoGetDisplay(),XcoWindow(filedialog_object));
    }
}




