/* This is dialog.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */


static char rcsid[]="$Id: dialog.c 16 2012-01-23 17:31:49Z daniels $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>

#include "Xco.h"

static void __dialog_set_has_cursor(XcoObject id,int hasit);
void __dialog_callback(XcoObject id,XEvent event);


typedef struct __dialogparentlist
{
  XcoObject dialog;
  struct __dialogparentlist *next;
} dialogparentlist;


typedef struct dialogparentdata
{
  XcoObject current_active;
  dialogparentlist *list;
} dialogparentdata;

void __dialogparent_callback(XcoObject id, XEvent event)
{
  if (event.type==KeyPress)
    {
      if (((dialogparentdata*)(__objects[id]->data))->current_active!=-1)
	{
	  int length;
	  char keyb_buffer[20];
	  KeySym keysym;
	  XComposeStatus composestatus;

	  /* printf("I have an active dialog:%d\n",(((dialogparentdata*)(__objects[id]->data))->current_active)); */
	  /* Pass this event forward (unless it is the TAB) */
	  length=XLookupString(&event.xkey,keyb_buffer,1,
			       &keysym,&composestatus);
	  keyb_buffer[length]='\0';
	  if(keysym==XK_Tab)
	    {
	      dialogparentdata *mydata=(dialogparentdata*)(__objects[id]->data);
	      dialogparentlist *mylist=mydata->list;
	      /* printf("Got TAB\n"); */
	      if (mylist!=NULL)
		{
		  XcoObject first_one=mylist->dialog;
		  if (first_one==mydata->current_active)
		    {
		      /* Find the last one */
		      while ((mylist->next!=NULL))
			{
			  mylist=mylist->next;
			}
		      __dialog_set_has_cursor(mylist->dialog,1);
		    }
		  else
		    {
		      XcoObject prev=mylist->dialog;
		      while ((mylist->next!=NULL) && (mylist->dialog!=mydata->current_active))
			{
			  prev=mylist->dialog;
			  mylist=mylist->next;
			}
		      __dialog_set_has_cursor(prev,1);
		    }


		}
	    }
	  else
	    XcoExecuteCallbacks(((dialogparentdata*)(__objects[id]->data))->current_active,event);
	}
    }
}

XcoObject XcoCreateNamedDialogParent(XcoObject parent,
				     int x,int y,int width,int height,
				     char *name)
{
  dialogparentdata *mydpdata;
  XcoObject myobject=XcoCreateNamedWindow(x,y,width,height,
					  DEFAULT_BACKGROUND,
					  1,
					  parent,name);

  if (parent==-1)
    XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
		 ExposureMask|ButtonPressMask|KeyPressMask|StructureNotifyMask);
  else
    XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
		 ExposureMask|ButtonPressMask|KeyPressMask);
    

  mydpdata=malloc(sizeof(dialogparentdata));
  mydpdata->list=NULL;
  mydpdata->current_active=-1;

  __objects[myobject]->data=(void*) mydpdata;
  __objects[myobject]->type=XcoTDialogParent;
  
  XcoAddCallback(myobject,__dialogparent_callback);

  return (myobject);
}

XcoObject XcoCreateDialogParent(XcoObject parent,
				int x,int y,int width,int height)
{
  return XcoCreateNamedDialogParent(parent,x,y,width,height,"");
}

void __register_dialog(XcoObject dialogparent,XcoObject dialog)
{
  dialogparentdata *mydata=(dialogparentdata*)(__objects[dialogparent]->data);
  dialogparentlist *newlist=malloc(sizeof(dialogparentlist));
  /* printf("Registering for parent %d: %d\n",dialogparent,dialog); */
  newlist->dialog=dialog;
  newlist->next=mydata->list;
  mydata->list=newlist;
}

void __dialogparent_move_focus(XcoObject dialogparent,XcoObject dialog)
{
  dialogparentdata *mydata=(dialogparentdata*)(__objects[dialogparent]->data);
  dialogparentlist *mylist=mydata->list;
  /* printf("Moving focus for parent %d to %d\n",dialogparent,dialog); */
  if (mylist!=NULL)
    {
      if (mylist->dialog!=dialog)
	__dialog_set_has_cursor(mylist->dialog,0);
      /* printf("Found dialog:%d\n",mylist->dialog); */
       while (mylist->next!=NULL)
	{
	  mylist=mylist->next;
	  if (mylist->dialog!=dialog)
	    __dialog_set_has_cursor(mylist->dialog,0);
	  /* printf("Found dialog:%d\n",mylist->dialog); */
	}
      mydata->current_active=dialog;
    }
}

void __remove_dialogparent(XcoObject id)
{
  dialogparentdata *mydata=(dialogparentdata*)(__objects[id]->data);
  dialogparentlist *mylist=mydata->list;
  while (mylist!=NULL)
    {
      dialogparentlist *t2=mylist->next;
      free( mylist);
      mylist=t2;
    }
}


static XFontStruct *dialogfont;

void XcoDialogFont(XFontStruct *fstruct)
{
  dialogfont=fstruct;
}

typedef struct
{
  char *str;
  int maxchars;
  int cursor_position;
  int has_cursor;
  XcoObject dialogparent;
} dialogdata;


void __expose_dialog(XcoObject id)
{
  int width;
  XClearWindow(XcoGetDisplay(),XcoWindow(id));
  XcoUseFont(id,dialogfont);
  XcoDrawFont(id,2,2,
	      ((dialogdata*)(__objects[id]->data))->str,
	      __objects[id]->foreground);
  XcoDrawInverted3DBox(id,0,0,
		       __objects[id]->width,
		       __objects[id]->height);

  width=XTextWidth(dialogfont,
		       ((dialogdata*)(__objects[id]->data))->str,
		       ((dialogdata*)(__objects[id]->data))->cursor_position)+2;
  XSetForeground(XcoGetDisplay(),XcoGC(id),
		 XcoGetPixel32(0,0,__objects[id]->foreground));

  if (((dialogdata*)(__objects[id]->data))->has_cursor)
    XDrawLine(XcoGetDisplay(),XcoWindow(id),XcoGC(id),
	      width,2,width,__objects[id]->height-3);
}

static void __dialog_set_has_cursor(XcoObject id,int hasit)
{
  /* printf("Setting cursor=%d for %d\n",hasit,id); */
  ((dialogdata*)(__objects[id]->data))->has_cursor=hasit;
  if (hasit==1)
    __dialogparent_move_focus(((dialogdata*)(__objects[id]->data))->dialogparent,id);
  __expose_dialog(id);
}


void __dialog_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_dialog(id);
      break;
    case ButtonPress:
    case MotionNotify:
      {
	int maxlen,i,x;
	__dialog_set_has_cursor(id,1);
	maxlen=strlen(((dialogdata*)(__objects[id]->data))->str);
	i=0;
	if (event.type==ButtonPress)
	  x=event.xbutton.x-2;
	else
	  x=event.xmotion.x-2;

	while ((XTextWidth(dialogfont,
			   ((dialogdata*)(__objects[id]->data))->str,
			   i)<x) && (i<maxlen))
	  i++;
	((dialogdata*)(__objects[id]->data))->cursor_position=i;
      }
      __expose_dialog(id);
      break;
    case KeyPress:
      {
	int length;
	char keyb_buffer[20];
	KeySym keysym;
	XComposeStatus composestatus;
	length=XLookupString(&event.xkey,keyb_buffer,1,
			     &keysym,&composestatus);
	keyb_buffer[length]='\0';
	switch(keysym)
	  {
	  case XK_Left:
	    ((dialogdata*)(__objects[id]->data))->cursor_position--;
	    if (((dialogdata*)(__objects[id]->data))->cursor_position<0)
	      ((dialogdata*)(__objects[id]->data))->cursor_position=0;
	    break;
	  case XK_Right:
	    ((dialogdata*)(__objects[id]->data))->cursor_position++;
	    if ((unsigned int)((dialogdata*)(__objects[id]->data))->cursor_position>
		strlen(((dialogdata*)(__objects[id]->data))->str))
	      ((dialogdata*)(__objects[id]->data))->cursor_position=
		strlen(((dialogdata*)(__objects[id]->data))->str);
	    break;
	  case XK_BackSpace:
	    if (((dialogdata*)(__objects[id]->data))->cursor_position>0)
	      {
		memmove(((dialogdata*)(__objects[id]->data))->str+
			((dialogdata*)(__objects[id]->data))->cursor_position-1,
			((dialogdata*)(__objects[id]->data))->str+
			((dialogdata*)(__objects[id]->data))->cursor_position,
			strlen(((dialogdata*)(__objects[id]->data))->str)-
			((dialogdata*)(__objects[id]->data))->cursor_position+1);
		((dialogdata*)(__objects[id]->data))->cursor_position--;
	      }
	    break;
	  case XK_Delete:
	    if ((unsigned int)((dialogdata*)(__objects[id]->data))->cursor_position<
		strlen(((dialogdata*)(__objects[id]->data))->str))
	      {
		memmove(((dialogdata*)(__objects[id]->data))->str+
			((dialogdata*)(__objects[id]->data))->cursor_position,
			((dialogdata*)(__objects[id]->data))->str+
			((dialogdata*)(__objects[id]->data))->cursor_position+1,
			strlen(((dialogdata*)(__objects[id]->data))->str)-
			((dialogdata*)(__objects[id]->data))->cursor_position+1);
	      }
	    break;
	  case XK_Return:
	    break;
	  default:
	    if (length!=0)
	      {
		if (strlen(((dialogdata*)(__objects[id]->data))->str)<
		    (unsigned int)((dialogdata*)(__objects[id]->data))->maxchars)
		  {
		    memmove(((dialogdata*)(__objects[id]->data))->str+
			    ((dialogdata*)(__objects[id]->data))->cursor_position+1,
			    ((dialogdata*)(__objects[id]->data))->str+
			    ((dialogdata*)(__objects[id]->data))->cursor_position,
			    strlen(((dialogdata*)(__objects[id]->data))->str)-
			    ((dialogdata*)(__objects[id]->data))->cursor_position+1);
		    ((dialogdata*)(__objects[id]->data))->str[((dialogdata*)(__objects[id]->data))->cursor_position]=keyb_buffer[0];
		    ((dialogdata*)(__objects[id]->data))->cursor_position++;
		  }
	      }
	    break;
	  }


      }
      __expose_dialog(id);
      break;
    }
}


char *XcoGetDialogValue(XcoObject id)
{
  return (((dialogdata*)(__objects[id]->data))->str);
}

void XcoSetDialogValue(XcoObject id,char *str)
{
  strcpy(((dialogdata*)(__objects[id]->data))->str,str);
  ((dialogdata*)(__objects[id]->data))->cursor_position=strlen(str); 
 __expose_dialog(id);
}

int XcoDialogEnter(XcoObject dummy, XEvent event)
{
  int r=0;
  if (event.type==KeyPress)
    {
      int length;
      char keyb_buffer[2];
      KeySym keysym;
      XComposeStatus composestatus;
      length=XLookupString(&event.xkey,keyb_buffer,1,
			   &keysym,&composestatus);
      keyb_buffer[length]='\0';
      if (keysym==XK_Return)
	r=1;
    }
  return r;
}


XcoObject XcoCreateDialog(XcoObject parent,
			  int x,int y,XcoObject dialogparent,
			  char *str,int maxchars,
			  int width,int height)
{
  XcoObject myobject;
  dialogdata *mydialogdata;
  if (width==0)
      width=XcoTextWidth(dialogfont,str)+4;
  if (height==0)
      height=XcoTextHeight(dialogfont)+4;

  
  myobject=XcoCreateWindow(x,y,width,height,
#if 0
			   DEFAULT_BACKGROUND,
#else
			   PIXEL(255,255,255),
#endif
			   1,
			   parent);

  XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
	       ExposureMask|ButtonPressMask|ButtonMotionMask);

  mydialogdata=malloc(sizeof(dialogdata));
  mydialogdata->str=malloc((maxchars+1));
  strcpy(mydialogdata->str,str);
  mydialogdata->maxchars=maxchars;
  mydialogdata->cursor_position=strlen(str);
  mydialogdata->has_cursor=0;
  mydialogdata->dialogparent=dialogparent;

  __objects[myobject]->data=(void*) mydialogdata;
  __objects[myobject]->type=XcoTDialog;
  
  __expose_dialog(myobject);

  XcoAddCallback(myobject,__dialog_callback);
  
  __register_dialog(dialogparent,myobject);

  return (myobject);
}

/* Remove all local data */
void __remove_dialog(XcoObject id)
{
  free( ((dialogdata*)(__objects[id]->data))->str);
}


