/* This is command.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: command.c 2 2001-10-30 13:35:39Z daniels $";

#include <string.h>
#include <stdlib.h>

#include <X11/Xlib.h>

#include "Xco.h"

static XFontStruct *commandfont;

void XcoCommandFont(XFontStruct *fstruct)
{
  commandfont=fstruct;
}

typedef struct
{
  char *str;
  int pressed;
} commanddata ;


void __expose_command(XcoObject id)
{
  int tposx,tposy,twidth,theight;
  twidth=XcoTextWidth(commandfont,
			  ((commanddata*)(__objects[id]->data))->str);
  theight=XcoTextHeight(commandfont);
  XcoUseFont(id,commandfont);

  tposx=2+((__objects[id]->width-4)-twidth)/2;
  tposy=2+((__objects[id]->height-4)-theight)/2;
  XcoDrawFont(id,tposx,tposy,
	      ((commanddata*)(__objects[id]->data))->str,
	      __objects[id]->foreground);
  if (((commanddata*)(__objects[id]->data))->pressed)
    {
      XcoDrawInverted3DBox(id,0,0,
			   __objects[id]->width,
			   __objects[id]->height);
    }
  else
    {
      XcoDraw3DBox(id,0,0,
		   __objects[id]->width,
		   __objects[id]->height);
    }
}

void __command_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_command(id);
      break;
    case ButtonPress:
      ((commanddata*)(__objects[id]->data))->pressed=1;
      __expose_command(id);
      break;
    case ButtonRelease:
      ((commanddata*)(__objects[id]->data))->pressed=0;
      __expose_command(id);
      break;
    }
}

XcoObject XcoCreateCommand(XcoObject parent,
			   int x,int y,char *str,int width,int height)
{
  commanddata *mycommanddata;
  XcoObject myobject;
  if ((width==0) && (height==0))
    {
      width=XcoTextWidth(commandfont,str)+4;
      height=XcoTextHeight(commandfont)+4;
    }

  myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
	       ExposureMask|ButtonPressMask|ButtonReleaseMask);

  mycommanddata=malloc(sizeof(commanddata));
  mycommanddata->str=malloc((strlen(str)+1));
  strcpy(mycommanddata->str,str);
  mycommanddata->pressed=0;

  __objects[myobject]->data=(void*) mycommanddata;
  __objects[myobject]->type=XcoTCommand;
  
  __expose_command(myobject);

  XcoAddCallback(myobject,__command_callback);

  return (myobject);
}

/* Remove all local data */
void __remove_command(XcoObject id)
{
  free ( ((commanddata*)(__objects[id]->data))->str);
}
