/* This is colorselbox.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

static char rcsid[]="$Id: colorselbox.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>


#include "Xco.h"

typedef struct
{
  float fx,fy;
  int r,g,b;
  int r1,g1,b1;
  int r2,g2,b2;
  int r3,g3,b3;
  int squared;
} colorselboxdata;

static uint32 __XcoGetColorselboxColor(XcoObject id,float fx,float fy)
{
  float l0,l1,l2,l3,l;
  int r=((colorselboxdata*)(__objects[id]->data))->r;
  int g=((colorselboxdata*)(__objects[id]->data))->g;
  int b=((colorselboxdata*)(__objects[id]->data))->b;
  int r1=((colorselboxdata*)(__objects[id]->data))->r1;
  int g1=((colorselboxdata*)(__objects[id]->data))->g1;
  int b1=((colorselboxdata*)(__objects[id]->data))->b1;
  int r2=((colorselboxdata*)(__objects[id]->data))->r2;
  int g2=((colorselboxdata*)(__objects[id]->data))->g2;
  int b2=((colorselboxdata*)(__objects[id]->data))->b2;
  int squared=((colorselboxdata*)(__objects[id]->data))->squared;
  int r3=255-r;
  int g3=255-g;
  int b3=255-b;
#if 1
  fx=1-fx;
  fy=1-fy;
#endif

  if (squared)
    {
      l0=1-(fx*fx+fy*fy);
      l1=1-((1-fx)*(1-fx)+fy*fy);
      l2=1-(fx*fx+(1-fy)*(1-fy));
      l3=1-((1-fx)*(1-fx)+(1-fy)*(1-fy));
      l=(l0+l1+l2+l3);
      l=1;
    }
  else
    {
      l0=1-sqrt(fx*fx+fy*fy);
      l1=1-sqrt((1-fx)*(1-fx)+fy*fy);
      l2=1-sqrt(fx*fx+(1-fy)*(1-fy));
      l3=1-sqrt((1-fx)*(1-fx)+(1-fy)*(1-fy));
      l=1;
    }

  l0*=l;
  l1*=l;
  l2*=l;
  l3*=l;

  r=r*l0+r1*l1+r2*l2+r3*l3;
  g=g*l0+g1*l1+g2*l2+g3*l3;
  b=b*l0+b1*l1+b2*l2+b3*l3;




  if (r>255)
    r=255;
  if (r<0)
    r=0;
  if (g>255)
    g=255;
  if (g<0)
    g=0;
  if (b>255)
    b=255;
  if (b<0)
    b=0;


  return (PIXEL(r,g,b));
}

uint32 XcoGetColorselboxColor(XcoObject id)
{
  return (__XcoGetColorselboxColor(id,
				   ((colorselboxdata*)(__objects[id]->data))->fx,
				   ((colorselboxdata*)(__objects[id]->data))->fy));
}


static void __expose_colorselbox(XcoObject id)
{
  uint32 *mycbox;
  int iy,ix;
  Pixmap mypixmap;
  XPoint pts[2];
  int height=__objects[id]->height;
  int width=__objects[id]->width;
  int x=(int)(((colorselboxdata*)(__objects[id]->data))->fx*(width-1));
  int y=(int)(((colorselboxdata*)(__objects[id]->data))->fy*(height-1));
  if (x>(width-1))
    x=width-1;
  if (x<0)
    x=0;
  if (y>(height-1))
    y=height-1;
  if (y<0)
    y=0;

  mycbox=malloc(sizeof( uint32)*(width*height));
  for (iy=0; iy<height; iy++)
    for (ix=0; ix<width; ix++)
      {
	mycbox[iy*width+ix]=__XcoGetColorselboxColor(id,
						     (float)(ix)/(width-1),
						     (float)(iy)/(height-1));
      }
  mypixmap=XcoCreatePixmapFromImage(id,mycbox,width,height);
  free( mycbox);
  XcoSetBackgroundPixmap(id,mypixmap,False);
  XFreePixmap(XcoGetDisplay(),mypixmap);
  pts[0].x=x-3;
  pts[0].y=y;
  pts[1].x=x-1;
  pts[1].y=y;
  XcoDrawPolyLine(id,pts,2,PIXEL(0,0,0));
  pts[0].x=x+1;
  pts[0].y=y;
  pts[1].x=x+3;
  pts[1].y=y;
  XcoDrawPolyLine(id,pts,2,PIXEL(0,0,0));
  pts[0].x=x;
  pts[0].y=y-3;
  pts[1].x=x;
  pts[1].y=y-1;
  XcoDrawPolyLine(id,pts,2,PIXEL(0,0,0));
  pts[0].x=x;
  pts[0].y=y+1;
  pts[1].x=x;
  pts[1].y=y+3;
  XcoDrawPolyLine(id,pts,2,PIXEL(0,0,0));
}

void XcoSetColorselboxColor(XcoObject id,int r,int g,int b)
{
  ((colorselboxdata*)(__objects[id]->data))->r=r;
  ((colorselboxdata*)(__objects[id]->data))->g=g;
  ((colorselboxdata*)(__objects[id]->data))->b=b;
  ((colorselboxdata*)(__objects[id]->data))->fx=1;
  ((colorselboxdata*)(__objects[id]->data))->fy=1;
  __expose_colorselbox(id);
}

void XcoSetColorselboxMode(XcoObject id,int squared)
{
  ((colorselboxdata*)(__objects[id]->data))->squared=squared;
  __expose_colorselbox(id);
}

static void __colorselbox_callback(XcoObject id,XEvent event)
{
  switch (event.type)
    {
    case Expose:
      __expose_colorselbox(id);
      break;
    case ButtonPress:
    case MotionNotify:
      {
	int x,y;
	float fx,fy;
	if (event.type==ButtonPress)
	  {
	    x=event.xbutton.x;
	    y=event.xbutton.y;
	  }
	else
	  {
	    x=event.xmotion.x;
	    y=event.xmotion.y;
	  }
	fx=(float)(x)/(float)((__objects[id]->width-1));
	fy=(float)(y)/(float)((__objects[id]->height-1));
	if (fx<0)
	  fx=0;
	if (fx>1)
	  fx=1;
	if (fy<0)
	  fy=0;
	if (fy>1)
	  fy=1;

	((colorselboxdata*)(__objects[id]->data))->fx=fx;
	((colorselboxdata*)(__objects[id]->data))->fy=fy;
	__expose_colorselbox(id);
      }
      break;
    }
}

XcoObject XcoCreateColorselbox(XcoObject parent,
			       int x,int y,int width,int height,
			       int r,int g,int b,
			       int r1,int g1,int b1,
			       int r2,int g2,int b2,
			       float xpos,float ypos,int squared)
{
  colorselboxdata *mycolorselbox;
  XcoObject myobject=XcoCreateWindow(x,y,width,height,
				     DEFAULT_BACKGROUND,
				     1,
				     parent);

  XSelectInput(XcoGetDisplay(),XcoWindow(myobject),
	       ExposureMask|ButtonPressMask|ButtonMotionMask);

  mycolorselbox=malloc(sizeof( colorselboxdata));

  mycolorselbox->fx=xpos;
  mycolorselbox->fy=ypos;
  mycolorselbox->r=r;
  mycolorselbox->g=g;
  mycolorselbox->b=b;
  mycolorselbox->r1=r1;
  mycolorselbox->g1=g1;
  mycolorselbox->b1=b1;
  mycolorselbox->r2=r2;
  mycolorselbox->g2=g2;
  mycolorselbox->b2=b2;
  mycolorselbox->squared=squared;

  __objects[myobject]->data=(void*) mycolorselbox;
  __objects[myobject]->type=XcoTColorselbox;
  
  __expose_colorselbox(myobject);

  XcoAddCallback(myobject,__colorselbox_callback);

  return (myobject);
}

