/* This is cimage.c
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg

   */

static char rcsid[]="$Id: cimage.c 2 2001-10-30 13:35:39Z daniels $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include "Xco.h"

void XcoWriteCimage(char *filename,int xsize,int ysize,unsigned int *buffer,char *image_name)
{
  FILE *outfile;
  outfile=fopen(filename,"w");
  if (outfile!=NULL)
    {
      unsigned int *myptr;
      int line_count,ywrite,xwrite;
      fprintf(outfile,"#define %s_width %d\n#define %s_height %d\n",
	      image_name,xsize,image_name,ysize);
      fprintf(outfile,"static unsigned char %s_cimage[]={\n",
	      image_name);

      myptr=buffer;
      line_count=0;
      for (ywrite=0; ywrite<ysize; ywrite++)
	for (xwrite=0; xwrite<xsize; xwrite++)
	  {
	    unsigned int pixel=*myptr++;
	    fprintf(outfile,"%d,%d,%d, ",
		    (pixel & 0xFF),
		    ((pixel>>8) & 0xFF),
		    ((pixel>>16) & 0xFF));
	    line_count++;
	    if (line_count==4)
	      {
		fprintf(outfile,"\n");
		line_count=0;
	      }
	  }
      fprintf(outfile,"};\n");
      fclose(outfile);
    }
  else
    {
      fclose(outfile);
    }
}

unsigned int *XcoCimageToImage(unsigned char *data,int xsize,int ysize)
{
  int x,y;
  unsigned int *ptr=malloc(sizeof( unsigned int)*(xsize*ysize));
  unsigned int *toptr=ptr;
  for (y=0; y<ysize; y++)
    for (x=0; x<xsize; x++)
      {
	int r,g,b;
	r=*data++;
	g=*data++;
	b=*data++;
	*toptr++=r|(g<<8)|(b<<16);
      }
  return(ptr);
}

