/* This is Xco.h
   A part of the Xco library
   Copyright (C) 1997-1998 Daniel Spangberg
   */

/*
  $Log$
  Revision 1.2  2003/05/20 11:37:20  daniels
  Added setting of list selection.

  Revision 1.1.1.1  2001/10/30 13:35:40  daniels
  Initial checkin

  Revision 1.24  1998/06/23 10:53:11  daniels
  *** empty log message ***

  Revision 1.23  1998/06/22 16:37:27  daniels
  ***empty log message***

  Revision 1.22  1998/04/23 22:01:20  daniels
  Added XcoCreateMenuWithID

  Revision 1.21  1998/04/22 22:02:52  daniels
  Changed MAX_MENUS to 1024

  Revision 1.20  1998/04/20 22:00:29  daniels
  Added XcoChangeMenu

  Revision 1.19  1998/03/15 17:15:16  daniels
  Fixed (?) bug with not honouring the pad field in Image

  Revision 1.18  1998/02/27 00:00:45  daniels
  Added XcoGetReversePixel

  Revision 1.17  1998/01/19 17:28:38  daniels
  Added support for C++

  Revision 1.16  1998/01/19 10:39:07  daniel
  Changed everything from C++ to C

  Revision 1.15  1998/01/18 16:50:49  daniel
  Removed all default parameters.

  Revision 1.14  1998/01/10 15:54:31  daniels
  Added the datatypes

  Revision 1.13  1998/01/10 02:20:52  daniels
  Added possibility to attach menus that are already prepared as submenus.

  Revision 1.12  1998/01/05 19:40:54  daniels
  Added XcoQueryOpenGLSupport

  Revision 1.11  1998/01/03 16:00:00  daniels
  Added XcoGetGLXContext

  Revision 1.10  1997/12/20 16:08:08  daniels
  Changed to dynamic memory handling of objects.

  Revision 1.9  1997/12/12 00:28:08  daniels
  Added better dialog management

  Revision 1.8  1997/12/09 15:57:46  daniels
  Added decorated box

  Revision 1.7  1997/11/30 23:10:34  daniels
  Changed returntype for XcoColorselector to XcoObject from void

  Revision 1.6  1997/11/30 21:52:39  daniels
  Added color selector and color selector dialog window

  Revision 1.5  1997/11/22 16:17:49  daniels
  Added embryo of color selector

  Revision 1.4  1997/11/22 02:28:17  daniels
  Added simplest part of color selector

  Revision 1.3  1997/11/10 22:59:40  daniels
  Added a few functions to be able to use Xco with moviemol

  Revision 1.2  1997/10/22 20:41:50  daniels
  removed rcsid from source

  Revision 1.1  1997/10/22 20:31:47  daniels
  Initial revision

  */


#ifndef __Xco__
#define __Xco__

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/X.h>

#define BITS_PER_BYTE 8
#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
typedef unsigned char uint8;
typedef unsigned short int uint16;
typedef unsigned int uint32;
typedef int int32;
typedef short int16;
typedef char int8;

#define MAX_MENUS 1024

typedef int XcoObject;
typedef int XcoMenu;
typedef int XcoType;

typedef struct ___XcoCallback
{
  void (*callback)(XcoObject id,XEvent event);
  struct ___XcoCallback *next;
} _XcoCallback ;


typedef struct
{
  XcoObject id;
  XcoObject parent;
  XcoType type;
  int x,y;
  int height,width;
  int orig_x,orig_y;
  int orig_height,orig_width;
  int resize;
  int background;
  int foreground;
  int menuwidget;
  _XcoCallback *callbacklist;
  Window window;
  GC gc;
  Atom dw;
  void *data;
  void *parentdata;
} _XcoObject ;

#ifndef __object__

extern int *__used_objects;
extern _XcoObject **__objects;
extern int MAX_OBJECTS;

#endif


/* types */
#define XcoTWindow 0
#define XcoTCommand 1
#define XcoTLabel 2
#define XcoTHole 3
#define XcoTDialog 4
#define XcoTScrollbar 5
#define XcoTList 6
#define XcoTToggle 7
#define XcoTBox3D 8
#define XcoTHorizLine 9
#define XcoTTriangle 10
#define XcoTPulldownList 11
#define XcoTProgressbar 12
#define XcoTProgressWindow 13
#define XcoTColorselbox 14
#define XcoTColorselector 15
#define XcoTDialogParent 16


/* resize methods */
#define XcoResize 0
#define XcoUpLeft 1
#define XcoDownLeft 2
#define XcoUpRight 3
#define XcoDownRight 4
#define XcoUpResize 5
#define XcoDownResize 6
#define XcoResizeLeft 7
#define XcoResizeRight 8
#define XcoUpLeftDownRight 9

void __XcoInitObjects();

void XcoSetQueryVisual(int (*dvq)(Display *dpy,int screen, XVisualInfo *vis),
		       void (*dvpp)(Display *dpy,int screen, XVisualInfo *vis));

typedef enum {
    XcoInitNoError,
    XcoInitNoDisplay,
    XcoInitNoVisuals,
    XcoInitNoOtherVisuals,
    XcoInitBadMask,
    XcoInitBadColormap,
    XcoInitTooManyColors,
    XcoInitNoFonts,
} XcoInitError_t;

int XcoInit();
XcoInitError_t XcoGetInitError();


int XcoGetPixel(int x, int y,int r,int g, int b);
int XcoGetPixel32(int x, int y,int pixel);
int XcoGetReversePixel(int pixel);

int XcoGetDefaultBackground();
int XcoGetDefaultForeground();
void XcoSetDefaultForeground(int pixel);
void XcoSetDefaultBackground(int pixel);


Display *XcoGetDisplay();
Colormap XcoGetColormap();
Visual *XcoGetVisual();
int XcoGetScreen();
int XcoGetScreenWidth();
int XcoGetScreenHeight();
int XcoGetDepth();
int XcoGetBytesPerPixel();
int XcoGetPad();
int XcoGetPadByte();
int XcoGetNPad();
int XcoDefaultVisualQuery();
int XcoWParamsQuery();
void XcoDitherImage(uint32 *from,unsigned char *to,int i_x,int i_y,int ditherdepth);

XcoObject XcoCreateObject(XcoObject parent,XcoType type,
			  int x,int y,int width,int height);

void XcoDeleteObject(XcoObject id);

int XcoGetObjectX(XcoObject id);
int XcoGetObjectY(XcoObject id);
int XcoGetObjectWidth(XcoObject id);
int XcoGetObjectHeight(XcoObject id);

void XcoAddCallback(XcoObject id,void (*callback)(XcoObject id,XEvent event));
void XcoExecuteCallbacks(XcoObject id,XEvent event);
XcoObject __XcoGetCurrentProcess();
void __XcoSetCurrentProcess(XcoObject process);


#define PIXEL(r,g,b) ((b<<16)+(g<<8)+r)
#define R_OF_PIXEL(p) (p&0xFF)
#define G_OF_PIXEL(p) ((p>>8)&0xFF)
#define B_OF_PIXEL(p) ((p>>16)&0xFF)
#define DEFAULT_BACKGROUND (XcoGetDefaultBackground())
#define DEFAULT_FOREGROUND (XcoGetDefaultForeground())

void XcoWindowTile(Pixmap pixmap);
void XcoWindowNoTile();

XcoObject XcoCreateWindow(int x,int y,int width,int height,
			  int backgroundpixel,
			  int managed,
			  XcoObject parent);

XcoObject XcoCreateNamedWindow(int x,int y,int width,int height,
			       int backgroundpixel,
			       int managed,
			       XcoObject parent,
			       char *name);

char *XcoGetApplicationName();
char *XcoGetApplicationClass();
void XcoSetApplicationClass(char *name);
void XcoSetApplicationName(char *name);

void XcoSetResizeMethod(XcoObject id,int resizemethod);
int XcoGetBackground(XcoObject id);
void XcoSetBackground(XcoObject id, int background);
void XcoSetForeground(XcoObject id, int foreground);
void XcoSetBackgroundPixmap(XcoObject id, Pixmap pixmap,Bool exposure);

void XcoDeleteObject(XcoObject id);
int XcoDeleteWindow(XcoObject id,XEvent event);

Window XcoWindow(XcoObject id);
GC XcoGC(XcoObject id);

void XcoFlush();

void XcoDrawPolyLineRGB(XcoObject id,XPoint *points,int npoints, 
		  int r,int g,int b);

void XcoDrawPolyLine(XcoObject id,XPoint *points,int npoints, 
		  int pixel);

void XcoDraw3DBox(XcoObject id,int x,int y,int width,int height);
void XcoDrawInverted3DBox(XcoObject id,int x,int y,int width,int height);
void XcoDrawDecoratedBox(XcoObject id,int x,int y,int width,int height);
void XcoFillBox(XcoObject id,int x,int y,int width,int height,int pixel);
XFontStruct *XcoLoadFont(char *name);

int XcoTextWidth(XFontStruct *fstruct,char *str);
int XcoTextHeight(XFontStruct *fstruct);
void XcoUseFont(XcoObject id,XFontStruct *fstruct);
void XcoDrawFont(XcoObject id,int x,int y,char *str,int pixel);
void XcoDrawImageFont(XcoObject id,int x,int y,char *str,int foregroundpixel,int backgroundpixel);

void XcoLabelFont(XFontStruct *fstruct);
XcoObject XcoCreateLabel(XcoObject parent,
			 int x,int y,char *str,int width,int height);
void XcoSetLabelString(XcoObject id,char *str);
void __expose_label(XcoObject id);
void __remove_label(XcoObject id);

void XcoCommandFont(XFontStruct *fstruct);
XcoObject XcoCreateCommand(XcoObject parent,
			 int x,int y,char *str,int width,int height);

void __expose_command(XcoObject id);
void __remove_command(XcoObject id);

XcoObject XcoCreateHole(XcoObject parent,
			int x,int y,int width,int height);

void XcoDialogFont(XFontStruct *fstruct);
XcoObject XcoCreateDialog(XcoObject parent,
			  int x,int y,XcoObject dialogparent,
			  char *str,int maxchars,
			  int width,int height);

char *XcoGetDialogValue(XcoObject id);
void XcoSetDialogValue(XcoObject id,char *str);
int XcoDialogEnter(XcoObject id, XEvent event);

void __expose_dialog(XcoObject id);
void __remove_dialog(XcoObject id);

void __remove_dialogparent(XcoObject id);
XcoObject XcoCreateDialogParent(XcoObject parent,
				int x,int y,int width,int height);

XcoObject XcoCreateNamedDialogParent(XcoObject parent,
				     int x,int y,int width,int height,
				     char *name);

XcoObject XcoCreateScrollbar(XcoObject parent,
			     int x,int y,int width,int height,
			     float handle_size,float handle_pos,int type);

typedef struct
{
  int action;
  float handle_position;
  float handle_size;
} XcoScrollbarData ;

#define ScrollbarNoAction 0
#define ScrollbarButtonUp 1
#define ScrollbarButtonDown 2
#define ScrollbarButtonLeft 1
#define ScrollbarButtonRight 2
#define ScrollbarHandle 3

#define ScrollbarVert 0
#define ScrollbarHoriz 1

int XcoGetScrollbarStatus(XcoObject id,XcoScrollbarData *data);
void XcoSetScrollbarHandlePos(XcoObject id,float handle_pos);
void XcoSetScrollbarHandleSize(XcoObject id,float handle_size);


void __expose_scrollbar(XcoObject id);



void XcoListFont(XFontStruct *fstruct);

XcoObject XcoCreateList(XcoObject parent,
			int x,int y,int width,int height,int scrollbarsize,
			char **str,int elements);

void XcoSetListData(XcoObject id,char **str,int elements);
int XcoGetListStatus(XcoObject id);
void XcoSetListStatus(XcoObject id, int select_item);

XcoObject XcoCreateToggle(XcoObject parent,
			  int x,int y,int width,int height,
			  int selected_pixel,int autosel,int selected);

void XcoSetToggleSelected(XcoObject id,int selected);
int XcoGetToggleSelected(XcoObject id);

void XcoExposeObject(XcoObject id);
void XcoMoveWindow(XcoObject id,int x,int y);
void XcoMoveResizeWindow(XcoObject id,int x,int y,int width,int height);
void XcoIntelliResize(XcoObject id,int width,int height);

void XcoAddWorkProc(int (*wp)());
void XcoProcessEvents();
void XcoPollEvents();
void XcoWaitForEvents();

XcoObject XcoCreateBox3D(XcoObject parent,
			 int x,int y,int width,int height,int inverted,int show);

void XcoSetBox3DStatus(XcoObject id,int show);

void XcoSetBox3DInverted(XcoObject id,int inverted);

XcoObject XcoCreateHorizLine(XcoObject parent,
			     int x,int y,int width,int height);

XcoObject XcoCreateTriangle(XcoObject parent,
			 int x,int y,int width,int height);

void XcoSetTriangleStatus(XcoObject id,int pressed);

#define MENU_TOPLEVEL -1

void XcoMenuFont(XFontStruct *fstruct);
XcoMenu XcoCreateMenu(XcoMenu parent,int position,char *mstring[],int no_items);
XcoMenu XcoCreateMenuWithID(XcoMenu id,XcoMenu parent,int position,char *mstring[],int no_items);
void XcoSetMenuItemToggleable(XcoMenu id,int item,int toggleable,int activated);
void XcoSetMenuItemActivated(XcoMenu id,int item,int activated);
int XcoGetMenuItemActivated(XcoMenu id,int item);
void XcoOpenMenu(XcoObject parent,XcoMenu id,int x,int y,void(*callback)(int,int),void *parentdata);
void *XcoGetMenuParentdata(XcoMenu id);
void XcoDeleteMenu(XcoMenu id);
void XcoRemoveAnyMenu(XcoMenu id,int position);
void XcoCreateMenubar(XcoObject parent,int x,int y,int width,int nr,char *names[],XcoMenu ids[],void(*callback)(int,int,int),int right_justify_last_item);
void XcoAttachSubMenu(XcoMenu parent,int position,XcoMenu menu);
void XcoChangeMenu(XcoMenu id,XcoMenu parent,int position,char *mstring[],int no_items);

void XcoPulldownListFont(XFontStruct *fstruct);

XcoObject XcoCreatePulldownList(XcoObject parent,int x,int y,char **str,int items,int active_item,int width,int height);
int XcoGetPulldownListStatus(XcoObject id);

void __remove_pulldownlist(XcoObject id);

void XcoFileDialog(char *windowname,char *okbuttonname,char **filters,int no_filters,int (*callback)(char *filename));

void XcoWriteCimage(char *filename,int xsize,int ysize,unsigned int *buffer,char *image_name);

unsigned int *XcoCimageToImage(unsigned char *data,int xsize,int ysize);

Pixmap XcoCreatePixmapFromImage(XcoObject id,unsigned int *myimage,int xsize,int ysize);

Pixmap XcoCreatePixmapFromCimage(XcoObject id,unsigned char *data,int xsize,int ysize);

XcoObject XcoCreateProgressbar(XcoObject parent,
			     int x,int y,int width,int height,
			     float handle_size);

float XcoGetProgressbarSize(XcoObject id);
void XcoSetProgressbarSize(XcoObject id,float handle_size);

void XcoProgressWindowFont(XFontStruct *fstruct);
XcoObject XcoCreateProgressWindow(char *title);
void XcoSetProgressWindowHandleSize(XcoObject id,float size);


XcoObject XcoCreateColorselbox(XcoObject parent,
			       int x,int y,int width,int height,
			       int r,int g,int b,
			       int r1,int g1,int b1,
			       int r2,int g2,int b2,
			       float xpos,float ypos,
			       int squared);

void XcoSetColorselboxMode(XcoObject id,int squared);

void XcoSetColorselboxColor(XcoObject id,int r,int g,int b);
uint32 XcoGetColorselboxColor(XcoObject id);

XcoObject XcoCreateColorselector(XcoObject parent,
				 int x,int y,int width,int height,
				 int r,int g,int b,
				 void (*callback)(int r,int g,int b,int ok));

void XcoCallColorselectorCallback(XcoObject id);

XcoObject XcoColorselector(int r,int g,int b,
			   void (*callback)(int r,int g,int b,int ok));

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif


#endif

