#!/bin/sh
MYUSER=`whoami`
UNAME=`uname`
UNAMEM=`uname -m |sed 's/i.86/i386/'`
UNAME=$UNAME.$UNAMEM
# if you do not want the libraries and include files installed. Set DOLIBINCLUDEINSTALL to 0
DOLIBINCLUDEINSTALL=1
if [ $MYUSER = root ]; then
# Special root install. Install binary to /usr/local/bin, libraries to /usr/local/lib,
# and files needed by ymol to /usr/local/lib/ymol
# You are of course free to change these to whatever you like... :-)
    BININSTALL=/usr/local/bin
    YMOLINSTALL=/usr/local/lib/ymol
    LIBINSTALL=/usr/local/lib
    INCLUDEINSTALL=/usr/local/include
else
    BININSTALL=$HOME/bin
    YMOLINSTALL=$HOME/.ymol
    LIBINSTALL=$HOME/lib/$UNAME
    INCLUDEINSTALL=$HOME/lib/$UNAME
fi

if [ -d $BININSTALL ]; then
    echo Directory $BININSTALL already exists
else
    echo Creating directory $BININSTALL
    mkdir -p $BININSTALL
fi
echo Installing binary to $BININSTALL

rm -f $BININSTALL/ymol.$UNAME
cp src/ymol $BININSTALL/ymol.$UNAME
cp misc/oswrap.sh $BININSTALL
chmod +x misc/t2mol
cp misc/t2mol $BININSTALL
rm -f $BININSTALL/ymol
ln -s oswrap.sh $BININSTALL/ymol
cp scripts/ymolssh scripts/vaspymol $BININSTALL

if [ -d $YMOLINSTALL ]; then
    echo Directory $YMOLINSTALL already exists
else
    echo Creating directory $YMOLINSTALL
    mkdir -p $YMOLINSTALL
fi
echo Installing files needed by ymol to $YMOLINSTALL
cp src/.ymol/*.y4 $YMOLINSTALL

echo Checking for old .ymolrc
if [ -r $HOME/.ymolrc ]; then
    echo Backing up old $HOME/.ymolrc to $HOME/.ymolrc.old
    mv $HOME/.ymolrc $HOME/.ymolrc.old
fi

if [ $DOLIBINCLUDEINSTALL = 1 ]; then
    if [ -d $LIBINSTALL ]; then
	echo Directory $LIBINSTALL already exists
    else
	echo Creating directory $LIBINSTALL
	mkdir -p $LIBINSTALL
    fi
    echo Installing libraries to $LIBINSTALL
    cp src/libymol.a $LIBINSTALL

    if [ -d $INCLUDEINSTALL ]; then
	echo Directory $INCLUDEINSTALL already exists
    else
	echo Creating directory $INCLUDEINSTALL
	mkdir -p $INCLUDEINSTALL
    fi
    echo Installing include files to $INCLUDEINSTALL
    cp src/ymolsock.h $INCLUDEINSTALL
fi

echo Installation complete
echo Make sure you have $BININSTALL in the path
